/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVPError;

public class MTAlarmThreadImpl
extends Thread {
    private static boolean run_status = true;
    private static boolean terminate_status = false;
    private static int alarm_time = 3;

    public MTAlarmThreadImpl() {
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            alarm_time = this.getSlaveAlarmTime();
            System.err.println("Alarm Time set to " + alarm_time);
        }
        catch (Exception ce) {
            JVPError.unexpectedException(false, ce);
        }
        while (this.getRunStatus()) {
            try {
                MTAlarmThreadImpl.sleep(alarm_time * 1000);
                this.alarmHandling();
            }
            catch (InterruptedException ce) {
                JVPError.unexpectedException(false, ce);
            }
        }
        System.err.println("MT Alarm thread terminate");
        MTAlarmThreadImpl.setTerminateStatus();
    }

    synchronized boolean getRunStatus() {
        return run_status;
    }

    public static synchronized boolean getTerminateStatus() {
        return terminate_status;
    }

    public static synchronized void terminate() {
        run_status = false;
    }

    static synchronized void setTerminateStatus() {
        terminate_status = true;
    }

    synchronized void setAlarmTime(int alarm_interval) {
        alarm_time = alarm_interval;
    }

    native void alarmHandling();

    native int getSlaveAlarmTime();
}

