/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.Semaphore;

public class SemaphoreImpl
implements Semaphore {
    private int count;
    private String name = null;

    public SemaphoreImpl(String semaphoreName) {
        this.name = semaphoreName;
        if (this.name == null) {
            this.name = "<unknown>";
        }
        JVP.traceable.tracePrint("JVP.Semaphore", 5, "New " + this.name + " " + this.toString());
        this.count = 0;
    }

    public SemaphoreImpl(int count) {
        this.name = "unknown";
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void P() {
        SemaphoreImpl semaphoreImpl = this;
        synchronized (semaphoreImpl) {
            while (this.count == 0) {
                JVP.traceable.tracePrint("JVP.Semaphore", 5, "P() waits " + this.name);
                try {
                    this.wait();
                }
                catch (Exception ex) {
                    JVP.traceable.tracePrint("JVP.Semaphore", 5, "P() exception " + ex);
                }
            }
            this.count = 0;
            JVP.traceable.tracePrint("JVP.Semaphore", 5, "P() ends " + this.name + " " + this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void V() {
        SemaphoreImpl semaphoreImpl = this;
        synchronized (semaphoreImpl) {
            ++this.count;
            JVP.traceable.tracePrint("JVP.Semaphore", 5, "V() ends " + this.name + " " + this.count);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statelessV() {
        SemaphoreImpl semaphoreImpl = this;
        synchronized (semaphoreImpl) {
            if (this.count == 0) {
                ++this.count;
                JVP.traceable.tracePrint("JVP.Semaphore", 5, "statelessV() ends " + this.name + " " + this.count);
            }
            this.notify();
        }
    }

    public String getName() {
        return this.name;
    }
}

