/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.DBA;
import informix.jvp.JVP;
import informix.jvp.JVPService;
import informix.jvp.JVPServiceQueue;
import informix.jvp.ServiceDirectory;
import informix.jvp.impl.JVPServiceImpl;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class ServiceDirImpl
extends UnicastRemoteObject
implements ServiceDirectory {
    private static int numServices = 0;
    static Vector services = null;

    public ServiceDirImpl(int vp_id) throws RemoteException {
        Registry registry = LocateRegistry.getRegistry();
        try {
            String reg = "/" + JVP.properties.getProperty("JVP.name") + ":" + vp_id + "/ServiceDirectory";
            JVP.log.log("DBA API: binding to '" + reg + "'");
            registry.rebind(reg, this);
        }
        catch (Exception e) {
            JVP.log.log("ServiceDirectory rebind err: " + e.getMessage());
            if (e instanceof ConnectException) {
                JVP.log.log("Could not connect to RMI, rmiregistry probably not running");
            }
            if (e instanceof java.rmi.ConnectException) {
                JVP.log.log("Could not connect to RMI, rmiregistry probably not running");
            }
            e.printStackTrace();
        }
        if (JVP.log != null) {
            JVPServiceImpl logService = null;
            logService = new JVPServiceImpl(JVP.log, "Logger");
            try {
                this.addService(logService);
            }
            catch (RemoteException rmie) {
                JVP.log.log("LogTest exception: " + rmie.getMessage());
                rmie.printStackTrace();
            }
            JVP.log.setService(logService);
            logService.start();
        } else {
            JVP.log.log(" Log is null");
        }
        if (JVP.traceable == null) {
            JVP.log.log(" traceable is null");
            return;
        }
        JVPServiceImpl traceService = null;
        traceService = new JVPServiceImpl(JVP.traceable, "Tracer");
        try {
            this.addService(traceService);
        }
        catch (RemoteException rmie) {
            JVP.log.log("LogTest exception: " + rmie.getMessage());
            rmie.printStackTrace();
        }
        JVP.traceable.setService(traceService);
        traceService.start();
    }

    @Override
    public void addService(JVPService service) throws RemoteException {
        if (services == null) {
            services = new Vector(10, 5);
        }
        JVP.log.log("Registering service " + service.getServiceName());
        services.addElement(service);
    }

    @Override
    public JVPServiceQueue register(String serviceName) throws RemoteException {
        JVPService servimpl = null;
        servimpl = this.findServiceByName(serviceName);
        return servimpl.register();
    }

    @Override
    public void unregister(String serviceName, JVPServiceQueue queue) throws RemoteException {
        JVPService servimpl = null;
        JVP.log.log("SDI: unregister");
        servimpl = this.findServiceByName(serviceName);
        servimpl.unregister(queue);
    }

    @Override
    public String[] getJVPServiceList() throws RemoteException {
        JVPService servimpl = null;
        String[] ret = new String[services.size()];
        Vector v = new Vector();
        for (int index = 0; index < services.size(); ++index) {
            servimpl = (JVPService)services.elementAt(index);
            ret[index] = servimpl.getServiceName();
        }
        return ret;
    }

    @Override
    public JVPService findServiceByName(String name) throws RemoteException {
        JVPService servimpl = null;
        int index = 0;
        if (services == null || services.size() == 0) {
            if (services == null) {
                JVP.log.log("findServiceByName: services list is null");
            }
            return null;
        }
        index = 0;
        while (index < services.size()) {
            if (!(servimpl = (JVPService)services.elementAt(index++)).getServiceName().equalsIgnoreCase(name)) continue;
            JVP.log.log("returning service " + servimpl.getServiceName());
            return servimpl;
        }
        return null;
    }

    @Override
    public void traceSet(String zone, int traceLev) throws RemoteException {
        JVP.traceable.traceSet(zone, traceLev);
        JVP.traceable.tracePrint("JVP", 1, "Set zone " + zone + " to level " + traceLev);
    }

    @Override
    public void traceSet(int zone, int traceLev) throws RemoteException {
        JVP.traceable.traceSet(zone, traceLev);
        JVP.traceable.tracePrint("JVP", 1, "Set zone " + zone + " to level " + traceLev);
    }

    @Override
    public int traceLevel(String zone) throws RemoteException {
        return JVP.traceable.traceLevel(zone);
    }

    @Override
    public String traceGetZoneTable() throws RemoteException {
        return JVP.traceable.toString();
    }

    @Override
    public Vector getSolanoThreadIds() throws RemoteException {
        return DBA.getSolanoThreadIds();
    }

    @Override
    public Vector listSolanoThreads() throws RemoteException {
        return DBA.listSolanoThreads();
    }

    @Override
    public boolean killSolanoConnection(int threadnum) throws RemoteException, Exception {
        String user = System.getProperty("user.name");
        return DBA.killSolanoConnection(threadnum, user);
    }

    @Override
    public boolean askSolanoThreadToDie(int thread) throws RemoteException, Exception {
        String user = System.getProperty("user.name");
        return DBA.askSolanoThreadToDie(thread, user);
    }
}

