/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.TimeStamp;
import informix.jvp.TraceStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TraceStreamImpl
extends PrintWriter
implements TraceStream {
    private boolean newline = true;
    private PrintWriter stream = null;
    private boolean verbose = true;
    private String ts_format = null;

    public TraceStreamImpl(PrintWriter stream) {
        super(stream);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceStreamImpl() {
        super(JVP.log.outStream());
        String fileProp = JVP.properties.getProperty("JVP.trace.file");
        if (fileProp != null) {
            try {
                FileOutputStream traceFile = new FileOutputStream(fileProp);
                this.stream = new PrintWriter(traceFile);
            }
            catch (IOException i) {
            }
            catch (SecurityException securityException) {
            }
            finally {
                if (this.stream == null) {
                    JVP.log.log("TraceStreamImpl: could not access " + fileProp + " using System.err for trace stream");
                    this.stream = JVP.log.outStream();
                }
            }
        } else {
            this.stream = JVP.log.outStream();
        }
    }

    @Override
    public void setVerbose(boolean v) {
        this.verbose = v;
        JVP.log.log("TraceStreamImpl: set verbose to " + this.verbose);
    }

    @Override
    public void write(int b) {
        this.emit(Integer.toString(b));
    }

    @Override
    public void setError() {
        super.setError();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.emit(new String(buf, off, len));
    }

    @Override
    public void print(boolean b) {
        this.emit(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.emit(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.emit(Integer.toString(i));
    }

    @Override
    public void print(long l) {
        this.emit(Long.toString(l));
    }

    @Override
    public void print(float f) {
        this.emit(Float.toString(f));
    }

    @Override
    public void print(double d) {
        this.emit(Double.toString(d));
    }

    @Override
    public void print(char[] s) {
        this.emit(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.emit(s);
    }

    @Override
    public void print(Object obj) {
        this.emit(obj.toString());
    }

    @Override
    public void println(boolean b) {
        this.emit(String.valueOf(b) + '\n');
    }

    @Override
    public void println(char c) {
        this.emit(c + "\n");
    }

    @Override
    public void println(int i) {
        this.emit(Integer.toString(i) + '\n');
    }

    @Override
    public void println(long l) {
        this.emit(Long.toString(l) + '\n');
    }

    @Override
    public void println(float f) {
        this.emit(Float.toString(f) + '\n');
    }

    @Override
    public void println(double d) {
        this.emit(Double.toString(d) + '\n');
    }

    @Override
    public void println(char[] s) {
        this.emit(String.valueOf(s) + '\n');
    }

    @Override
    public void println(String s) {
        this.emit(s + '\n');
    }

    @Override
    public void println(Object obj) {
        this.emit(obj.toString() + '\n');
    }

    private synchronized void emit(String message) {
        if (message == null || message.length() <= 0) {
            return;
        }
        if (this.stream == JVP.log.outStream()) {
            if (message.charAt(message.length() - 1) == '\n') {
                JVP.log.log(message.substring(0, message.length() - 1));
            } else {
                JVP.log.log(message);
            }
            this.newline = true;
        } else {
            this.stream.print(this.newline ? TimeStamp.now() + ": " + message : message);
            if (this.stream.checkError()) {
                JVP.log.log("TraceStreamImpl:I/O Error on trace stream");
            }
        }
        if (message.charAt(message.length() - 1) == '\n') {
            this.newline = true;
        }
    }
}

