/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.JVPService;
import informix.jvp.Traceable;
import informix.jvp.impl.TraceStreamImpl;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TraceableImpl
implements Traceable {
    private static Hashtable zoneTable;
    private transient PrintWriter traceStream;
    private static JVPService traceService;
    private static boolean verbose;

    public TraceableImpl() {
        this.traceStream = JVP.log.outStream();
    }

    public TraceableImpl(PrintWriter traceStream) {
        this.traceStream = traceStream;
    }

    @Override
    public void resetTraceStream(PrintWriter tracesStream) {
        this.traceStream = this.traceStream;
    }

    public static void zoneTabInit(String property) {
        if (property == null) {
            JVP.log.log("TraceableImpl: trace settings property is null");
            return;
        }
        zoneTable = new Hashtable(128);
        StringTokenizer tok = new StringTokenizer(property, "=,");
        while (tok.hasMoreTokens()) {
            String zone = tok.nextToken();
            try {
                Integer level;
                String levelStr = tok.nextToken().trim();
                try {
                    level = Integer.valueOf(levelStr);
                }
                catch (NumberFormatException nfe) {
                    level = new Integer(-1);
                }
                if (level < 0) {
                    JVP.log.log("TraceableImpl: Poorly formatted trace zone settings:" + zone + " = " + levelStr);
                    continue;
                }
                zoneTable.put(zone, level);
            }
            catch (NoSuchElementException nse) {
                JVP.log.log("TraceableImpl: Poorly formatted trace zone settings:" + property);
            }
        }
    }

    @Override
    public void setVerbose(String property) {
        if (property == null) {
            return;
        }
        int level = Integer.valueOf(property);
        verbose = level > 0;
        ((TraceStreamImpl)this.traceStream).setVerbose(verbose);
        JVP.log.setVerbose(verbose);
    }

    @Override
    public void setTimeStampFormat(String property) {
        JVP.log.setTimeStampFormat(property);
    }

    public String flagToZone(int flag) {
        return "JVP.JavaAPI";
    }

    public String stripZone(String zone) {
        int ind = zone.lastIndexOf(46);
        String superZone = ind < 0 ? null : zone.substring(0, ind);
        return superZone;
    }

    @Override
    public void tracePrint(int flag, int traceLevel, String traceMessage) {
        this.tracePrint(this.flagToZone(flag), traceLevel, traceMessage);
    }

    @Override
    public void tracePrint(int flag, int traceLevel, byte[] ba) {
        this.tracePrint(this.flagToZone(flag), traceLevel, ba);
    }

    @Override
    public int traceLevel(int flag) {
        return this.traceLevel(this.flagToZone(flag));
    }

    @Override
    public boolean traceSet(int flag, int level) {
        this.traceSet(this.flagToZone(flag), level);
        return true;
    }

    @Override
    public void traceFile(PrintWriter stream) {
        this.traceStream = stream;
    }

    @Override
    public PrintWriter traceFile() {
        return this.traceStream;
    }

    @Override
    public int traceLevel(String zone) {
        if (zoneTable == null) {
            return 0;
        }
        Integer level = (Integer)zoneTable.get(zone);
        while (level == null && (zone = this.stripZone(zone)) != null) {
            level = (Integer)zoneTable.get(zone);
        }
        return level == null ? -1 : level;
    }

    @Override
    public void traceSet(String zone, int traceLev) {
        if (zoneTable == null) {
            zoneTable = new Hashtable(128);
        }
        Integer level = new Integer(traceLev);
        zoneTable.put(zone, level);
    }

    @Override
    public void tracePrint(String zone, int level, String message) {
        try {
            int traceLev = this.traceLevel(zone);
            if (traceLev != 0 && traceLev >= level) {
                if (verbose) {
                    this.traceStream.println("Trace: " + zone + ": " + message);
                } else {
                    this.traceStream.println(message);
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    @Override
    public void tracePrint(String zone, int level, byte[] ba) {
        int traceLev = this.traceLevel(zone);
        if (traceLev == 0 || traceLev < level) {
            return;
        }
        this.dumpByteArray(ba, 'H');
        if (traceService != null) {
            traceService.addToQueue("Trace: " + zone + ": " + ba);
        }
    }

    @Override
    public void setService(JVPService service) {
        traceService = service;
    }

    @Override
    public String toString() {
        if (zoneTable == null) {
            return "zone table uninitialized";
        }
        return zoneTable.toString();
    }

    private void dumpByteArray(byte[] byteData, char format) {
        boolean j = false;
        boolean hexOnly = true;
        Object strAscii = null;
        Object strHex = null;
        int bytesDisplayed = 22;
    }

    static {
        traceService = null;
        verbose = true;
        zoneTable = null;
    }
}

