/*
 * Decompiled with CFR 0.152.
 */
package udf;

import java.io.Serializable;

public class GeometricMean {
    public static State initialize() {
        return new State();
    }

    public static void iterate(State aggrState, Number value) {
        aggrState.iterate(value);
    }

    public static Double terminate(State aggrState) {
        return aggrState.terminate();
    }

    public static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double accumulator = 0.0;
        private int count = 0;

        public void iterate(Number value) {
            if (value == null) {
                return;
            }
            ++this.count;
            this.accumulator += Math.log(value.doubleValue());
        }

        public Double terminate() {
            if (this.count == 0) {
                return null;
            }
            return Math.exp(this.accumulator / (double)this.count);
        }
    }
}

