/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.rave2bundlepackedbubble.renderer;

import com.ibm.vida.rave.bundles.data.HierarchyBundleDatum;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.library.framework.CustomFormatInfo;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vida.rave.library.framework.RenderCompleteCallback;
import com.ibm.vida.vizbundles.common.SizeCategory;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.VidaRaveBundleRenderingServiceBase;
import com.ibm.vida.vizbundles.common.rave2bundle.DataHandlingEnum;
import com.ibm.vida.vizbundles.common.rave2bundle.HierarchyNodeDatum;
import com.ibm.vida.vizbundles.common.rave2bundle.HierarchyUtility;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleCustomFormatterTarget;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleDataModel;
import com.ibm.vipr.renderingservice.api.IInteractivity;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.api.IRSInitializationParameters;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.PaletteType;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSPropertyApi;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.renderingservice.util.Bounds;
import com.ibm.vipr.renderingservice.util.Capability;
import com.ibm.vipr.renderingservice.util.CatEncoding;
import com.ibm.vipr.renderingservice.util.ContEncoding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Rave2BundlePackedBubbleRenderer
extends VidaRaveBundleRenderingServiceBase {
    private static final String CATEGORIES_SLOT = "categories";
    private static final String SIZE_SLOT = "size";
    private static final String COLOR_SLOT = "color";
    private static final int SMALL_VISUALIZATION_WIDTH = 200;
    private static final int SMALL_VISUALIZATION_HEIGHT = 200;
    private static final int LARGE_VISUALIZATION_WIDTH = 300;
    private static final int LARGE_VISUALIZATION_HEIGHT = 300;
    private static final Font DEFAULT_FONT = Font.create(null, (Length)Length.parse((String)"0.75em"), null, null);
    private static final Font DEFAULT_FONT_SMALL = Font.create(null, (Length)Length.parse((String)"0.65em"), null, null);
    private IRSCatPaletteProperty _colorCatPalette;
    private IRSContPaletteProperty _colorContPalette;
    private boolean _dataDirty;
    private IRSDataSet _dataSet;
    private IRSSlot _categoriesSlot;
    private IRSSlot _sizeSlot;
    private IRSSlot _colorSlot;
    private boolean _hasCategories;
    private boolean _hasSize;
    private boolean _hasColor;
    private boolean _colorIsCategorical;
    private boolean _colorIsContinuous;

    public Rave2BundlePackedBubbleRenderer() {
        super("rave-library-bubble", null, "Rave2BundlePackedBubbleRenderer", "rave2bundlepackedbubble.css");
    }

    public void _init(IRSInitializationParameters _params, IRSHostAPI _hostApi, Map<String, Object> _resources) {
        this._colorCatPalette = this._properties.getCatPalette("colors.categories");
        this._colorContPalette = this._properties.getContPalette("colors.color");
        this.raveBundle.setProperty("legend.display", (Object)false);
        this.raveBundle.setProperty("itemLabel.wrap", (Object)true);
        this.raveBundle.setProperty("itemLabel.overlap", (Object)true);
        this.raveBundle.setProperty("packedBubbleNegativeValueDisplay", (Object)true);
        this.raveBundle.setProperty("effect.duration", this._properties.get("effect.duration").getValue());
        this.raveBundle.setProperty("pack", this._properties.get("pack").getValue());
        this.raveBundle.setProperty("color.null", (Object)"gray");
        this.raveBundle.setProperty("effect.duration", (Object)0);
        this.raveBundle.setProperty("layout.padding", (Object)"0");
    }

    public void setData(IRenderingServiceData _data) {
        if (_data == null) {
            return;
        }
        this._dataDirty = true;
        this._dataSet = _data.getDataSetAt(0);
        this._categoriesSlot = this._dataSet.getSlot(CATEGORIES_SLOT);
        this._sizeSlot = this._dataSet.getSlot(SIZE_SLOT);
        this._colorSlot = this._dataSet.getSlot(COLOR_SLOT);
        this._hasCategories = this._categoriesSlot.isMapped();
        this._hasSize = this._sizeSlot.isMapped();
        this._hasColor = this._colorSlot.isMapped();
        this._colorIsCategorical = this._hasColor && this._colorSlot.getDataItem(0).getType() == RSDataItemType.Cat;
        this._colorIsContinuous = this._hasColor && this._colorSlot.getDataItem(0).getType() == RSDataItemType.Cont;
        this.raveBundle.setProperty("effect.duration", (Object)0);
        this._setData();
    }

    private void _setData() {
        ArrayList<HierarchyNodeDatum> nodeData = new ArrayList<HierarchyNodeDatum>();
        DataHandlingEnum dataHandling = DataHandlingEnum.parse((String)((String)this._properties.getEnum("dataHandling").getValue()));
        this.raveBundle.setDataModel(dataHandling);
        Rave2BundleDataModel dataModel = this.raveBundle.getDataModel();
        dataModel.setDataSlot("data", "label", "string", d -> d == null ? null : ((HierarchyNodeDatum)d).caption);
        dataModel.setDataSlot("data", "key", "string", d -> d == null ? null : ((HierarchyNodeDatum)d).key);
        if (this._hasSize) {
            dataModel.setDataSlot("data", SIZE_SLOT, "numeric", d -> d == null ? null : ((HierarchyNodeDatum)d).size).setDomain(this._sizeSlot.getDataItem().asCont().getDomain());
        } else {
            dataModel.clearDataSlot("data", SIZE_SLOT);
        }
        if (this._hasColor) {
            if (this._colorIsContinuous) {
                dataModel.setDataSlot("data", COLOR_SLOT, "numeric", d -> d == null ? null : ((HierarchyNodeDatum)d).weight).setDomain(this._colorSlot.getDataItem().asCont().getDomain());
            } else {
                List tuples = this._colorSlot.getDataItem().asCat().getTuples();
                ArrayList<String> catDomain = new ArrayList<String>();
                for (IRSTuple tuple : tuples) {
                    catDomain.add(tuple.getKey());
                }
                dataModel.setDataSlot("data", COLOR_SLOT, "string", d -> d == null ? null : ((HierarchyNodeDatum)d).color).setCategoricalDomain(catDomain);
            }
        } else {
            dataModel.setDataSlot("data", COLOR_SLOT, "string", d -> d == null ? null : ((HierarchyNodeDatum)d).color).clearDomain();
        }
        for (IRSDataPoint dataPoint : this._dataSet.getDataPoints()) {
            String caption;
            String color = this._colorIsCategorical ? dataPoint.get(this._colorSlot).asCat().getKey() : "static";
            Double weight = this._colorIsContinuous ? Rave2Common.getValue((IRSDataPoint)dataPoint, (String)this._colorSlot.getName()) : null;
            Double size = this._hasSize ? Rave2Common.getValue((IRSDataPoint)dataPoint, (String)this._sizeSlot.getName()) : null;
            String key = "";
            IRSTuple categoryTuple = (IRSTuple)dataPoint.get(this._categoriesSlot);
            int itemCount = categoryTuple.getItemCount();
            String string = caption = dataHandling == DataHandlingEnum.Tabular ? categoryTuple.getCaption(RSFormatKind.Label) : categoryTuple.getItem(itemCount - 1).getCaption(RSFormatKind.Label);
            if (this._hasCategories) {
                Iterator itCategoryTupleItems = categoryTuple.getItems().iterator();
                StringBuilder keyBuilder = new StringBuilder();
                while (itCategoryTupleItems.hasNext()) {
                    IRSItem item = (IRSItem)itCategoryTupleItems.next();
                    if (keyBuilder.length() > 0) {
                        keyBuilder.append('x');
                    }
                    keyBuilder.append(item.getUniqueName());
                }
                if (this._hasColor) {
                    keyBuilder.append('x').append(color);
                }
                key = keyBuilder.toString();
            } else if (this._hasColor) {
                key = color;
            }
            HierarchyNodeDatum nodeDatum = new HierarchyNodeDatum(key, dataPoint, categoryTuple);
            nodeDatum.type = HierarchyNodeDatum.NodeType.Leaf;
            nodeDatum.size = size;
            nodeDatum.color = color;
            nodeDatum.weight = weight;
            nodeDatum.caption = caption;
            nodeData.add(nodeDatum);
        }
        if (dataHandling == DataHandlingEnum.Tabular) {
            dataModel.setData("data", nodeData);
            this.raveBundle.setProperty("itemColor", (Object)"1");
        } else {
            dataModel.setData("data", (Object)HierarchyUtility.buildHierarchy(nodeData));
            this.raveBundle.setProperty("itemColor", (Object)Integer.toString(this._categoriesSlot.getDataItem().asCat().getItemClassSet(0).getItemClassCount()));
            dataModel.setDataSlot("data", "children", "array", d -> d == null ? null : ((HierarchyNodeDatum)d).children);
        }
    }

    public void setProperty(String _name, Object _value) {
        switch (_name) {
            case "labels.visible": {
                this._properties.get("contrast.label.color").setActive(_value != null);
                this._properties.get("label.shadow").setActive(_value != null);
                break;
            }
        }
    }

    public IRSPropertyApi getPropertyApi() {
        return null;
    }

    public void render(IRSRenderInvalidation _invalidation, IRSRenderNotification _notification) {
        this._processProperties();
        this._optimizeVisualizationSize();
        if (!this.raveBundle.getDataModel().hasData()) {
            _notification.complete("no data", null);
            return;
        }
        this.raveBundle.render(this._properties, _notification);
    }

    protected void postProcessSceneTree(RenderCompleteCallback _notification) throws Exception {
        Rave.selectAll((String)".element-shape").style("fill-opacity", (Object)"0.9");
        Rave.selectAll((String)".packed-bubble-parent").style("fill-opacity", (Object)"0.25");
        _notification.renderComplete();
    }

    private void _optimizeVisualizationSize() {
        boolean showLabels = (Boolean)this._properties.getBoolean("labels.visible").getValue();
        Font defaultFont = DEFAULT_FONT;
        SizeCategory sizeCategory = this._getSizeCategory();
        if (((Boolean)this._properties.getBoolean("optimizeSize").getValue()).booleanValue() && sizeCategory.equals((Object)SizeCategory.Small)) {
            showLabels = false;
            defaultFont = DEFAULT_FONT_SMALL;
            this.raveBundle.setProperty("layout.padding.left", (Object)"0");
            this.raveBundle.setProperty("layout.padding.right", (Object)"0");
            this.raveBundle.setProperty("layout.padding.top", (Object)"0");
            this.raveBundle.setProperty("layout.padding.bottom", (Object)"0");
        } else {
            this.raveBundle.setProperty("layout.chart.padding.left", this._properties.getLength("visualization.padding.left").getValue());
            this.raveBundle.setProperty("layout.chart.padding.right", this._properties.getLength("visualization.padding.right").getValue());
            this.raveBundle.setProperty("layout.chart.padding.top", this._properties.getLength("visualization.padding.top").getValue());
            this.raveBundle.setProperty("layout.chart.padding.bottom", this._properties.getLength("visualization.padding.bottom").getValue());
        }
        this.raveBundle.setAttribute("class", (Object)("Rave2BundlePackedBubbleRenderer " + sizeCategory.name()));
        this.raveBundle.setProperty("itemLabel.display", (Object)showLabels);
        this.raveBundle.setProperty("labelstyle.font", (Object)Rave2Common.composeFontStylePropertyString((Font)Font.merge((Font)defaultFont, (Font)((Font)this._properties.getFont("labels.font").getValue())), (IRSColor)((IRSColor)this._properties.getColor("labels.color").getValue())));
    }

    private SizeCategory _getSizeCategory() {
        Bounds size = this.raveBundle.getSize();
        if (size.getWidth() <= 200.0 || size.getHeight() <= 200.0) {
            return SizeCategory.Small;
        }
        if (size.getWidth() >= 300.0 && size.getHeight() >= 300.0) {
            return SizeCategory.Large;
        }
        return SizeCategory.Medium;
    }

    private void _processProperties() {
        this._properties.forEach(_property -> {
            String key = _property.getName();
            Object value = _property.getValue();
            if (_property.isDirty()) {
                switch (key) {
                    case "dataHandling": {
                        if (this._dataSet == null) break;
                        this._setData();
                        break;
                    }
                    case "labels.format": {
                        this.raveBundle.setCustomFormatter(Rave2BundleCustomFormatterTarget.label, this._getItemLabelFormatter());
                        break;
                    }
                    case "backgroundColor": {
                        this.raveBundle.setProperty("background.chart.color", (Object)value.toString());
                        break;
                    }
                    case "backgroundColor.elements": {
                        this.raveBundle.setProperty("background.elements.color", (Object)value.toString());
                        break;
                    }
                    case "effect.duration": {
                        this.raveBundle.setProperty("effect.duration", value);
                        break;
                    }
                    case "contrast.label.color": {
                        this.raveBundle.setProperty("contrast.label.color", value);
                        break;
                    }
                    case "label.shadow": {
                        this.raveBundle.setProperty("label.shadow", value);
                        break;
                    }
                    case "pack": {
                        this.raveBundle.setProperty("pack", value);
                        break;
                    }
                    case "border.width": {
                        this.raveBundle.setProperty("symbol.borderWidth", (Object)value.toString());
                        break;
                    }
                    case "border.color": {
                        this.raveBundle.setProperty("symbol.borderColor", (Object)value.toString());
                        break;
                    }
                }
            }
        });
        if (this._colorIsContinuous && (this._dataDirty || this._colorContPalette.isDirty())) {
            this._setPalette((IRSPaletteProperty)this._colorContPalette, PaletteType.Cont);
        } else if (this._dataDirty || this._colorCatPalette.isDirty()) {
            this._setPalette((IRSPaletteProperty)this._colorCatPalette, PaletteType.Cat);
        }
    }

    private void _setPalette(IRSPaletteProperty _palette, PaletteType _paletteType) {
        IRSDataItem dataItem = this._dataSet.getSlot(_palette.getSlot()).getDataItem(0);
        String uniquePaletteId = "vida.colorpalette.rave2bundlepackedbubble." + this.getUniqueBundleId();
        if (_paletteType.equals((Object)PaletteType.Cat)) {
            List<Object> tuples;
            IRSCatPaletteProperty palette = (IRSCatPaletteProperty)_palette;
            List list = tuples = dataItem == null ? new ArrayList() : dataItem.asCat().getTuples();
            if (tuples.size() == 0) {
                tuples.add(null);
            }
            List colorValues = tuples.stream().map(_tuple -> palette.getColor(_tuple)).collect(Collectors.toList());
            this.raveBundle.createCatPalette(uniquePaletteId, colorValues);
        } else if (_paletteType.equals((Object)PaletteType.Cont)) {
            List colorStops = ((IRSContPaletteProperty)_palette).getColorStops(dataItem.asCont()).getStops();
            this.raveBundle.createContPalette(uniquePaletteId, colorStops);
        }
        this.raveBundle.setProperty("color.palette", (Object)uniquePaletteId);
    }

    private CustomFormatter _getItemLabelFormatter() {
        LabelFormat labelFormat = LabelFormat.valueOf((String)this._properties.getEnum("labels.format").getValue());
        switch (labelFormat) {
            case Value: {
                return new CustomFormatter(){

                    public String getValue(Object _label, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                        HierarchyBundleDatum data = Rave2BundlePackedBubbleRenderer.this.getLabelData(_label);
                        if (data == null || !Rave2BundlePackedBubbleRenderer.this._hasSize) {
                            return "";
                        }
                        HierarchyNodeDatum originalNodeData = (HierarchyNodeDatum)data.originalData();
                        IRSDataPoint dataPoint = ((IRSDataPoint[])originalNodeData.data)[0];
                        return ((IRSValue)dataPoint.get(Rave2BundlePackedBubbleRenderer.SIZE_SLOT)).getCaption(RSFormatKind.Label);
                    }
                };
            }
            case Both: {
                return new CustomFormatter(){

                    public String getValue(Object _label, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                        HierarchyBundleDatum data = Rave2BundlePackedBubbleRenderer.this.getLabelData(_label);
                        if (data == null) {
                            return "";
                        }
                        HierarchyNodeDatum originalNodeData = (HierarchyNodeDatum)data.originalData();
                        IRSDataPoint dataPoint = ((IRSDataPoint[])originalNodeData.data)[0];
                        String caption = "";
                        if (Rave2BundlePackedBubbleRenderer.this._hasCategories) {
                            caption = originalNodeData.caption;
                        } else if (Rave2BundlePackedBubbleRenderer.this._colorIsCategorical) {
                            caption = dataPoint.get(Rave2BundlePackedBubbleRenderer.this._colorSlot).getCaption(RSFormatKind.Label);
                        }
                        return Rave2BundlePackedBubbleRenderer.this._hasSize ? caption + " | " + ((IRSValue)dataPoint.get(Rave2BundlePackedBubbleRenderer.SIZE_SLOT)).getCaption(RSFormatKind.Label) : caption;
                    }
                };
            }
        }
        return new CustomFormatter(){

            public String getValue(Object _label, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                HierarchyBundleDatum data = Rave2BundlePackedBubbleRenderer.this.getLabelData(_label);
                if (data == null) {
                    return "";
                }
                String caption = "";
                HierarchyNodeDatum originalNodeData = (HierarchyNodeDatum)data.originalData();
                if (Rave2BundlePackedBubbleRenderer.this._hasCategories) {
                    caption = originalNodeData.caption;
                } else if (Rave2BundlePackedBubbleRenderer.this._colorIsCategorical) {
                    caption = originalNodeData.getDataPoint().get(Rave2BundlePackedBubbleRenderer.this._colorSlot).getCaption(RSFormatKind.Label);
                }
                return caption;
            }
        };
    }

    private HierarchyBundleDatum<HierarchyNodeDatum> getLabelData(Object _label) {
        HierarchyBundleDatum data = (HierarchyBundleDatum)Rave.select((SceneNode)((SceneNode)_label)).datum();
        return data;
    }

    public List<IRSEncoding> getEncodings() {
        ArrayList<IRSEncoding> encodings = new ArrayList<IRSEncoding>();
        if (this._dataSet != null) {
            IRSSlot dataSlot = this._dataSet.getSlot(SIZE_SLOT);
            if (dataSlot.isMapped()) {
                encodings.add((IRSEncoding)ContEncoding.fromDataSlot((IRSSlot)dataSlot, (String)SIZE_SLOT, (int)0, (RSFormatKind)RSFormatKind.Label, null, (IRSContPaletteProperty)this._colorContPalette));
            }
            if ((dataSlot = this._dataSet.getSlot(COLOR_SLOT)).isMapped()) {
                if (this._colorIsContinuous) {
                    encodings.add((IRSEncoding)ContEncoding.fromDataSlot((IRSSlot)dataSlot, (String)COLOR_SLOT, (int)0, (RSFormatKind)RSFormatKind.Label, null, (IRSContPaletteProperty)this._colorContPalette));
                } else {
                    encodings.add((IRSEncoding)CatEncoding.fromDataSlot((IRSSlot)dataSlot, (String)COLOR_SLOT, (int)0, (RSFormatKind)RSFormatKind.Label, (IRSCatPaletteProperty)this._colorCatPalette, (IRSDataContext)this._dataContext, (String)"circle"));
                }
            }
        }
        return encodings;
    }

    public List<IRSCapability> getCapabilities() {
        ArrayList<IRSCapability> caps = new ArrayList<IRSCapability>();
        caps.add((IRSCapability)Capability.limit((String)CATEGORIES_SLOT, (int)1000));
        caps.add((IRSCapability)Capability.limit((String)COLOR_SLOT, (int)500));
        return caps;
    }

    public IInteractivity getInteractivity() {
        return null;
    }

    protected double getMinimalVisualizationWidth() {
        return 75.0;
    }

    protected double getMinimalVisualizationHeight() {
        return 75.0;
    }

    private static enum LabelFormat {
        Item,
        Value,
        Both;

    }
}

