/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.rave2bundleradialbar.renderer;

import com.ibm.vida.rave.bundles.components.IntervalDataUtilities;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.library.framework.CustomFormatInfo;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vida.rave.library.framework.RenderCompleteCallback;
import com.ibm.vida.vizbundles.common.SizeCategory;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.VidaRaveBundleRenderingServiceBase;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleCustomFormatterTarget;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleDataModel;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleDataSlot;
import com.ibm.vida.vizbundles.rave2bundleradialbar.renderer.Rave2BundleRadialBarPropertyApi;
import com.ibm.vipr.renderingservice.api.IInteractivity;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.api.IRSInitializationParameters;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.PaletteType;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSPropertyApi;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.renderingservice.util.Bounds;
import com.ibm.vipr.renderingservice.util.Capability;
import com.ibm.vipr.renderingservice.util.CatEncoding;
import com.ibm.vipr.renderingservice.util.ContEncoding;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Rave2BundleRadialBarRenderer
extends VidaRaveBundleRenderingServiceBase {
    private static final String CATEGORIES_SLOT = "categories";
    private static final String COLOR_SLOT = "color";
    private static final String VALUES_SLOT = "values";
    private static final String MAX_VALUE_SLOT = "maxValue";
    private static final Capability CAPABILITY_CATSIZE = Capability.limit((String)"categories", (int)500);
    private static final Capability CAPABILITY_COLORSIZE = Capability.limit((String)"color", (int)200);
    private static final Capability CAPABILITY_DATASIZE = Capability.limit((String)"data", (int)500);
    private static final int SMALL_VISUALIZATION_WIDTH = 150;
    private static final int SMALL_VISUALIZATION_HEIGHT = 150;
    private static final Font DEFAULT_FONT = Font.create(null, (Length)Length.parse((String)"0.75em"), null, null);
    private IRSProperties _properties;
    private IRSDataContext _dataContext;
    private Locale _locale;
    private IRSDataSet _dataSet = null;
    private IRSSlot _categoriesSlot;
    private IRSSlot _colorSlot;
    private IRSSlot _valuesSlot;
    private IRSCatPaletteProperty _colorCatPalette;
    private IRSContPaletteProperty _colorContPalette;
    private boolean _palettesInvalidated;
    private boolean _hasCategories;
    private boolean _hasColor;
    private boolean _colorIsCategorical;
    private boolean _colorIsContinuous;
    private SizeCategory _sizeCategory;
    private Bounds _chartDimensions;
    private static SingleValueFunction<Object, Object> createColorCaption = Rave2Common.createCaptionFn((String)"color");
    private static SingleValueFunction<Object, Object> createMaxValue = Rave2Common.createValueFn((String)"maxValue");
    private static SingleValueFunction<Object, Object> createColorValue = Rave2Common.createValueFn((String)"color");
    private static SingleValueFunction<Object, Object> createValue = Rave2Common.createValueFn((String)"values");
    private static SingleValueFunction<Object, Object> createCategoriesIndex = Rave2Common.createIndexFn((String)"categories");
    private static SingleValueFunction<Object, Object> createColorIndex = Rave2Common.createIndexFn((String)"color");

    public Rave2BundleRadialBarRenderer() {
        super("rave-library-dial", null, "Rave2BundleRadialBarRenderer", "rave2bundleradialbar.css");
    }

    public IRSPropertyApi getPropertyApi() {
        return new Rave2BundleRadialBarPropertyApi();
    }

    public void _init(IRSInitializationParameters _params, IRSHostAPI _hostApi, Map<String, Object> _resources) {
        this._properties = _params.getProperties();
        this._dataContext = _params.getDataContext();
        this._locale = _params.getLocale();
        this._colorCatPalette = this._properties.getCatPalette("colors.color.cat");
        this._colorContPalette = this._properties.getContPalette("colors.color.cont");
        this.raveBundle.setProperty("effect.duration", (Object)this._properties.getNumber("effect.duration"));
        this.raveBundle.setProperty("effect.name", (Object)"none");
        this.raveBundle.setProperty("showAsPercentage", (Object)false);
        this.raveBundle.setProperty("layout.padding", (Object)"0");
        this.raveBundle.disableAction("highlight");
        this.raveBundle.disableAction("unhighlight");
        this.raveBundle.disableAction("toggleSelect");
        this.raveBundle.disableAction("deselectAll");
        this._chartDimensions = this.raveBundle.getSize();
    }

    public void setProperty(String _key, Object _value) {
    }

    public void setData(IRenderingServiceData _data) {
        IRSContDomain contDomain;
        List domain;
        if (_data == null) {
            return;
        }
        this._palettesInvalidated = true;
        this._dataSet = _data.getDataSetAt(0);
        this._categoriesSlot = this._dataSet.getSlot(CATEGORIES_SLOT);
        this._colorSlot = this._dataSet.getSlot(COLOR_SLOT);
        this._valuesSlot = this._dataSet.getSlot(VALUES_SLOT);
        IRSSlot maxValueSlot = this._dataSet.getSlot(MAX_VALUE_SLOT);
        boolean hasMaxValue = maxValueSlot.isMapped();
        this._hasCategories = this._categoriesSlot.isMapped();
        this._hasColor = this._colorSlot != null && this._colorSlot.isMapped();
        this._colorIsCategorical = this._hasColor && this._colorSlot.getDataItem().getType() == RSDataItemType.Cat;
        this._colorIsContinuous = this._hasColor && this._colorSlot.getDataItem().getType() == RSDataItemType.Cont;
        this.raveBundle.setCustomFormatter(Rave2BundleCustomFormatterTarget.label, this._getFormattedLabelValue());
        List data = this._dataSet.getDataPoints();
        Rave2BundleDataModel dataModel = this.raveBundle.getDataModel();
        dataModel.setDataSlot("data", "key", "string", Rave2Common.createKeyFn(null));
        if (this._hasCategories) {
            domain = Rave2Common.createCatDomain((IRSSlot)this._categoriesSlot);
            dataModel.setDataSlot("data", "label", "string", createCategoriesIndex).setCategoricalDomain(domain);
        } else {
            dataModel.setDataSlot("data", "label", "string", Rave2Common.createStaticValueFn((Object)""));
        }
        if (this._colorIsContinuous) {
            contDomain = this._colorSlot.getDataItem().asCont().getDomain();
            Rave2BundleDataSlot colorDataSlot = dataModel.setDataSlot("data", COLOR_SLOT, "numeric", createColorValue);
            colorDataSlot.setDomain(contDomain);
            this.raveBundle.removeCustomFormatter(Rave2BundleCustomFormatterTarget.legend);
        } else if (this._colorIsCategorical) {
            domain = Rave2Common.createCatDomain((IRSSlot)this._colorSlot);
            dataModel.setDataSlot("data", "label", "string", createColorCaption);
            dataModel.setDataSlot("data", COLOR_SLOT, "string", createColorIndex).setCategoricalDomain(domain);
            this.raveBundle.setCustomFormatter(Rave2BundleCustomFormatterTarget.legend, Rave2Common.createTupleFormatter((IRSSlot)this._colorSlot));
        } else {
            dataModel.clearDataSlot("data", COLOR_SLOT);
            this.raveBundle.removeCustomFormatter(Rave2BundleCustomFormatterTarget.legend);
        }
        if (this._valuesSlot.isMapped()) {
            dataModel.setDataSlot("data", "value", "numeric", createValue);
        }
        if (hasMaxValue) {
            dataModel.setDataSlot("data", MAX_VALUE_SLOT, "numeric", createMaxValue);
        } else if (this._valuesSlot.isMapped()) {
            contDomain = this._valuesSlot.getDataItem().asCont().getDomain();
            dataModel.setDataSlot("data", MAX_VALUE_SLOT, "numeric", Rave2Common.createStaticValueFn((Object)contDomain.getMax()));
        } else {
            dataModel.setDataSlot("data", MAX_VALUE_SLOT, "numeric", Rave2Common.createStaticValueFn((Object)0));
        }
        this.sortData(data);
        dataModel.setData("data", (Object)data);
    }

    private void sortData(List<IRSDataPoint> data) {
        data.sort((_dp1, _dp2) -> {
            int index1 = _dp1.get(this._categoriesSlot).asCat().getIndex();
            int index2 = _dp2.get(this._categoriesSlot).asCat().getIndex();
            return Integer.compare(index1, index2);
        });
    }

    private CustomFormatter _getFormattedLabelValue() {
        return new CustomFormatter(){

            public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                IntervalDataUtilities.IntervalData data = (IntervalDataUtilities.IntervalData)Rave.select((SceneNode)((SceneNode)_context)).datum();
                if (data == null) {
                    return Rave2Common.createValueFormatter((IRSSlot)Rave2BundleRadialBarRenderer.this._valuesSlot, (RSFormatKind)RSFormatKind.Label).getValue(_context, _value, _index, _groupIndex, _info, _simplified);
                }
                IRSDataPoint dataPoint = (IRSDataPoint)data.originalData();
                return ((IRSValue)dataPoint.get(Rave2BundleRadialBarRenderer.VALUES_SLOT)).getCaption(RSFormatKind.Label);
            }
        };
    }

    private void _processProperties() {
        boolean valueLabelPropertyChanged = false;
        for (IRSValueProperty property : this._properties) {
            String name = property.getName();
            Object value = property.getValue();
            if (!property.isDirty()) continue;
            switch (name) {
                case "backgroundColor": {
                    this.raveBundle.setProperty("background.chart.color", (Object)value.toString());
                    break;
                }
                case "backgroundColor.elements": {
                    this.raveBundle.setProperty("background.elements.color", (Object)value.toString());
                    break;
                }
                case "effect.duration": {
                    this.raveBundle.setProperty("effect.duration", value);
                    break;
                }
                case "valueLabels.font": {
                    valueLabelPropertyChanged = true;
                    break;
                }
                case "valueLabels.color": {
                    valueLabelPropertyChanged = true;
                    break;
                }
                case "valueLabels.format": {
                    boolean asPercent = "Percent".equals(value);
                    Object formatter = asPercent ? Rave2Common.createPercentageFormatter((int)0, (int)0, (Locale)this._locale) : Rave2Common.createValueFormatter((IRSSlot)this._valuesSlot, (RSFormatKind)RSFormatKind.Label);
                    this.raveBundle.setProperty("showAsPercentage", (Object)asPercent);
                    this.raveBundle.setCustomFormatter(Rave2BundleCustomFormatterTarget.label, formatter);
                    break;
                }
                case "backRing.color": {
                    this.raveBundle.setProperty("backRingColor", (Object)value.toString());
                    break;
                }
                case "dial.border.color": {
                    this.raveBundle.setProperty("borderColor", (Object)value.toString());
                    break;
                }
                case "dial.border.width": {
                    this.raveBundle.setProperty("borderWidth", value);
                    break;
                }
                case "dial.padding": {
                    this.raveBundle.setProperty("dialPadding", value);
                    break;
                }
                case "dial.padding.color": {
                    this.raveBundle.setProperty("paddingColor", (Object)value.toString());
                    break;
                }
                case "dial.width": {
                    this.raveBundle.setProperty("dialWidth", value);
                    break;
                }
                case "dial.roundedEnds": {
                    this.raveBundle.setProperty("roundedEnds", value);
                    break;
                }
                case "dial.startAngle": {
                    this.raveBundle.setProperty("startAngle", value);
                    break;
                }
                case "dial.maxValue": {
                    this.raveBundle.setProperty(MAX_VALUE_SLOT, value);
                    break;
                }
                case "center.background.radius": {
                    this.raveBundle.setProperty("centerBackgroundRadius", value);
                    break;
                }
                case "center.padding.radius": {
                    this.raveBundle.setProperty("centerPaddingRadius", value);
                    break;
                }
                case "center.color": {
                    this.raveBundle.setProperty("centerColor", (Object)value.toString());
                    break;
                }
                case "center.radius": {
                    this.raveBundle.setProperty("centerRadius", value);
                    break;
                }
                case "dial.minFontSize": {
                    this.raveBundle.setProperty("minFontSize", value);
                    break;
                }
                case "dial.propotionalwidths": {
                    this.raveBundle.setProperty("proportionalWidths", value);
                    break;
                }
            }
        }
        if (this._colorIsContinuous && (this._palettesInvalidated || this._colorContPalette.isDirty())) {
            this._setPalette((IRSPaletteProperty)this._colorContPalette, PaletteType.Cont);
        } else if (this._palettesInvalidated || this._colorCatPalette.isDirty()) {
            this._setPalette((IRSPaletteProperty)this._colorCatPalette, PaletteType.Cat);
        }
        this._palettesInvalidated = false;
        if (valueLabelPropertyChanged) {
            this.raveBundle.setProperty("valueFont", (Object)Rave2Common.composeFontStylePropertyString((Font)Font.merge((Font)DEFAULT_FONT, (Font)((Font)this._properties.getFont("valueLabels.font").getValue())), (IRSColor)((IRSColor)this._properties.getColor("valueLabels.color").getValue())));
        }
        this._optimizeVisualizationSize();
    }

    private void _optimizeVisualizationSize() {
        if (((Boolean)this._properties.getBoolean("optimizeSize").getValue()).booleanValue() && this._sizeCategory == SizeCategory.Small) {
            this.raveBundle.setProperty("layout.chart.padding.left", (Object)"0");
            this.raveBundle.setProperty("layout.chart.padding.right", (Object)"0");
            this.raveBundle.setProperty("layout.chart.padding.top", (Object)"0");
            this.raveBundle.setProperty("layout.chart.padding.bottom", (Object)"0");
        } else {
            this.raveBundle.setProperty("layout.chart.padding.left", this._properties.getString("visualization.padding.left").getValue());
            this.raveBundle.setProperty("layout.chart.padding.right", this._properties.getString("visualization.padding.right").getValue());
            this.raveBundle.setProperty("layout.chart.padding.top", this._properties.getString("visualization.padding.top").getValue());
            this.raveBundle.setProperty("layout.chart.padding.bottom", this._properties.getString("visualization.padding.bottom").getValue());
        }
        this.raveBundle.setAttribute("class", (Object)("Rave2BundleRadialBarRenderer " + this._sizeCategory));
    }

    private void _setPalette(IRSPaletteProperty _palette, PaletteType _paletteType) {
        ArrayList<IRSColor> colorValues = new ArrayList<IRSColor>();
        IRSDataItem dataItem = this._dataSet.getSlot(_palette.getSlot()).getDataItem();
        String paletteId = "vida.colorpalette.rave2bundleradialbar." + this.getUniqueBundleId();
        if (dataItem != null) {
            if (_paletteType == PaletteType.Cat) {
                IRSCatPaletteProperty palette = (IRSCatPaletteProperty)_palette;
                List tuples = dataItem.asCat().getTuples();
                for (IRSTuple tuple : tuples) {
                    colorValues.add(palette.getColor(tuple));
                }
                this.raveBundle.createCatPalette(paletteId, colorValues);
            } else if (_paletteType == PaletteType.Cont) {
                IRSContPaletteProperty palette = (IRSContPaletteProperty)_palette;
                IRSContDataItem contDataItem = (IRSContDataItem)dataItem;
                List stops = palette.getColorStops(contDataItem).getAligned();
                this.raveBundle.createContPalette(paletteId, stops);
            }
            this.raveBundle.setProperty("color.palette", (Object)paletteId);
        }
    }

    public void render(IRSRenderInvalidation _invalidation, IRSRenderNotification _notification) {
        this._chartDimensions = this.raveBundle.getSize();
        this._sizeCategory = this._getSizeCategory();
        this._processProperties();
        if (!this.raveBundle.getDataModel().hasData()) {
            _notification.complete("no data", null);
            return;
        }
        this.raveBundle.render(this._properties, _notification);
    }

    protected void postProcessSceneTree(RenderCompleteCallback _notification) throws Exception {
        Rave.selectAll((String)".element-shape").style("fill-opacity", (Object)"0.9");
        _notification.renderComplete();
    }

    public List<IRSEncoding> getEncodings() {
        ArrayList<IRSEncoding> encodings = new ArrayList<IRSEncoding>();
        if (this._dataSet != null && this._hasColor) {
            if (this._colorIsContinuous) {
                encodings.add((IRSEncoding)ContEncoding.fromDataSlot((IRSSlot)this._colorSlot, (String)COLOR_SLOT, (int)0, (RSFormatKind)RSFormatKind.Label, null, (IRSContPaletteProperty)this._colorContPalette));
            } else {
                encodings.add((IRSEncoding)CatEncoding.fromDataSlot((IRSSlot)this._colorSlot, (String)COLOR_SLOT, (int)0, (RSFormatKind)RSFormatKind.Label, (IRSCatPaletteProperty)this._colorCatPalette, (IRSDataContext)this._dataContext, null));
            }
        }
        return encodings;
    }

    public List<IRSCapability> getCapabilities() {
        ArrayList<IRSCapability> capabilities = new ArrayList<IRSCapability>();
        capabilities.add((IRSCapability)CAPABILITY_CATSIZE);
        capabilities.add((IRSCapability)CAPABILITY_COLORSIZE);
        capabilities.add((IRSCapability)CAPABILITY_DATASIZE);
        return capabilities;
    }

    public IInteractivity getInteractivity() {
        return null;
    }

    private SizeCategory _getSizeCategory() {
        if (this._chartDimensions.getWidth() <= 150.0 || this._chartDimensions.getHeight() <= 150.0) {
            return SizeCategory.Small;
        }
        return SizeCategory.Medium;
    }

    protected double getMinimalVisualizationWidth() {
        return 75.0;
    }

    protected double getMinimalVisualizationHeight() {
        return 75.0;
    }
}

