/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.rave2heat.renderer;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.arrays.Entry;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.rave2heat.renderer.CrossDataEntry;
import com.ibm.vida.vizbundles.rave2heat.renderer.HeatDataPointInfo;
import com.ibm.vida.vizbundles.rave2heat.renderer.PointRangeData;
import com.ibm.vida.vizbundles.rave2heat.renderer.TupleCache;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HeatMapData {
    static final String CATEGORIES_SLOT = "categories";
    static final String SERIES_SLOT = "series";
    static final String POINTS_SLOT = "points";
    static final String COLOR_SLOT = "color";
    static final String SIZE_SLOT = "size";
    final IRenderingServiceData rsData;
    final IRSSlot rowSlot;
    final IRSSlot columnSlot;
    final IRSSlot colorSlot;
    final IRSSlot pointsSlot;
    final IRSSlot sizeSlot;
    final boolean usePoints;
    final boolean useSize;
    final IRSDataSet dataSet;
    final Map<String, TupleCache> categoriesMap;
    final Map<String, TupleCache> seriesMap;
    final List<CrossDataEntry> crossData;
    final Map<String, Integer> _cellCounts;
    private int _maxCellCount;

    HeatMapData(IRenderingServiceData _rsData) {
        this.rsData = _rsData;
        this.dataSet = this.rsData.getDataSetAt(0);
        this.rowSlot = this.dataSet.getSlot(CATEGORIES_SLOT);
        this.columnSlot = this.dataSet.getSlot(SERIES_SLOT);
        this.pointsSlot = this.dataSet.getSlot(POINTS_SLOT);
        this.colorSlot = this.dataSet.getSlot(COLOR_SLOT);
        this.sizeSlot = this.dataSet.getSlot(SIZE_SLOT);
        this.usePoints = this.pointsSlot.isMapped() && this.pointsSlot.getDataItem().asCat().getTuples().size() > 1;
        this.useSize = this.sizeSlot.isMapped();
        ArrayList<HeatDataPointInfo> dataPointInfos = new ArrayList<HeatDataPointInfo>();
        this._maxCellCount = 0;
        this._cellCounts = new HashMap<String, Integer>();
        this._cellCounts.clear();
        this.categoriesMap = TupleCache.createMap(this.rowSlot.getDataItem().asCat().getTuples());
        this.seriesMap = TupleCache.createMap(this.columnSlot.getDataItem().asCat().getTuples());
        List dataPoints = this.dataSet.getDataPoints();
        for (IRSDataPoint dataPoint : dataPoints) {
            HeatDataPointInfo info = new HeatDataPointInfo(this.pointsSlot.isMapped() ? dataPoint.get(this.pointsSlot, 0).getCaption(RSFormatKind.Label) : null, dataPoint.get(this.columnSlot).asCat().getKey(), dataPoint.get(this.rowSlot).asCat().getKey(), this.useSize ? Rave2Common.getValue((IRSDataPoint)dataPoint, (String)SIZE_SLOT) : null, Rave2Common.getValue((IRSDataPoint)dataPoint, (String)COLOR_SLOT), dataPoint);
            info.key = info.data.getKey();
            dataPointInfos.add(info);
        }
        this.crossData = this.buildCrossData(dataPointInfos, this._cellCounts);
    }

    private List<CrossDataEntry> buildCrossData(List<HeatDataPointInfo> _infos, Map<String, Integer> _cellCounts) {
        ArrayEx infos = new ArrayEx();
        for (HeatDataPointInfo info : _infos) {
            infos.add((Object)info);
        }
        ArrayEx entries = Rave.nest().key(_d -> {
            HeatDataPointInfo d = (HeatDataPointInfo)_d;
            return d.row + "x" + d.column;
        }).entries(infos);
        ArrayEx crossData = new ArrayEx();
        for (Object obj : entries) {
            CrossDataEntry d = CrossDataEntry.createFromEntry((Entry)obj);
            PointRangeData.populateCellCountMap(d, _cellCounts);
            if (this._maxCellCount <= d.values.length) {
                this._maxCellCount = d.values.length;
            }
            Arrays.sort(d.values, (_left, _right) -> {
                int comparison = -Double.compare(HeatMapData.nullToZero(_left.color), HeatMapData.nullToZero(_right.color));
                if (comparison == 0) {
                    return -Double.compare(HeatMapData.nullToZero(_left.size), HeatMapData.nullToZero(_right.size));
                }
                return comparison;
            });
            crossData.add((Object)d);
        }
        return crossData;
    }

    private static double nullToZero(Double _value) {
        if (_value == null) {
            return 0.0;
        }
        return _value;
    }

    Map<String, Integer> getCellCounts() {
        return this._cellCounts;
    }

    int getMaxCellCount() {
        return this._maxCellCount;
    }
}

