/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.rave2heat.renderer;

import com.ibm.vida.vizbundles.rave2heat.renderer.CrossDataEntry;
import com.ibm.vida.vizbundles.rave2heat.renderer.HeatDataPointInfo;
import com.ibm.vida.vizbundles.rave2heat.renderer.MinSquareData;
import java.util.Map;

class PointRangeData {
    private static final int numberOfTilesToStartPadding = 4;
    private static final int maxCellPadding = 8;
    private static final int cellPaddingRate = 10;
    final double maxRange;
    final double minRange;
    final boolean overflow;
    final double columnRangeBand;
    final double rowRangeBand;
    double selectedTileDimension;
    final double colPadding;
    final double rowPadding;
    final double cellPadding;
    final int columnCount;
    final int rowCount;
    final Map<String, Integer> cellCountMap;
    final int cellMax;
    final double maxOverflow;
    double maxDimension;
    static final MinSquareData minSquareData = new MinSquareData(8.0, 8.0, 10.0, 12.0, 18.0, 1.0, 1.0);
    private static final int extraTilesToHide = 2;
    static final double biggestLabelSize = 14.0;

    PointRangeData(double _maxRange, double _minRange, boolean _overflow, double _columnRangeBand, double _rowRangeBand, double _selectedTileDimension, double _colPadding, double _rowPadding, double _cellPadding, int _columnCount, int _rowCount, Map<String, Integer> _cellCountMap, int _cellMax, double _maxOverflow) {
        this.maxRange = _maxRange;
        this.minRange = _minRange;
        this.overflow = _overflow;
        this.columnRangeBand = _columnRangeBand;
        this.rowRangeBand = _rowRangeBand;
        this.maxDimension = _selectedTileDimension;
        this.colPadding = _colPadding;
        this.rowPadding = _rowPadding;
        this.cellPadding = _cellPadding;
        this.columnCount = _columnCount;
        this.rowCount = _rowCount;
        this.cellCountMap = _cellCountMap;
        this.cellMax = _cellMax;
        this.maxOverflow = _maxOverflow;
    }

    static PointRangeData calculatePointRangeData(double _xRangeBand, double _yRangeBand, Map<String, Integer> _cellCountMap, Integer _maxChild) {
        double selectedTileDimension;
        int rowCount;
        int columnCount;
        MinSquareData minSquare = minSquareData;
        double colPadding = minSquare.xpadding;
        double rowPadding = minSquare.ypadding;
        double preferredMinTileDimension = minSquare.minCellWidth;
        double maxTileDimension = Math.min(_yRangeBand, _xRangeBand);
        double cellPadding = maxTileDimension > 4.0 * preferredMinTileDimension ? Math.min(maxTileDimension / 10.0, 8.0) : 0.0;
        double columnRangeBand = _xRangeBand - 2.0 * cellPadding;
        double rowRangeBand = _yRangeBand - 2.0 * cellPadding;
        boolean overflow = false;
        if (maxTileDimension <= preferredMinTileDimension) {
            columnCount = Math.max(1, maxTileDimension == 0.0 ? 0 : (int)Math.floor(columnRangeBand / maxTileDimension));
            rowCount = Math.max(1, maxTileDimension == 0.0 ? 0 : (int)Math.floor(rowRangeBand / maxTileDimension));
            selectedTileDimension = maxTileDimension;
            colPadding = 0.0;
            rowPadding = 0.0;
            if (_maxChild > 1) {
                overflow = true;
            }
        } else {
            double cellArea = columnRangeBand * rowRangeBand;
            double tileArea = _maxChild != null ? cellArea / (double)_maxChild.intValue() : cellArea;
            double nooverflowTileDimension = Math.sqrt(tileArea);
            columnCount = (int)Math.floor(columnRangeBand / nooverflowTileDimension);
            rowCount = (int)Math.ceil(_maxChild.doubleValue() / (double)columnCount);
            nooverflowTileDimension = rowRangeBand / (double)rowCount;
            if (nooverflowTileDimension < preferredMinTileDimension) {
                columnCount = Math.max(1, (int)Math.floor(columnRangeBand / preferredMinTileDimension));
                rowCount = Math.max(1, (int)Math.floor(rowRangeBand / preferredMinTileDimension));
                selectedTileDimension = preferredMinTileDimension - colPadding;
                if (rowCount * columnCount < _maxChild) {
                    overflow = true;
                }
            } else {
                selectedTileDimension = nooverflowTileDimension - colPadding;
            }
        }
        if (selectedTileDimension < 0.0) {
            selectedTileDimension = 0.0;
        }
        double maxRange = Math.pow(selectedTileDimension, 2.0);
        double minRange = preferredMinTileDimension <= selectedTileDimension ? Math.pow(preferredMinTileDimension - colPadding, 2.0) : maxRange;
        int cellMax = rowCount * columnCount;
        double maxOverflow = _maxChild - cellMax;
        return new PointRangeData(maxRange, minRange, overflow, columnRangeBand, rowRangeBand, selectedTileDimension, colPadding, rowPadding, cellPadding, columnCount, rowCount, _cellCountMap, cellMax, maxOverflow);
    }

    public static void populateCellCountMap(CrossDataEntry _entry, Map<String, Integer> _cellCountMap) {
        if (_cellCountMap == null || _entry == null || _entry.values == null) {
            return;
        }
        String cellKey = _entry.cellKey();
        int cellCount = _entry.values.length;
        _cellCountMap.put(cellKey, cellCount);
    }

    public boolean labelsFit() {
        double labelLength = this.maxOverflow > 9.0 ? PointRangeData.minSquareData.doubleDigitLabelWidth : PointRangeData.minSquareData.labelWidth;
        boolean verticalFit = this.rowRangeBand > PointRangeData.minSquareData.labelHeight;
        boolean horizontalFit = this.columnRangeBand > labelLength;
        return this.overflow && horizontalFit && verticalFit;
    }

    String overflowLabel(CrossDataEntry _d) {
        if (this.overflow) {
            Integer count = this._overflowCount(_d);
            return count != null ? "+" + count : "";
        }
        return "";
    }

    int _overflowCount(CrossDataEntry _d) {
        int overflow;
        Integer cellCount = this._cellCount(_d);
        if (cellCount == null) {
            cellCount = 0;
        }
        if ((overflow = cellCount - this.cellMax) > 0) {
            return this._canHideForLabel() ? overflow + 2 : overflow;
        }
        return 0;
    }

    boolean _canHideForLabel() {
        return this.labelsFit() && this.overflow && this.cellMax > 2;
    }

    private Integer _cellCount(CrossDataEntry _d) {
        return this.cellCountMap.get(_d.cellKey());
    }

    double textx(CrossDataEntry _d) {
        return (Double)this.x((Object)_d, this.columnCount - 1) + this.maxDimension + this.colPadding;
    }

    double texty(CrossDataEntry _d) {
        return (Double)this.y((Object)_d, this.cellMax - 1);
    }

    String textDisplay(CrossDataEntry _d) {
        return this._overflowCount(_d) > 0 ? "display" : "none";
    }

    Object x(Object _data, int _index) {
        int column = _index % this.columnCount;
        return this.maxDimension * (double)column + this.colPadding * (double)column + this._pointSizeXOffset((HeatDataPointInfo)_data) + this.cellPadding;
    }

    Object y(Object _data, int _index) {
        int row = (int)Math.floor(_index / this.columnCount);
        return this.maxDimension * (double)row + this.rowPadding * (double)row + this.cellPadding + this._pointSizeYOffset((HeatDataPointInfo)_data);
    }

    private double _pointSizeXOffset(HeatDataPointInfo _d) {
        if (_d._mappedPointSize == null) {
            return 0.0;
        }
        return Math.max(0.0, this.maxDimension - _d._mappedPointSize) / 2.0;
    }

    private double _pointSizeYOffset(HeatDataPointInfo _d) {
        if (_d._mappedPointSize == null) {
            return 0.0;
        }
        return Math.max(0.0, this.maxDimension - _d._mappedPointSize);
    }

    String display(Object _data, int _i) {
        return this._tileFits(_data, _i) ? "block" : "none";
    }

    private boolean _tileFits(Object _data, int _i) {
        if (this._canHideForLabel() && _i >= this.cellMax - 2 && this._overflowCount((CrossDataEntry)((Object)_data)) > 0) {
            return false;
        }
        double row = Math.floor(_i / this.columnCount) + 1.0;
        return row <= (double)this.rowCount;
    }
}

