/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.rave2heat.renderer;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.axis.AxisComponentUtil;
import com.ibm.vida.rave.ext.axis.RaveAxis;
import com.ibm.vida.vizbundles.common.DataBoundProperty;
import com.ibm.vida.vizbundles.common.Rect;
import com.ibm.vida.vizbundles.common.Size;
import com.ibm.vida.vizbundles.common.SizeCategory;
import com.ibm.vida.vizbundles.common.groupproperties.AxisProperty;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.VidaRenderingServiceLegendBase;
import com.ibm.vida.vizbundles.rave2heat.renderer.CrossDataEntry;
import com.ibm.vida.vizbundles.rave2heat.renderer.HeatDataPointInfo;
import com.ibm.vida.vizbundles.rave2heat.renderer.HeatMapData;
import com.ibm.vida.vizbundles.rave2heat.renderer.PointRangeData;
import com.ibm.vida.vizbundles.rave2heat.renderer.Rave2HeatPropertyApi;
import com.ibm.vida.vizbundles.rave2heat.renderer.TupleCache;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSContStops;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.api.IRSInitializationParameters;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSPropertyApi;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.renderingservice.util.Bounds;
import com.ibm.vipr.renderingservice.util.Capability;
import com.ibm.vipr.renderingservice.util.ContEncoding;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Rave2HeatRenderer
extends VidaRenderingServiceLegendBase {
    private static final Capability CAPABILITY_CATSIZE = Capability.limit((String)"categories", (int)1000);
    private static final Capability CAPABILITY_SERIESSIZE = Capability.limit((String)"series", (int)10000);
    private static final Capability CAPABILITY_DATASIZE = Capability.limit((String)"data", (int)5000);
    private static final String SCALE_SIZE = "size";
    private static final String SCALE_X = "x";
    private static final String SCALE_Y = "y";
    private static final String SCALE_COLOR = "color";
    private static final double DEFAULT_BORDER = 2.0;
    private static final double MIN_VISUALIZATION_WIDTH = 180.0;
    private static final double MIN_VISUALIZATION_HEIGHT = 90.0;
    private static final int SMALL_VISUALIZATION_WIDTH = 260;
    private static final int SMALL_VISUALIZATION_HEIGHT = 200;
    private static final int LARGE_VISUALIZATION_WIDTH = 420;
    private static final int LARGE_VISUALIZATION_HEIGHT = 320;
    private static final Font DEFAULT_FONT = Font.create(null, (Length)Length.parse((String)"0.75em"), null, null);
    private static final Font DEFAULT_FONT_SMALL = Font.create(null, (Length)Length.parse((String)"0.65em"), null, null);
    private IRenderingServiceData _currentData;
    private HeatMapData _renderData;
    private IRSProperties _properties;
    private Rect _visualizationPadding;
    private boolean _xAxisAlignmentTop;
    private Selector chartArea;
    private Selector clip;
    private Selector background;
    private Selector elementsBackground;
    private Selector elements;
    private Selector labelsLayer;
    private Selector _xAxis;
    private Selector _yAxis;
    private Map<String, AbstractScale<Object, Object>> scale;
    private AxisComponentUtil _xAxisComponent;
    private AxisComponentUtil _yAxisComponent;
    private IRSContPaletteProperty _heatPalette;
    private SizeCategory _sizeCategory;
    private Color _borderColor = null;
    private double _borderWidth;
    private AxisProperty _itemAxisProperty;
    private AxisProperty _valueAxisProperty;
    protected static final DataBoundProperty.ITransform slotLabelCaption = _slot -> {
        IRSSlot slot = (IRSSlot)_slot;
        return slot != null && slot.isMapped() ? slot.getDataItem().combineCaptions(RSFormatKind.Label) : "";
    };

    public void init(IRSInitializationParameters _params, IRSHostAPI _hostApi, Map<String, Object> _resources, IRenderingService.IInitCompleteCallback _initComplete, IRenderingService.IInitFailedCallback _initFailed) {
        try {
            this._properties = _params.getProperties();
            this._visualizationPadding = new Rect(0.0, 0.0, 0.0, 0.0);
            this._xAxisAlignmentTop = ((String)this._properties.getEnum("itemAxis.alignment").getValue()).equals("top");
            this._heatPalette = this._properties.getContPalette("colors.color");
            this.initRaveSurface(_params.getRenderSurface(), _params.getFormat(), Arrays.asList("rave2heat.css"));
            Selector root = this.getBundleRoot();
            this.background = root.append("rect").attr("class", (Object)"background chart").attr("fill", (Object)"transparent");
            this.chartArea = root.append("g");
            this.elementsBackground = this.chartArea.append("rect").attr("class", (Object)"background elements").attr("fill", (Object)"transparent");
            this.elements = this.chartArea.append("g").attr("clip-path", (Object)Rave2Common.svgRef((String)("chartClip" + this.getUniqueBundleId())));
            this.labelsLayer = this.chartArea.append("g").attr("clip-path", (Object)Rave2Common.svgRef((String)("chartClip" + this.getUniqueBundleId())));
            this.clip = root.select((Object)"clipPath");
            this._xAxis = root.append("g").attr("class", (Object)"layoutAxis-bottom");
            this._yAxis = root.append("g").attr("class", (Object)"layoutAxis-left");
            this._createScales();
            this._itemAxisProperty = new AxisProperty("itemAxis", this._properties);
            this._valueAxisProperty = new AxisProperty("valueAxis", this._properties);
        }
        catch (Throwable thr) {
            _initFailed.call(thr);
        }
        _initComplete.call();
    }

    public IRSPropertyApi getPropertyApi() {
        return new Rave2HeatPropertyApi();
    }

    public void setData(IRenderingServiceData _data) {
        this._currentData = _data;
    }

    public List<IRSCapability> getCapabilities() {
        return Arrays.asList(CAPABILITY_CATSIZE, CAPABILITY_SERIESSIZE, CAPABILITY_DATASIZE);
    }

    private void processData() {
        if (this._currentData == null) {
            return;
        }
        this._renderData = new HeatMapData(this._currentData);
        this._itemAxisProperty.setSlot(this._renderData.columnSlot);
        this._valueAxisProperty.setSlot(this._renderData.rowSlot);
        this._currentData = null;
        this._updateDomain();
    }

    private void _updateDomain() {
        IRSDataItem dataItem = this._renderData.colorSlot.getDataItem();
        IRSContStops colorStops = this._heatPalette.getColorStops(dataItem.asCont());
        List domainStops = colorStops.getAligned().stream().map(_stop -> _stop.getValue()).collect(Collectors.toList());
        this.scale.put(SCALE_COLOR, (AbstractScale<Object, Object>)Rave.scale.linear().domain(domainStops));
        if (this._renderData.useSize) {
            IRSContDomain domain = this._renderData.sizeSlot.getDataItem().asCont().getDomain();
            if (domain.getMin() == domain.getMax()) {
                this.getLinearScale(SCALE_SIZE).domain(Arrays.asList(domain.getMin(), domain.getMax()));
            } else {
                this.getLinearScale(SCALE_SIZE).domain(Arrays.asList(domain.getMin(), domain.getMax())).nice();
            }
        } else {
            this.getLinearScale(SCALE_SIZE).domain(Arrays.asList(1, 1));
        }
        this.getOrdinalScale(SCALE_Y).domain(this._renderData.rowSlot.getDataItem().asCat().getTuples().stream().map(_tuple -> _tuple.getKey()).collect(Collectors.toList()));
        this.getOrdinalScale(SCALE_X).domain(this._renderData.columnSlot.getDataItem().asCat().getTuples().stream().map(_tuple -> _tuple.getKey()).collect(Collectors.toList()));
    }

    public void setProperty(String _name, Object _value) {
    }

    protected IRSProperties getProperties() {
        return this._properties;
    }

    protected double getMinimalVisualizationWidth() {
        return 180.0;
    }

    protected double getMinimalVisualizationHeight() {
        return 90.0;
    }

    public void render(IRSRenderInvalidation _invalidation, IRSRenderNotification _notification) {
        Dimension renderDim = this.getDimension();
        if (this._currentData == null || Double.compare(renderDim.getHeight(), 0.0) == 0 || Double.compare(renderDim.getWidth(), 0.0) == 0) {
            _notification.complete();
            return;
        }
        if (_invalidation.dataChanged()) {
            this.processData();
        }
        this._processProperties(_invalidation);
        if (this._renderData.crossData == null) {
            _notification.complete();
            return;
        }
        if (_invalidation.dataChanged() || _invalidation.sizeChanged() || _invalidation.propertiesChanged()) {
            this._setBounds();
            this._bind();
        }
        _notification.complete();
    }

    private void _bind() {
        if (this._renderData.crossData != null && this._renderData.crossData.size() > 0) {
            Selector xlines = this.labelsLayer.selectAll(".gridLines.horizontal").data(this._renderData.columnSlot.getDataItem().asCat().getTuples().stream().map(_tuple -> _tuple.getKey()).collect(Collectors.toList()));
            Selector ylines = this.labelsLayer.selectAll(".gridLines.vertical").data(this._renderData.rowSlot.getDataItem().asCat().getTuples().stream().map(_tuple -> _tuple.getKey()).collect(Collectors.toList()));
            Selector cells = this.elements.selectAll(".cell").data(this._renderData.crossData, Rave2HeatRenderer.createCellKeyLambda());
            xlines.enter().append("line").attr("class", (Object)"gridLines horizontal").style("stroke", (Object)((IRSColor)this._properties.getColor("itemAxis.gridLines.color").getValue()).toString()).style("stroke-dasharray", (Object)((String)this._properties.getString("itemAxis.gridLines.dashPattern").getValue()).toString());
            ylines.enter().append("line").attr("class", (Object)"gridLines vertical").style("stroke", (Object)((IRSColor)this._properties.getColor("valueAxis.gridLines.color").getValue()).toString()).style("stroke-dasharray", (Object)((String)this._properties.getString("valueAxis.gridLines.dashPattern").getValue()).toString());
            this._updateGrid(xlines, true);
            this._updateGrid(ylines, false);
            xlines.exit().remove();
            ylines.exit().remove();
            cells.enter().append("g").attr("class", (Object)"cell");
            this._updateCells(cells);
            cells.exit().remove();
        }
    }

    private void _updateCells(Selector _cells) {
        _cells.attr("transform", Rave2HeatRenderer.createCellTransformationLambda(this.getOrdinalScale(SCALE_X), this.getOrdinalScale(SCALE_Y)));
        Selector squares = _cells.selectAll(".square").data(Rave2HeatRenderer.createSquareDataLambda(), Rave2HeatRenderer.createSquareDataIndexLambda());
        if (this._renderData.usePoints) {
            squares.enter().append("rect").attr("class", (Object)"square selectable element");
            PointRangeData rangeData = this._updatePoints(squares);
            boolean small = this._sizeCategory == SizeCategory.Small;
            Selector overflowLabels = _cells.selectAll(".overflowlabel").data(Rave2HeatRenderer.createOverflowLabelDataLambda(rangeData, small));
            if (!small) {
                overflowLabels.enter().append("text").attr("class", (Object)"overflowlabel");
                this._updateoverflowLabel(overflowLabels, rangeData);
            }
            overflowLabels.exit().remove();
        } else {
            squares.enter().append("rect").attr("class", (Object)"square selectable element");
            squares.call(Rave2HeatRenderer.createHeatSquareUpdater(this.getOrdinalScale(SCALE_X), this.getOrdinalScale(SCALE_Y), this.getLinearScale(SCALE_SIZE), this.getLinearScale(SCALE_COLOR), this._borderColor, this._borderWidth), new Object[0]);
            Selector overflowLabels = _cells.selectAll(".overflowlabel").remove();
        }
        squares.exit().remove();
    }

    private static double adjustForBorder(double _dimension, double _strokeWidth) {
        return Math.max(_dimension - _strokeWidth, 1.0);
    }

    private void _updateoverflowLabel(Selector _selection, PointRangeData _rangeData) {
        List colorRange = this.scale.get(SCALE_COLOR).range();
        int colorRangeSize = colorRange.size();
        Object textColor = this.scale.get(SCALE_COLOR) != null && colorRangeSize > 0 ? colorRange.get(colorRangeSize - 1) : null;
        _selection.text(Rave2HeatRenderer.createOverflowLabelTextLambda(_rangeData)).attr("class", (Object)"overflowlabel").attr(SCALE_X, Rave2HeatRenderer.createOverflowLabelXLambda(_rangeData)).attr(SCALE_Y, Rave2HeatRenderer.createOverflowLabelYLambda(_rangeData)).style("font-size", Rave2HeatRenderer.createTextPixelSizeLambda(_rangeData)).style("display", Rave2HeatRenderer.createOverflowLabelDisplayLambda(_rangeData)).attr("fill", textColor);
    }

    private PointRangeData _updatePoints(Selector _squares) {
        double scaleXRange = this.getOrdinalScale((String)SCALE_X).rangeBand.getValue().doubleValue();
        double scaleYRange = this.getOrdinalScale((String)SCALE_Y).rangeBand.getValue().doubleValue();
        PointRangeData rangeData = PointRangeData.calculatePointRangeData(scaleXRange, scaleYRange, this._renderData.getCellCounts(), this._renderData.getMaxCellCount());
        this.getLinearScale(SCALE_SIZE).range(Arrays.asList(rangeData.minRange, rangeData.maxRange));
        _squares.each(Rave2HeatRenderer.createSquareColorSizeLambda(this.getLinearScale(SCALE_SIZE), this.getLinearScale(SCALE_COLOR), this._renderData.useSize)).attr(SCALE_X, Rave2HeatRenderer.createSquareXcoordinateLambda(rangeData)).attr("width", Rave2HeatRenderer.createSquareSizeLambda()).attr("height", Rave2HeatRenderer.createSquareSizeLambda()).attr(SCALE_Y, Rave2HeatRenderer.createSquareYcoordinateLambda(rangeData)).attr("stroke-width", Rave2HeatRenderer.createSquareStrokeWidthLambda(this._borderWidth)).attr("display", Rave2HeatRenderer.createSquareDisplayAttLambda(rangeData)).attr("fill", Rave2HeatRenderer.createSquareDataFillColor()).attr("stroke", Rave2HeatRenderer.createSquareStrokeAttLambda(this.getLinearScale(SCALE_COLOR)));
        return rangeData;
    }

    private void _updateGrid(Selector _items, boolean _xDir) {
        String a = _xDir ? SCALE_X : SCALE_Y;
        String b = _xDir ? SCALE_Y : SCALE_X;
        OrdinalScale aScale = _xDir ? this.getOrdinalScale(SCALE_X) : this.getOrdinalScale(SCALE_Y);
        OrdinalScale bScale = _xDir ? this.getOrdinalScale(SCALE_Y) : this.getOrdinalScale(SCALE_X);
        boolean visibleProp = _xDir ? this._itemAxisProperty.showGridLines() : this._valueAxisProperty.showGridLines();
        String clazz = _xDir ? ".gridLines.horizontal" : ".gridLines.vertical";
        double opacity = Math.min(1.0, (Double)aScale.getRangeBand().getValue() / 50.0);
        String visibility = !visibleProp || opacity < 0.1 ? "none" : "inline";
        _items.attr(a + "1", Rave2HeatRenderer.createGridlineCoordinateALambda(_xDir, aScale)).attr(b + "1", Rave2HeatRenderer.createGridlineCoordinateBLambda(bScale, 0)).attr(a + "2", Rave2HeatRenderer.createGridlineCoordinateALambda(_xDir, aScale)).attr(b + "2", Rave2HeatRenderer.createGridlineCoordinateBLambda(bScale, 1));
        this.getBundleRoot().selectAll(clazz).style("opacity", (Object)opacity).style("display", (Object)visibility);
    }

    private Bounds _getPlotAreaBounds() {
        Size chartSize = this._getChartSize();
        double yAxisWidth = Math.min(this._yAxisComponent.getPreferredSize(), chartSize.w / 2.0);
        double xAxisHeight = Math.min(this._xAxisComponent.getPreferredSize(), chartSize.h / 2.0);
        return Bounds.fromXYWH((double)yAxisWidth, (double)(this._xAxisAlignmentTop ? xAxisHeight : 0.0), (double)(chartSize.w - yAxisWidth), (double)(chartSize.h - xAxisHeight));
    }

    private Size _getChartSize() {
        Dimension bounds = this.getDimension();
        return new Size(Math.max((double)bounds.width - this._visualizationPadding.l - this._visualizationPadding.r, 0.0), Math.max((double)bounds.height - this._visualizationPadding.t - this._visualizationPadding.b, 0.0));
    }

    private void _setBounds() {
        Dimension bounds = this.getDimension();
        this._sizeCategory = (Boolean)this._properties.getBoolean("optimizeSize").getValue() == false ? SizeCategory.Large : (bounds.width <= 260 || bounds.height <= 200 ? SizeCategory.Small : (bounds.width >= 420 && bounds.height >= 320 ? SizeCategory.Large : SizeCategory.Medium));
        this._optimizeVisualizationSize();
        this._updateAxes();
        Selector root = this.getBundleRoot();
        Rave.select((SceneNode)root.node().getParentNode()).style("width", (Object)"100%").style("height", (Object)"100%").style("left", (Object)"0px").style("top", (Object)"0px").style("position", (Object)"absolute");
        root.attr("class", (Object)("Rave2HeatRenderer surface " + this._sizeCategory)).attr("width", (Object)bounds.width).attr("height", (Object)bounds.height);
        this.background.attr("width", (Object)bounds.width).attr("height", (Object)bounds.height);
        this.chartArea.attr("transform", (Object)("translate(" + this._visualizationPadding.l + "," + this._visualizationPadding.t + ")"));
        Bounds plotArea = this._getPlotAreaBounds();
        this.clip.attr(SCALE_Y, (Object)plotArea.getTop()).attr(SCALE_X, (Object)plotArea.getLeft()).attr("width", (Object)plotArea.getWidth()).attr("height", (Object)plotArea.getHeight());
        this.elementsBackground.attr(SCALE_X, (Object)plotArea.getLeft()).attr(SCALE_Y, (Object)plotArea.getTop()).attr("width", (Object)(plotArea.getWidth() - this._xAxisComponent.layoutSpillOver())).attr("height", (Object)plotArea.getHeight());
    }

    private void _updateAxes() {
        if (this._properties.get("itemAxis.alignment").isDirty()) {
            this._xAxis.selectAll("*").remove();
        }
        Size chartSize = this._getChartSize();
        RectStruct axisBounds = new RectStruct(0.0, 0.0, chartSize.w, chartSize.h / 2.0);
        this.getOrdinalScale(SCALE_X).rangeBands(Arrays.asList(0, chartSize.w), Double.valueOf(0.0), Double.valueOf(0.0));
        this._xAxisComponent.orient(this._xAxisAlignmentTop ? "top" : "bottom").scale((AbstractScale)this.getOrdinalScale(SCALE_X)).tickFormat(Rave2HeatRenderer.createTickFormatterLambda(this._renderData.seriesMap, this._itemAxisProperty.showTickLabels())).axisTitleClass("axis-title.selectable").axisLabelClass("axis-label.selectable").bounds(axisBounds).displayTickLabels(this._itemAxisProperty.showTickLabels()).displayAxisTitle(this._itemAxisProperty.showTitle()).displayTicks(this._itemAxisProperty.showTicks()).displayAxisLine(this._itemAxisProperty.showLine()).axisTitle(this._itemAxisProperty.title()).mode(this._itemAxisProperty.tickLabelMode()).rotateAngle(this._itemAxisProperty.tickLabelRotateAngle()).allowAutomaticAxisLayoutToChangeOrientation(true).axisColor(this._itemAxisProperty.lineColor()).tickColor(this._itemAxisProperty.tickColor()).labelStyle(this._itemAxisProperty.tickLabelFont()).titleStyle(this._itemAxisProperty.titleFont());
        this._xAxis.call((RunFunction)this._xAxisComponent, new Object[0]);
        axisBounds = new RectStruct(0.0, 0.0, chartSize.w / 2.0, chartSize.h);
        Bounds plotArea = this._getPlotAreaBounds();
        this.getOrdinalScale(SCALE_Y).rangeBands(Arrays.asList(plotArea.getTop(), plotArea.getHeight() + plotArea.getTop()), Double.valueOf(0.0), Double.valueOf(0.0));
        this._yAxisComponent.scale((AbstractScale)this.getOrdinalScale(SCALE_Y)).tickFormat(Rave2HeatRenderer.createTickFormatterLambda(this._renderData.categoriesMap, this._valueAxisProperty.showTickLabels())).axisTitleClass("axis-title.selectable").axisLabelClass("axis-label.selectable").bounds(axisBounds).displayTickLabels(this._valueAxisProperty.showTickLabels()).displayAxisTitle(this._valueAxisProperty.showTitle()).displayTicks(this._valueAxisProperty.showTicks()).displayAxisLine(this._valueAxisProperty.showLine()).axisTitle(this._valueAxisProperty.title()).allowAutomaticAxisLayoutToChangeOrientation(true).axisColor(this._valueAxisProperty.lineColor()).tickColor(this._valueAxisProperty.tickColor()).labelStyle(this._valueAxisProperty.tickLabelFont()).titleStyle(this._valueAxisProperty.titleFont());
        this._yAxis.call((RunFunction)this._yAxisComponent, new Object[0]);
        plotArea = this._getPlotAreaBounds();
        this.getOrdinalScale(SCALE_X).rangeBands(Arrays.asList(plotArea.getLeft(), plotArea.getWidth() + plotArea.getLeft()), Double.valueOf(0.0), Double.valueOf(0.0));
        this._xAxisComponent.scale((AbstractScale)this.getOrdinalScale(SCALE_X));
        this._xAxis.call((RunFunction)this._xAxisComponent, new Object[0]);
        plotArea = this._getPlotAreaBounds();
        this.getOrdinalScale(SCALE_Y).rangeBands(Arrays.asList(plotArea.getTop(), plotArea.getHeight() + plotArea.getTop()), Double.valueOf(0.0), Double.valueOf(0.0));
        this._yAxisComponent.scale((AbstractScale)this.getOrdinalScale(SCALE_Y));
        this._yAxis.call((RunFunction)this._yAxisComponent, new Object[0]);
        plotArea = this._getPlotAreaBounds();
        double xAxisTranslate = this._xAxisAlignmentTop ? plotArea.getTop() : plotArea.getHeight();
        this._xAxis.attr("transform", (Object)("translate( 0 , " + xAxisTranslate + ")"));
        this._yAxis.attr("transform", (Object)("translate( " + plotArea.getLeft() + ", 0 )"));
    }

    private void _optimizeVisualizationSize() {
        Dimension bounds = this.getDimension();
        boolean isSmallViz = (Boolean)this._properties.getBoolean("optimizeSize").getValue() != false && this._sizeCategory == SizeCategory.Small;
        boolean isSmallHeight = isSmallViz && bounds.getHeight() < 200.0;
        boolean isSmallWidth = isSmallViz && bounds.getWidth() < 260.0;
        this._itemAxisProperty.setSmall(isSmallWidth, isSmallViz);
        this._valueAxisProperty.setSmall(isSmallHeight, isSmallViz);
        this._visualizationPadding = isSmallViz ? new Rect(0.0, 0.0, 0.0, 0.0) : new Rect(((Length)this._properties.getLength("visualization.padding.left").getValue()).calculatePx((double)bounds.width, 10.0), ((Length)this._properties.getLength("visualization.padding.top").getValue()).calculatePx((double)bounds.height, 10.0), ((Length)this._properties.getLength("visualization.padding.right").getValue()).calculatePx((double)bounds.width, 10.0), ((Length)this._properties.getLength("visualization.padding.bottom").getValue()).calculatePx((double)bounds.height, 10.0));
    }

    private void _processProperties(IRSRenderInvalidation _invalidation) {
        Selector root = this.getBundleRoot();
        for (IRSValueProperty _property : this._properties) {
            String key = _property.getName();
            Object value = _property.getValue();
            if (!_property.isDirty()) continue;
            switch (key) {
                case "backgroundColor": {
                    root.selectAll(".background.chart").style("fill", (Object)value.toString());
                    break;
                }
                case "backgroundColor.elements": {
                    root.selectAll(".background.elements").style("fill", (Object)value.toString());
                    break;
                }
                case "itemAxis.alignment": {
                    this._xAxisAlignmentTop = value.equals("top");
                    break;
                }
                case "border.width": {
                    this._borderWidth = ((Length)value).calculatePx(0.0, 10.0);
                    break;
                }
                case "border.color": {
                    this._borderColor = Rave.rgb((Object)value);
                }
            }
        }
        if (_invalidation.dataChanged() || this._heatPalette.isDirty()) {
            this._updateColorScale();
        }
    }

    private void _updateColorScale() {
        if (this._renderData == null) {
            return;
        }
        ArrayList colorPalette = new ArrayList();
        IRSContDataItem dataItem = this._renderData.colorSlot.getDataItem().asCont();
        IRSContStops colorStops = this._heatPalette.getColorStops(dataItem);
        List domainStops = colorStops.getAligned().stream().map(_stop -> {
            colorPalette.add(_stop.getColor().toString());
            return _stop.getValue();
        }).collect(Collectors.toList());
        LinearScale colorScale = this.getLinearScale(SCALE_COLOR);
        colorScale.range(colorPalette);
        colorScale.domain(domainStops);
    }

    protected void _initRaveExtensions() {
        RaveAxis.init();
    }

    protected void _destroy() {
        this._currentData = null;
        this._renderData = null;
    }

    private void _createScales() {
        this.scale = new HashMap<String, AbstractScale<Object, Object>>();
        this.scale.put(SCALE_X, (AbstractScale<Object, Object>)Rave.scale.ordinal());
        this.scale.put(SCALE_Y, (AbstractScale<Object, Object>)Rave.scale.ordinal());
        this.scale.put(SCALE_COLOR, (AbstractScale<Object, Object>)Rave.scale.linear());
        this.scale.put(SCALE_SIZE, (AbstractScale<Object, Object>)Rave.scale.linear());
        this._xAxisComponent = ((RaveAxis)Rave.capabilities.extension("axis")).axisComponentUtil();
        this._yAxisComponent = ((RaveAxis)Rave.capabilities.extension("axis")).axisComponentUtil();
        this._yAxisComponent.orient("left").isNumericAxis(false);
        this._xAxisComponent.isNumericAxis(false);
    }

    private OrdinalScale getOrdinalScale(String _name) {
        return (OrdinalScale)this.scale.get(_name);
    }

    private LinearScale getLinearScale(String _name) {
        return (LinearScale)this.scale.get(_name);
    }

    protected static Consumer<Object> createAxisTitleSetterLambda(AxisComponentUtil _axisComponent) {
        return _title -> _axisComponent.axisTitle((String)_title);
    }

    protected static ValueFunction<Object, String> createTickFormatterLambda(Map<String, TupleCache> _map, boolean _showLabels) {
        if (_showLabels && _map != null) {
            return (_context, _data, _index, _groupIndex) -> ((TupleCache)_map.get((Object)_data)).caption;
        }
        return (_context, _data, _index, _groupIndex) -> "";
    }

    protected static ValueFunction<SceneNode, ?> createCellTransformationLambda(OrdinalScale _xScale, OrdinalScale _yScale) {
        return (_context, _data, _index, _groupIndex) -> {
            CrossDataEntry d = (CrossDataEntry)((Object)((Object)_data));
            Object dx = d.column != null ? _xScale.getValue(_context, d.column, _index, _groupIndex) : _xScale.range().get(0);
            Object dy = d.row != null ? _yScale.getValue(_context, d.row, _index, _groupIndex) : _yScale.range().get(0);
            return "translate(" + dx + "," + dy + ")";
        };
    }

    protected static RunFunction<Selector> createHeatSquareUpdater(OrdinalScale _xScale, OrdinalScale _yScale, LinearScale _sizeScale, LinearScale _colorScale, Color _borderColor, double _borderWidth) {
        return (_selection, _args) -> {
            double xRangeBand = _xScale.rangeBand.getValue().doubleValue();
            double yRangeBand = _yScale.rangeBand.getValue().doubleValue();
            if (_sizeScale.domain().get(0).equals(_sizeScale.domain().get(1))) {
                _sizeScale.range(Arrays.asList(0.5, 0.5));
            } else {
                _sizeScale.range(Arrays.asList(0.05, 0.5));
            }
            _selection.each((_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                d._mappedSize = (Double)(d.size != null ? _sizeScale.getValue(_context, (Object)d.size, _index, _groupIndex) : _sizeScale.range().get(0));
            }).attr(SCALE_X, (_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                return 1.0 + (0.5 - d._mappedSize) * xRangeBand;
            }).attr("width", (_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                return Rave2HeatRenderer.adjustForBorder(2.0 * d._mappedSize * xRangeBand, 2.0);
            }).attr(SCALE_Y, (_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                return 1.0 + (0.5 - d._mappedSize) * yRangeBand;
            }).attr("stroke-width", Rave2HeatRenderer.createSquareStrokeWidthLambda(_borderWidth)).attr("height", (_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                return Rave2HeatRenderer.adjustForBorder(2.0 * d._mappedSize * yRangeBand, 2.0);
            }).each((_context, _data, _index, _groupIndex) -> {
                HeatDataPointInfo d = (HeatDataPointInfo)_data;
                String color = (String)_colorScale.getValue(_context, (Object)d.color, _index, _groupIndex);
                if (color == null) {
                    color = (String)_colorScale.range().get(0);
                }
                d._mappedColor = Rave.rgb((Object)color);
            }).attr("display", (Object)"inline").attr("fill", (_context, _data, _index, _groupIndex) -> ((HeatDataPointInfo)_data)._mappedColor).attr("stroke", (Object)_borderColor).attr("stroke-width", (Object)(_borderWidth + "px"));
            return null;
        };
    }

    protected static ValueFunction<Object, ? super Object[]> createOverflowLabelDataLambda(PointRangeData _rangeData, boolean _smallRendering) {
        return (_context, _data, _index, _groupIndex) -> {
            Object[] objectArray;
            CrossDataEntry d = (CrossDataEntry)((Object)((Object)_data));
            if (!_smallRendering && _rangeData.labelsFit() && d.values.length > 0) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = d;
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        };
    }

    protected static ValueFunction<SceneNode, ?> createOverflowLabelTextLambda(PointRangeData _rangeData) {
        return (_context, _data, _index, _groupIndex) -> _rangeData.overflowLabel((CrossDataEntry)((Object)((Object)_data)));
    }

    protected static ValueFunction<SceneNode, ?> createOverflowLabelXLambda(PointRangeData _rangeData) {
        return (_context, _data, _index, _groupIndex) -> _rangeData.textx((CrossDataEntry)((Object)((Object)_data)));
    }

    protected static ValueFunction<SceneNode, ?> createOverflowLabelYLambda(PointRangeData _rangeData) {
        return (_context, _data, _index, _groupIndex) -> _rangeData.texty((CrossDataEntry)((Object)((Object)_data)));
    }

    protected static ValueFunction<SceneNode, ?> createOverflowLabelDisplayLambda(PointRangeData _rangeData) {
        return (_context, _data, _index, _groupIndex) -> _rangeData.textDisplay((CrossDataEntry)((Object)((Object)_data)));
    }

    protected static ValueFunction<SceneNode, ?> createTextPixelSizeLambda(PointRangeData _rangeData) {
        return (_context, _data, _index, _groupIndex) -> {
            double pxSize = Math.min(14.0, Math.max(Math.floor(_rangeData.maxDimension), PointRangeData.minSquareData.labelHeight));
            return pxSize + "px";
        };
    }

    protected static ValueFunction<Object, Object> createCellKeyLambda() {
        return (_context, _data, _index, _groupIndex) -> {
            CrossDataEntry dataPointInfo = (CrossDataEntry)((Object)((Object)_data));
            return dataPointInfo.key;
        };
    }

    protected static ValueFunction<Object, ? super Object[]> createSquareDataLambda() {
        return (_context, _data, _index, _groupIndex) -> ((CrossDataEntry)((Object)((Object)_data))).values;
    }

    protected static ValueFunction<Object, Object> createSquareDataIndexLambda() {
        return (_context, _data, _index, _groupIndex) -> ((HeatDataPointInfo)_data).point;
    }

    protected static CallbackFunction<SceneNode> createSquareColorSizeLambda(LinearScale _sizeScale, LinearScale _colorScale, boolean _useSize) {
        return (_context, _data, _index, _groupIndex) -> {
            HeatDataPointInfo d = (HeatDataPointInfo)_data;
            Double dColor = d.color;
            if (dColor == null) {
                dColor = (Double)_sizeScale.range().get(0);
            }
            d._mappedColor = Rave.rgb((Object)_colorScale.getValue(_context, (Object)dColor, _index, _groupIndex));
            double mappedArea = (Double)(_useSize ? _sizeScale.getValue(_context, (Object)d.size, _index, _groupIndex) : _sizeScale.range().get(1));
            d._mappedPointSize = Math.sqrt(mappedArea);
        };
    }

    protected static ValueFunction<SceneNode, ?> createSquareXcoordinateLambda(PointRangeData rangeData) {
        return (_context, _data, _index, _groupIndex) -> 1.0 + (Double)rangeData.x(_data, _index);
    }

    protected static ValueFunction<SceneNode, ?> createSquareStrokeAttLambda(LinearScale _colorScale) {
        return (_context, _data, _index, _groupIndex) -> {
            Double color = ((HeatDataPointInfo)_data).color;
            if (color == null) {
                color = (Double)_colorScale.range().get(0);
            }
            return color;
        };
    }

    protected static ValueFunction<SceneNode, ?> createSquareDisplayAttLambda(PointRangeData rangeData) {
        return (_context, _data, _index, _groupIndex) -> rangeData.display(_data, _index);
    }

    protected static ValueFunction<? super SceneNode, ?> createSquareDataFillColor() {
        return (_context, _data, _index, _groupIndex) -> ((HeatDataPointInfo)_data)._mappedColor;
    }

    protected static ValueFunction<SceneNode, ?> createSquareStrokeWidthLambda(double _borderWidth) {
        return (_context, _data, _index, _groupIndex) -> _borderWidth + "px";
    }

    protected static ValueFunction<SceneNode, ?> createSquareYcoordinateLambda(PointRangeData rangeData) {
        return (_context, _data, _index, _groupIndex) -> (Double)rangeData.y(_data, _index) + 1.0;
    }

    protected static ValueFunction<SceneNode, ?> createSquareSizeLambda() {
        return (_context, _data, _index, _groupIndex) -> {
            HeatDataPointInfo d = (HeatDataPointInfo)_data;
            return Rave2HeatRenderer.adjustForBorder(d._mappedPointSize, 2.0);
        };
    }

    protected static ValueFunction<SceneNode, ?> createGridlineCoordinateALambda(boolean _xDir, OrdinalScale _scale) {
        return (_context, _data, _index, _groupIndex) -> {
            Number scaleValue = (Number)_scale.getValue(_context, _data, _index, _groupIndex);
            Number rangeValue = _xDir ? (Number)_scale.getRangeBand().getValue() : (Number)0;
            return scaleValue.doubleValue() + rangeValue.doubleValue();
        };
    }

    protected static ValueFunction<SceneNode, ?> createGridlineCoordinateBLambda(OrdinalScale _scale, int _rangeIndex) {
        return (_context, _data, _index, _groupIndex) -> _scale.rangeExtent.getValue().get(_rangeIndex);
    }

    public List<IRSEncoding> getEncodings() {
        ArrayList<IRSEncoding> encodings = new ArrayList<IRSEncoding>();
        if (this._currentData != null) {
            IRSDataSet dataset = this._currentData.getDataSetAt(0);
            IRSSlot sizeSlot = dataset.getSlot(SCALE_SIZE);
            IRSSlot colorSlot = dataset.getSlot(SCALE_COLOR);
            if (sizeSlot != null && sizeSlot.isMapped()) {
                encodings.add((IRSEncoding)ContEncoding.fromDataSlot((IRSSlot)sizeSlot, (String)SCALE_SIZE, (int)0, (RSFormatKind)RSFormatKind.Label, null, (IRSContPaletteProperty)this._heatPalette));
            }
            if (colorSlot != null && colorSlot.isMapped()) {
                encodings.add((IRSEncoding)ContEncoding.fromDataSlot((IRSSlot)colorSlot, (String)SCALE_COLOR, (int)0, (RSFormatKind)RSFormatKind.Label, null, (IRSContPaletteProperty)this._heatPalette));
            }
        }
        return encodings;
    }
}

