/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.gsskerb;

import com.ibm.security.sasl.gsskerb.GssKrb5Base;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;

final class GssKrb5Server
extends GssKrb5Base
implements SaslServer {
    private static final String MY_CLASS_NAME = GssKrb5Server.class.getName();
    private int handshakeStage = 0;
    private String peer;
    private String me;
    private String authzid;
    private CallbackHandler cbh;
    private final String protocolSaved;

    GssKrb5Server(String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        super(props, MY_CLASS_NAME);
        String service;
        this.cbh = cbh;
        if (serverName == null) {
            this.protocolSaved = protocol;
            service = null;
        } else {
            this.protocolSaved = null;
            service = protocol + "@" + serverName;
        }
        logger.log(Level.FINE, "KRB5SRV01:Using service name: {0}", service);
        try {
            GSSManager mgr = GSSManager.getInstance();
            GSSName serviceName = service == null ? null : mgr.createName(service, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSCredential cred = mgr.createCredential(serviceName, Integer.MAX_VALUE, KRB5_OID, 2);
            this.secCtx = mgr.createContext(cred);
        }
        catch (GSSException e) {
            throw new SaslException("Failure to initialize security context", e);
        }
        logger.log(Level.FINE, "KRB5SRV02:Initialization complete");
    }

    @Override
    public byte[] evaluateResponse(byte[] responseData) throws SaslException {
        if (this.completed) {
            throw new SaslException("SASL authentication already complete");
        }
        if (logger.isLoggable(Level.FINER)) {
            GssKrb5Server.traceOutput(MY_CLASS_NAME, "evaluateResponse", "KRB5SRV03:Response [raw]:", responseData);
        }
        switch (this.handshakeStage) {
            case 1: {
                return this.doHandshake1(responseData);
            }
            case 2: {
                return this.doHandshake2(responseData);
            }
        }
        try {
            byte[] gssOutToken = this.secCtx.acceptSecContext(responseData, 0, responseData.length);
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "evaluateResponse", "KRB5SRV04:Challenge: [after acceptSecCtx]", gssOutToken);
            }
            if (this.secCtx.isEstablished()) {
                this.handshakeStage = 1;
                this.peer = this.secCtx.getSrcName().toString();
                this.me = this.secCtx.getTargName().toString();
                logger.log(Level.FINE, "KRB5SRV05:Peer name is : {0}, my name is : {1}", new Object[]{this.peer, this.me});
                if (this.protocolSaved != null && !this.protocolSaved.equalsIgnoreCase(this.me.split("[/@]")[0])) {
                    throw new SaslException("GSS context targ name protocol error: " + this.me);
                }
                if (gssOutToken == null) {
                    return this.doHandshake1(EMPTY);
                }
            }
            return gssOutToken;
        }
        catch (GSSException e) {
            throw new SaslException("GSS initiate failed", e);
        }
    }

    private byte[] doHandshake1(byte[] responseData) throws SaslException {
        try {
            if (responseData != null && responseData.length > 0) {
                throw new SaslException("Handshake expecting no response data from server");
            }
            byte[] gssInToken = new byte[4];
            gssInToken[0] = this.allQop;
            GssKrb5Server.intToNetworkByteOrder(this.recvMaxBufSize, gssInToken, 1, 3);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5SRV06:Supported protections: {0}; recv max buf size: {1}", new Object[]{new Byte(this.allQop), new Integer(this.recvMaxBufSize)});
            }
            this.handshakeStage = 2;
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake1", "KRB5SRV07:Challenge [raw]", gssInToken);
            }
            byte[] gssOutToken = this.secCtx.wrap(gssInToken, 0, gssInToken.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake1", "KRB5SRV08:Challenge [after wrap]", gssOutToken);
            }
            return gssOutToken;
        }
        catch (GSSException e) {
            throw new SaslException("Problem wrapping handshake1", e);
        }
    }

    private byte[] doHandshake2(byte[] responseData) throws SaslException {
        try {
            byte selectedQop;
            byte[] gssOutToken = this.secCtx.unwrap(responseData, 0, responseData.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Server.traceOutput(MY_CLASS_NAME, "doHandshake2", "KRB5SRV09:Response [after unwrap]", gssOutToken);
            }
            if (((selectedQop = gssOutToken[0]) & this.allQop) == 0) {
                throw new SaslException("Client selected unsupported protection: " + selectedQop);
            }
            if ((selectedQop & 4) != 0) {
                this.privacy = true;
                this.integrity = true;
            } else if ((selectedQop & 2) != 0) {
                this.integrity = true;
            }
            this.msgProp = new MessageProp(0, this.privacy);
            int clntMaxBufSize = GssKrb5Server.networkByteOrderToInt(gssOutToken, 1, 3);
            this.sendMaxBufSize = this.sendMaxBufSize == 0 ? clntMaxBufSize : Math.min(this.sendMaxBufSize, clntMaxBufSize);
            this.rawSendSize = this.secCtx.getWrapSizeLimit(0, this.privacy, this.sendMaxBufSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5SRV10:Selected protection: {0}; privacy: {1}; integrity: {2}", new Object[]{new Byte(selectedQop), this.privacy, this.integrity});
                logger.log(Level.FINE, "KRB5SRV11:Client max recv size: {0}; server max send size: {1}; rawSendSize: {2}", new Object[]{new Integer(clntMaxBufSize), new Integer(this.sendMaxBufSize), new Integer(this.rawSendSize)});
            }
            if (gssOutToken.length > 4) {
                try {
                    this.authzid = new String(gssOutToken, 4, gssOutToken.length - 4, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SaslException("Cannot decode authzid", uee);
                }
            } else {
                this.authzid = this.peer;
            }
            logger.log(Level.FINE, "KRB5SRV12:Authzid: {0}", this.authzid);
            AuthorizeCallback acb = new AuthorizeCallback(this.peer, this.authzid);
            this.cbh.handle(new Callback[]{acb});
            if (!acb.isAuthorized()) {
                throw new SaslException(this.peer + " is not authorized to connect as " + this.authzid);
            }
            this.authzid = acb.getAuthorizedID();
            this.completed = true;
            return null;
        }
        catch (GSSException e) {
            throw new SaslException("Final handshake step failed", e);
        }
        catch (IOException e) {
            throw new SaslException("Problem with callback handler", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Problem with callback handler", e);
        }
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("Authentication incomplete");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        Object result;
        if (!this.completed) {
            throw new IllegalStateException("Authentication incomplete");
        }
        switch (propName) {
            case "javax.security.sasl.bound.server.name": {
                try {
                    result = this.me.split("[/@]")[1];
                }
                catch (Exception e) {
                    result = null;
                }
                break;
            }
            default: {
                result = super.getNegotiatedProperty(propName);
            }
        }
        return result;
    }
}

