/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.axes.Axis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.DataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XDataAxisImpl
extends DataAxisImpl
implements XDataAxis {
    private static final Logger TRACE = LogFactory.getTrace(XDataAxisImpl.class);
    private final double[] xValues = new double[8];
    private int sequenceUID;
    private int sequenceHighWaterMark;
    private int nestDepth = 0;
    private static final int UNSET = -1;
    private long seed = -1L;

    public XDataAxisImpl(Axis axis, Source source, OutputProperties outputProperties, String string) {
        super(axis, outputProperties, string);
        this.resetNesting();
        this.clear();
        this.rawOffset = outputProperties.getRawXOffset();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long l) {
        this.seed = l;
    }

    @Override
    public DataPoint getMaximumBound() {
        if (this.properties != null) {
            return this.properties.getMaximumX(this.axis.getAxisIdentifierName());
        }
        return null;
    }

    @Override
    public DataPoint getMinimumBound() {
        if (this.properties != null) {
            return this.properties.getMinimumX(this.axis.getAxisIdentifierName());
        }
        return null;
    }

    @Override
    public void setMaximumBound(DataPoint dataPoint) {
        if (TRACE.isLoggable(Level.FINE)) {
            TRACE.fine(this + " setting maximum to " + dataPoint);
        }
        this.properties.setMaximumX(this.axis.getAxisIdentifierName(), dataPoint);
    }

    @Override
    public void setMinimumBound(DataPoint dataPoint) {
        if (TRACE.isLoggable(Level.FINE)) {
            TRACE.fine(this + " setting minimum to " + dataPoint);
        }
        this.properties.setMinimumX(this.axis.getAxisIdentifierName(), dataPoint);
    }

    @Override
    public void clearMinimumBound() {
        this.properties.clearMinimumX();
    }

    @Override
    public void clearMaximumBound() {
        this.properties.clearMaximumX();
    }

    @Override
    public void setX(double d) {
        ++this.sequenceUID;
        if (this.sequenceUID > this.sequenceHighWaterMark) {
            this.sequenceHighWaterMark = this.sequenceUID;
        }
        this.checkNestDepth();
        this.xValues[this.nestDepth] = d;
    }

    @Override
    public double getX() {
        this.checkNestDepth();
        return this.xValues[this.nestDepth];
    }

    private void checkNestDepth() {
        if (this.nestDepth < 0) {
            this.nestDepth = 0;
        }
        if (this.nestDepth >= this.xValues.length) {
            this.nestDepth = this.xValues.length - 1;
        }
    }

    @Override
    public int getSequenceUID() {
        return this.sequenceUID;
    }

    public int checkSequenceUID(int n) {
        if (this.sequenceUID <= n) {
            this.sequenceHighWaterMark = this.sequenceUID = n + 1;
        }
        return this.sequenceUID;
    }

    @Override
    public void rollXBackwards() {
        if (this.nestDepth < this.xValues.length) {
            ++this.nestDepth;
        }
    }

    @Override
    public void rollXForward() {
        if (this.nestDepth >= 0) {
            --this.nestDepth;
        }
        if (this.nestDepth > 0) {
            --this.sequenceUID;
        }
    }

    @Override
    public boolean isNested() {
        return this.nestDepth > 0;
    }

    @Override
    public void resetNesting() {
        this.nestDepth = 0;
        this.sequenceUID = this.sequenceHighWaterMark;
    }

    private void clear() {
        for (int i = 0; i < this.xValues.length; ++i) {
            this.xValues[i] = -1.0;
        }
        this.seed = -1L;
        this.sequenceHighWaterMark = this.sequenceUID = -1;
        this.resetNesting();
    }

    @Override
    protected void registerWithProperties() {
        this.properties.registerXAxisListener(this);
    }

    @Override
    protected DataPointBuilder getMaximum(TwoDimensionalData twoDimensionalData) {
        return twoDimensionalData.getMaxX();
    }

    @Override
    protected DataPointBuilder getMinimum(TwoDimensionalData twoDimensionalData) {
        return twoDimensionalData.getMinX();
    }

    @Override
    protected double getValue(DataPointBuilder dataPointBuilder) {
        return dataPointBuilder.getX();
    }
}

