/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ParsedData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.PostprocessedData;
import java.util.Map;

public class RootDataImpl
extends DataImpl {
    private final DataImpl parsedData;
    private final DataImpl postprocessedData;
    private volatile boolean isPostprocessing;
    private final DataUtil dataUtil = new DataUtil();

    public RootDataImpl(String string) {
        super(string);
        this.parsedData = new ParsedData(string);
        this.parsedData.setParent(this);
        this.postprocessedData = new PostprocessedData(string);
        this.postprocessedData.setParent(this);
        this.switchToParsing();
    }

    @Override
    protected boolean getPostProcessing() {
        return this.isPostprocessing;
    }

    public synchronized void switchToPostprocessing() {
        this.isPostprocessing = true;
    }

    public synchronized void switchToParsing() {
        this.isPostprocessing = false;
    }

    @Override
    protected void registerAsMixed(DataImpl dataImpl) {
        if (this.dataUtil != null) {
            this.dataUtil.register(dataImpl);
        }
    }

    @Override
    public DataBuilder[] getChildren() {
        DataBuilder[] dataBuilderArray;
        Map<String, DataBuilder> map = this.createNewDataMap();
        DataBuilder[] dataBuilderArray2 = dataBuilderArray = this.postprocessedData.getChildren();
        int n = dataBuilderArray2.length;
        for (int i = 0; i < n; ++i) {
            DataBuilder dataBuilder = dataBuilderArray2[i];
            map.put(dataBuilder.getID(), dataBuilder);
        }
        for (DataBuilder dataBuilder : dataBuilderArray2 = this.parsedData.getChildren()) {
            map.put(dataBuilder.getID(), dataBuilder);
        }
        return map.values().toArray(dataTemplateArray);
    }

    @Override
    public boolean hasChildren() {
        return this.postprocessedData.hasChildren() || this.parsedData.hasChildren();
    }

    @Override
    public boolean isEmpty() {
        return this.parsedData.isEmpty() && this.postprocessedData.isEmpty();
    }

    @Override
    public DataBuilder getData(String string) {
        if (this.getID().equals(string)) {
            return this;
        }
        DataBuilder dataBuilder = null;
        DataBuilder dataBuilder2 = this.postprocessedData.getData(string);
        DataBuilder dataBuilder3 = this.parsedData.getData(string);
        if (dataBuilder3 == null) {
            dataBuilder = dataBuilder2;
        } else if (dataBuilder2 == null) {
            dataBuilder = dataBuilder3;
        } else {
            ((DataImpl)dataBuilder2).mergeData((DataImpl)dataBuilder3);
            dataBuilder = dataBuilder2;
        }
        return dataBuilder;
    }

    @Override
    public DataBuilder getTopLevelData(String string) {
        DataBuilder dataBuilder = this.postprocessedData.getTopLevelData(string);
        if (dataBuilder == null) {
            dataBuilder = this.parsedData.getTopLevelData(string);
        }
        return dataBuilder;
    }

    @Override
    public void mergeData(DataImpl dataImpl) {
        if (this.isPostprocessing()) {
            this.postprocessedData.mergeData(dataImpl);
        } else {
            this.parsedData.mergeData(dataImpl);
        }
    }

    @Override
    public synchronized void addData(DataBuilder dataBuilder) {
        if (dataBuilder != null && this != dataBuilder) {
            if (this.isPostprocessing()) {
                this.postprocessedData.addData(dataBuilder);
            } else {
                this.parsedData.addData(dataBuilder);
            }
        }
        this.notifyListeners();
    }

    @Override
    public void removeData(String string) {
        this.postprocessedData.removeData(string);
        this.parsedData.removeData(string);
    }

    @Override
    public synchronized void clearPostprocessedData() {
        this.postprocessedData.clear();
        this.parsedData.clearPostprocessedData();
    }

    @Override
    public synchronized void clear() {
        this.dataUtil.clear();
        this.parsedData.clear();
        this.postprocessedData.clear();
    }

    public DataImpl getParsedData() {
        return this.parsedData;
    }

    public void clearPostprocessedLayer() {
        if (this.dataUtil != null) {
            this.dataUtil.clearPostprocessedLayer();
        }
    }
}

