/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.lateattach;

import com.ibm.java.diagnostics.healthcenter.agent.lateattach.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.tools.attach.AgentInitializationException;
import com.ibm.tools.attach.AgentLoadException;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;

public class AttachAgent {
    public static final int attachAgent_OK = 0;
    public static final int attachAgent_ERR = -1;
    public static final int attachAgent_ALREADY_LOADED = -2;
    public static final int attachAgent_JVMTI_ERR = -3;
    public static final int attachAgent_MBEAN_ERR = -4;
    public static final int attachAgent_MBEAN_EXC = -5;
    private static final String[] attachAgent_message_keys;
    private static String CONFIG;
    private static List<VirtualMachineDescriptor> vmList;
    private static final Class<?> thisClass;
    private static final Logger logger;
    private static final String ID_KEY = "ID";
    private static final String NORETRY_OPTION = "-noretry";
    private static final String EXTRACT_OPTION = "-extract";
    private static final String OVERRIDE_OPTION = "-override";
    private static final String BIN = "bin";
    private static final String EXT = "ext";
    private static final String HC_DLL = "healthcenter.dll";
    private static final String HC_SO = "libhealthcenter.so";
    private static String remoteAgentPath;
    private static final String REMOTE_AGENT_PROPERTY = "-Dcom.ibm.java.diagnostics.healthcenter.agent.path";

    public static void init(String[] stringArray) {
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        String string = null;
        String string2 = null;
        Properties properties = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            String string5 = HealthCenterOptionHandler.processOption(stringArray[i], ID_KEY);
            if (string5 != null) {
                string3 = string5;
                stringArray[i] = null;
            }
            if (NORETRY_OPTION.equalsIgnoreCase(stringArray[i])) {
                bl = true;
                stringArray[i] = null;
            }
            if (EXTRACT_OPTION.equalsIgnoreCase(stringArray[i])) {
                AttachAgent.extractPropertyFiles();
                System.exit(0);
            }
            if (!OVERRIDE_OPTION.equalsIgnoreCase(stringArray[i])) continue;
            File file = new File(".");
            String string6 = file.getAbsolutePath();
            if (string6.length() > 0 && string6.charAt(string6.length() - 1) == '.') {
                string6 = string6.substring(0, string6.length() - 2);
            }
            string6 = string6.replace('\\', '/');
            stringArray[i] = string4 = String.format(CONFIG, string6);
        }
        string2 = AttachAgent.buildOptions(stringArray);
        if (string2 == null) {
            System.exit(1);
        }
        if (!string2.contains("event=") && !string2.contains("com.ibm.java.diagnostics.healthcenter.data.collection.event")) {
            String string7 = System.getProperty("com.ibm.java.diagnostics.healthcenter.data.collection.event", "");
            string2 = string7.equals("") ? "event=none," + string2 : "event=" + string7 + "," + string2;
        }
        if (!string2.contains("level=") && !string2.contains("com.ibm.java.diagnostics.healthcenter.data.collection.level")) {
            String string8 = System.getProperty("com.ibm.java.diagnostics.healthcenter.data.collection.level", "");
            string2 = string8.equals("") ? "level=full," + string2 : "level=" + string8 + "," + string2;
        }
        while (n != 0 && string3 != null) {
            properties = new Properties();
            n = AttachAgent.ConnectandLoadLibrary(string3, string2, properties);
            if (n == 0) {
                string = string3;
                continue;
            }
            if (bl) break;
            Messages.issueMessage("AttachAgent.pid.prompt", new Object[0]);
            string3 = AttachAgent.readLine();
            if (string3.length() != 0) continue;
            Messages.issueMessage("AttachAgent.pid.empty", new Object[0]);
            string3 = null;
        }
        while (n != 0 && !bl) {
            vmList = VirtualMachine.list();
            String string9 = "";
            if (vmList != null && vmList.size() > 0) {
                Messages.issueMessage("AttachAgent.vmlist.header", new Object[0]);
                for (int i = 0; i < vmList.size(); ++i) {
                    Messages.issueMessage("AttachAgent.vmlist.entry", i + 1, vmList.get(i).displayName(), vmList.get(i).id());
                }
                Messages.issueMessage("AttachAgent.vmlist.prompt", vmList.size());
                string9 = AttachAgent.readLine();
                if (string9.length() == 0) {
                    Messages.issueMessage("AttachAgent.vmlist.quit", new Object[0]);
                    break;
                }
                n2 = AttachAgent.validVMNumber(string9);
                if (n2 == 0) {
                    Messages.issueMessage("AttachAgent.vm.invalid", new Object[0]);
                    continue;
                }
                VirtualMachineDescriptor virtualMachineDescriptor = vmList.get(n2 - 1);
                properties = new Properties();
                n = AttachAgent.ConnectandLoadLibrary(virtualMachineDescriptor.id(), string2, properties);
                if (n != 0) continue;
                string = virtualMachineDescriptor.displayName();
                continue;
            }
            Messages.issueMessage("AttachAgent.vm.none", new Object[0]);
            break;
        }
        if (n == 0) {
            Messages.issueMessage("AttachAgent.vm.connected", string);
            AttachAgent.restrictHCPropertiesForDisplay(properties);
            if (properties.size() > 0) {
                StringWriter stringWriter = new StringWriter();
                properties.list(new PrintWriter(stringWriter));
                Messages.issueMessage("AttachAgent.vm.properties", stringWriter.toString());
            } else {
                Messages.issueMessage("AttachAgent.vm.noprops", new Object[0]);
            }
        }
        System.exit(n);
    }

    private static void extractPropertyFiles() {
        String string = "/com/ibm/java/diagnostics/healthcenter/agent/dataproviders/capabilities/";
        String[] stringArray = new String[]{"Cpu", "JLA", "Memory", "Threads", "TRACE"};
        InputStream inputStream = null;
        for (String string2 : stringArray) {
            String string3 = string2 + "SourceConfiguration.properties";
            inputStream = AttachAgent.class.getResourceAsStream(string + string3);
            if (inputStream == null) {
                Messages.issueMessage("AttachAgent.warn.noprop", string3);
                continue;
            }
            AttachAgent.extractPropertyFile(inputStream, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractPropertyFile(InputStream inputStream, String string) {
        FileOutputStream fileOutputStream;
        block9: {
            block8: {
                byte[] byArray = new byte[4096];
                int n = 0;
                fileOutputStream = null;
                try {
                    File file = new File(string);
                    if (file.exists()) {
                        Messages.issueMessage("AttachAgent.warn.skipprop", string);
                        AttachAgent.close(fileOutputStream);
                        break block8;
                    }
                    fileOutputStream = new FileOutputStream(file);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    Messages.issueMessage("AttachAgent.extract.prop", string);
                    AttachAgent.close(fileOutputStream);
                    break block9;
                }
                catch (IOException iOException) {
                    Messages.issueMessage("AttachAgent.warn.extractprop", string);
                    return;
                }
            }
            AttachAgent.close(inputStream);
            return;
        }
        AttachAgent.close(inputStream);
        return;
        finally {
            AttachAgent.close(fileOutputStream);
            AttachAgent.close(inputStream);
        }
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String buildOptions(String[] stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            StringWriter stringWriter = new StringWriter();
            for (String object2 : stringArray) {
                if (null == object2) continue;
                if (object2.startsWith("-D")) {
                    String n;
                    if (object2.startsWith(REMOTE_AGENT_PROPERTY)) {
                        remoteAgentPath = HealthCenterOptionHandler.processOption(object2, REMOTE_AGENT_PROPERTY);
                        n = "-Dcom.ibm.java.diagnostics.healthcenter.agent.path=" + remoteAgentPath.replace("\\", "\\\\");
                    } else {
                        n = object2;
                    }
                    stringWriter.write(n, 2, n.length() - 2);
                    stringWriter.append('\n');
                    continue;
                }
                outputStreamWriter.append(object2);
                outputStreamWriter.append(',');
                outputStreamWriter.flush();
                int bl = object2.indexOf("path=");
                if (bl == -1) continue;
                remoteAgentPath = HealthCenterOptionHandler.processOption(object2.substring(bl).split(",")[0], "path");
            }
            stringWriter.flush();
            HealthCenterOptionHandler healthCenterOptionHandler = new HealthCenterOptionHandler(logger);
            int n = healthCenterOptionHandler.validateOptions(byteArrayOutputStream.toString("UTF-8")) ? 1 : 0;
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringWriter.toString().getBytes("ISO8859-1"));
            properties.load(byteArrayInputStream);
            boolean bl = HealthCenterOptionHandler.validateHCProperties(properties, logger);
            if (n == 0 || !bl) {
                return null;
            }
            if (!properties.isEmpty()) {
                properties.storeToXML(byteArrayOutputStream, null);
                byteArrayOutputStream.flush();
            }
            String string = byteArrayOutputStream.toString("UTF-8");
            string = string.replace('\n', ' ');
            string = string.replace('\r', ' ');
            return string;
        }
        catch (IOException iOException) {
            Messages.issueMessage("AttachAgent.error.exception", iOException.toString());
            Messages.printException(iOException);
            return null;
        }
    }

    private static int ConnectandLoadLibrary(String string, String string2, Properties properties) {
        try {
            int n;
            VirtualMachine virtualMachine = VirtualMachine.attach((String)string);
            Properties properties2 = virtualMachine.getSystemProperties();
            properties.putAll((Map<?, ?>)properties2);
            String string3 = properties.getProperty("com.ibm.java.diagnostics.healthcenter.running");
            if (string3 != null && string3.equals("true")) {
                System.out.println("");
                Messages.issueMessage("AttachAgent.native.loaded", new Object[0]);
                System.out.println("");
                n = -2;
            } else {
                Object object;
                if (remoteAgentPath == null && !((String)(object = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.path", ""))).equals("")) {
                    remoteAgentPath = object;
                }
                if (remoteAgentPath == null) {
                    virtualMachine.loadAgentLibrary("healthcenter", string2);
                } else {
                    object = new File(remoteAgentPath + File.separator + "jre");
                    if (((File)object).exists()) {
                        remoteAgentPath = remoteAgentPath + File.separator + "jre";
                    }
                    if (((File)(object = new File(remoteAgentPath + File.separator + BIN + File.separator + HC_DLL))).exists()) {
                        remoteAgentPath = ((File)object).getAbsolutePath();
                    } else {
                        remoteAgentPath = remoteAgentPath + File.separator + "lib";
                        object = new File(remoteAgentPath);
                        File[] fileArray = ((File)object).listFiles();
                        for (int i = 0; i < fileArray.length; ++i) {
                            if (!fileArray[i].isDirectory() || fileArray[i].toString().endsWith(EXT)) continue;
                            remoteAgentPath = fileArray[i].getAbsolutePath() + File.separator + HC_SO;
                            break;
                        }
                    }
                    virtualMachine.loadAgentPath(remoteAgentPath, string2);
                }
                properties2 = virtualMachine.getSystemProperties();
                properties.putAll((Map<?, ?>)properties2);
                n = 0;
            }
            virtualMachine.detach();
            return n;
        }
        catch (AttachNotSupportedException attachNotSupportedException) {
            Messages.issueMessage("AttachAgent.vm.unsupported", new Object[0]);
            return -1;
        }
        catch (IOException iOException) {
            Messages.issueMessage("AttachAgent.error.io", iOException.getMessage());
            return -1;
        }
        catch (AgentLoadException agentLoadException) {
            Messages.issueMessage("AttachAgent.error.load", new Object[0]);
            return -1;
        }
        catch (AgentInitializationException agentInitializationException) {
            String string4;
            int n;
            int n2 = agentInitializationException.returnValue();
            if (0 == n2 && (n = (string4 = agentInitializationException.getMessage()).lastIndexOf("-")) >= 0) {
                try {
                    n2 = Integer.parseInt(string4.substring(n));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Messages.issueMessage("AttachAgent.error.init", n2);
            string4 = null;
            try {
                string4 = attachAgent_message_keys[-n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (null == string4) {
                string4 = attachAgent_message_keys[0];
            }
            Messages.issueMessage(string4, new Object[0]);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLine() {
        Scanner scanner = new Scanner(System.in);
        try {
            String string = scanner.nextLine().trim();
            return string;
        }
        catch (Exception exception) {
            String string = "";
            return string;
        }
        finally {
            scanner.close();
        }
    }

    private static void restrictHCPropertiesForDisplay(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("com.ibm.java.diagnostics.healthcenter.agent.port") || string.equals("com.ibm.java.diagnostics.healthcenter.data.collection.event") || string.equals("com.ibm.java.diagnostics.healthcenter.data.collection.level")) continue;
            properties.remove(string);
        }
    }

    private static int validVMNumber(String string) {
        int n = 0;
        if (AttachAgent.isNumeric(string)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Messages.issueMessage("AttachAgent.vm.invalid", new Object[0]);
            }
            if (n > vmList.size()) {
                n = 0;
            }
        }
        return n;
    }

    private static boolean isNumeric(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    static {
        Class<?> clazz;
        attachAgent_message_keys = new String[]{"AttachAgent.native.invresp", "AttachAgent.native.error", "AttachAgent.native.loaded", "AttachAgent.native.jvmtierr", "AttachAgent.native.mbeanerr", "AttachAgent.native.mbeanexc", null, null, null, null, null};
        CONFIG = "-Dcom.ibm.java.diagnostics.healthcenter.config=%s";
        vmList = null;
        try {
            clazz = Class.forName("com.ibm.java.diagnostics.healthcenter.agent.lateattach.AttachAgent");
        }
        catch (Exception exception) {
            clazz = null;
        }
        thisClass = clazz;
        logger = AgentLogFactory.setUpLogging(thisClass);
        remoteAgentPath = null;
    }
}

