/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.vmcontrol.impl;

import com.ibm.java.diagnostics.common.datamodel.data.ControllableData;
import com.ibm.java.diagnostics.common.datamodel.data.ControlledData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ControllableSingleConfigurableItemData;
import com.ibm.java.diagnostics.healthcenter.JVMData;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterException;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterNotSupportedException;
import com.ibm.java.diagnostics.healthcenter.api.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.api.vmcontrol.VMControl;
import com.ibm.java.diagnostics.healthcenter.classes.ClassHistogramUtil;
import com.ibm.java.diagnostics.healthcenter.gc.GCDataCollection;
import com.ibm.java.diagnostics.healthcenter.gc.Threshold;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.StackControlDataImpl;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.TraceControlDataImpl;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.VmControlLabels;

public class VMControlImpl
implements VMControl {
    private GCDataCollection gCDC;
    private Data jvmData;
    private static final String HEAP = "heapdump=";
    private static final String JAVA = "javadump=";
    private static final String SYSTEM = "systemdump=";
    private static final String SET = "set";
    private boolean heapDump = false;
    private boolean systemDump = false;
    private boolean javaDump = false;

    public VMControlImpl(Data data) {
        this.jvmData = data;
        this.gCDC = new GCDataCollection();
    }

    @Override
    public void setObjectAllocationsEnabled(long l, long l2) {
        String string = l2 == 0L ? "" : Long.toString(l2);
        Threshold threshold = new Threshold(Long.toString(l), this.gCDC.is64bitconnection());
        Threshold threshold2 = new Threshold(string, this.gCDC.is64bitconnection());
        if (!threshold.isValid() || !threshold2.isValid() || threshold2.getBytes() < threshold.getBytes()) {
            System.out.println("invalid options");
            return;
        }
        this.gCDC.sendSetCommand(this.jvmData, "lowallocationthreshold=" + threshold.getValue(), "highallocationthreshold=" + threshold2.getValue());
    }

    @Override
    public void setObjectAllocationsEnabled(long l) {
        this.setObjectAllocationsEnabled(l, 0L);
    }

    @Override
    public void setVerboseGCCollectionEnabled(boolean bl) {
        if (bl) {
            this.gCDC.sendSetCommand(this.jvmData, "verbose.gc=on");
        } else {
            this.gCDC.sendSetCommand(this.jvmData, "verbose.gc=off");
        }
    }

    @Override
    public boolean triggerHeapDump() {
        this.heapDump = true;
        this.systemDump = false;
        this.javaDump = false;
        return this.performDumpTrigger();
    }

    private boolean performDumpTrigger() {
        String string = JVMLabels.ENVIRONMENT + SubsystemDataBuilder.CONFIGURATION;
        Data data = this.jvmData.getData(string);
        if (data != null) {
            Data[] dataArray = data.getChildren();
            for (int i = 0; i < dataArray.length; ++i) {
                ControllableSingleConfigurableItemData controllableSingleConfigurableItemData;
                ConfigurableSource configurableSource;
                if (!(dataArray[i] instanceof ControllableSingleConfigurableItemData) || !((configurableSource = (controllableSingleConfigurableItemData = (ControllableSingleConfigurableItemData)dataArray[i]).getSource()) instanceof JmxEnablementConfigurationSourceImpl)) continue;
                ((JmxEnablementConfigurationSourceImpl)configurableSource).modify(SET, HEAP + this.heapDump, SYSTEM + this.systemDump, JAVA + this.javaDump);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean triggerJavaDump() {
        this.heapDump = false;
        this.systemDump = false;
        this.javaDump = true;
        return this.performDumpTrigger();
    }

    @Override
    public boolean triggerSystemDump() {
        this.heapDump = false;
        this.systemDump = true;
        this.javaDump = false;
        return this.performDumpTrigger();
    }

    @Override
    public void setGCDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.GARBAGE_COLLECTION);
    }

    @Override
    public void setClassesDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.CLASSES);
    }

    @Override
    public void setIODataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.IO);
    }

    @Override
    public void setLockingDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.LOCKING);
    }

    @Override
    public void setNativeMemoryDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.MEMORY);
    }

    @Override
    public void setProfilingDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.PROFILING);
    }

    @Override
    public void setThreadDataCollectionEnabled(boolean bl) {
        this.enableSubsystemCollection(bl, JVMLabels.THREADS);
    }

    private void enableSubsystemCollection(boolean bl, String string) {
        for (Data data : this.jvmData.getChildren()) {
            if (!data.getLabel().equalsIgnoreCase(string)) continue;
            String string2 = data.getLabel() + SubsystemDataBuilder.CONFIGURATION;
            Data data2 = this.jvmData.getData(string2);
            if (data2 == null) break;
            Data[] dataArray = data2.getChildren();
            for (int i = 0; i < dataArray.length; ++i) {
                if (!(dataArray[i] instanceof ControlledData)) continue;
                ControllableData controllableData = (ControllableData)dataArray[i];
                if (bl) {
                    controllableData.enable();
                    continue;
                }
                controllableData.disable();
            }
            break;
        }
    }

    @Override
    public void setTracePointEnabled(String string, boolean bl) throws HealthCenterException {
        TraceControlDataImpl traceControlDataImpl = this.getTraceControl();
        if (traceControlDataImpl != null) {
            if (bl) {
                traceControlDataImpl.enable(string);
            } else {
                traceControlDataImpl.disable(string);
            }
        } else {
            throw new HealthCenterException(Messages.getString("vmcontrol.traceControl.notready"));
        }
    }

    private TraceControlDataImpl getTraceControl() {
        Data data;
        Data data2;
        if (this.jvmData != null && (data2 = this.jvmData.getTopLevelData(SubsystemDataBuilder.CONFIGURATION)) != null && (data = data2.getData(VmControlLabels.TRACECONTROL)) instanceof TraceControlDataImpl) {
            return (TraceControlDataImpl)data;
        }
        return null;
    }

    @Override
    public void setCallStackCollectionEnabled(boolean bl) {
        StackControlThread stackControlThread = new StackControlThread(bl);
        stackControlThread.start();
    }

    @Override
    public void setMaxStackDepth(int n) {
        Integer n2 = new Integer(n);
        this.gCDC.sendSetCommand(this.jvmData, "stacktracedepth=" + n2.toString());
    }

    @Override
    public boolean isGCDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.GARBAGE_COLLECTION, "gc_subsystem");
    }

    @Override
    public boolean isIODataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.IO, "io_subsystem");
    }

    @Override
    public boolean isClassesDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.CLASSES, "classes_subsystem");
    }

    @Override
    public boolean isLockingDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.LOCKING, "locking_subsystem");
    }

    @Override
    public boolean isNativeMemoryDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.MEMORY, "memory_subsystem");
    }

    @Override
    public boolean isProfilingDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.PROFILING, "profiling_subsystem");
    }

    @Override
    public boolean isThreadsDataCollectionEnabled() {
        return this.isSubsystemCollectionEnabled(JVMLabels.THREADS, "thread_subsystem");
    }

    private boolean isSubsystemCollectionEnabled(String string, String string2) {
        String string3 = string;
        DataBuilder dataBuilder = (DataBuilder)this.jvmData.getTopLevelData(string3);
        boolean bl = dataBuilder != null;
        ControlledData controlledData = this.getConfigurationData((DataBuilder)this.jvmData, string2);
        if (controlledData != null) {
            if (controlledData.isEnabled()) {
                if (!bl) {
                    return true;
                }
                return true;
            }
            if (!bl) {
                return false;
            }
            return false;
        }
        return false;
    }

    private ControlledData getConfigurationData(DataBuilder dataBuilder, String string) {
        DataBuilder dataBuilder2;
        DataBuilder dataBuilder3;
        if (string != null && (dataBuilder3 = dataBuilder.getTopLevelData(SubsystemDataBuilder.CONFIGURATION)) != null && (dataBuilder2 = dataBuilder3.getData(string)) instanceof ControlledData) {
            return (ControlledData)((Object)dataBuilder2);
        }
        return null;
    }

    @Override
    public void collectClassHistogramData() throws HealthCenterNotSupportedException {
        Data data = MarshallerImpl.getMarshaller().getData(null);
        if (data instanceof JVMData) {
            if (ClassHistogramUtil.agentLevelGood(data)) {
                ClassHistogramUtil.triggerDataCollection(MarshallerImpl.getMarshaller());
            } else {
                throw new HealthCenterNotSupportedException();
            }
        }
    }

    @Override
    public void setThreadStackDepth(int n) {
        String string;
        JVMData jVMData;
        Data data;
        Data data2 = MarshallerImpl.getMarshaller().getData(null);
        if (data2 instanceof JVMData && (data = (jVMData = (JVMData)data2).getData(string = JVMLabels.THREADS + SubsystemDataBuilder.CONFIGURATION)) != null) {
            Data[] dataArray = data.getChildren();
            for (int i = 0; i < dataArray.length; ++i) {
                ControllableSingleConfigurableItemData controllableSingleConfigurableItemData;
                ConfigurableSource configurableSource;
                if (!(dataArray[i] instanceof ControllableSingleConfigurableItemData) || !((configurableSource = (controllableSingleConfigurableItemData = (ControllableSingleConfigurableItemData)dataArray[i]).getSource()) instanceof JmxEnablementConfigurationSourceImpl)) continue;
                ((JmxEnablementConfigurationSourceImpl)configurableSource).modify("setStack", Integer.toString(n));
            }
        }
    }

    public class StackControlThread
    extends Thread {
        private boolean value;

        public StackControlThread(boolean bl) {
            this.value = bl;
        }

        @Override
        public void run() {
            StackControlDataImpl stackControlDataImpl = null;
            while (stackControlDataImpl == null) {
                stackControlDataImpl = VMControlImpl.this.gCDC.getStackControl(VMControlImpl.this.jvmData);
                if (stackControlDataImpl != null) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (stackControlDataImpl != null) {
                if (this.value) {
                    stackControlDataImpl.enableTrigger("j9mm.395");
                } else {
                    stackControlDataImpl.disableTrigger("j9mm.395");
                }
                VMControlImpl.this.setMaxStackDepth(VMControlImpl.this.gCDC.getCurrentStackDepth());
            }
        }
    }
}

