/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.classes.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.classes.ClassesLabels;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassLoadingDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.classes.postprocessor.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetricsUtil;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassLoadingDataPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(ClassLoadingDataPostProcessor.class);
    private static final String CLASS_NAME = ClassLoadingDataPostProcessor.class.getName();
    private static final Pattern SHARECLASSES_MATCHER = Pattern.compile("-Xshareclasses(.*?)@@@");

    /*
     * WARNING - void declaration
     */
    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(ClassesLabels.DATA_LABEL);
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (subsystemDataBuilder != null) {
            Data data = subsystemDataBuilder.getData(ClassesLabels.LOADED_CLASSES);
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(ClassesLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(ClassesLabels.RECOMMENDATION_LABEL);
            subsystemDataBuilder.addData(structuredStringDataImpl);
            if (data != null) {
                DataBuilder dataBuilder3;
                Object object;
                int n = 0;
                long l = 0L;
                int n2 = 0;
                for (DataPointBuilder dataPointBuilder : ((TwoDimensionalData)data).getDataPoints()) {
                    object = (ClassLoadingDataPointImpl)dataPointBuilder;
                    ++n;
                    if (!((ClassLoadingDataPointImpl)object).getClassLoadingEvent().wasCachedInSharedClasses()) continue;
                    ++n2;
                }
                Object var11_11 = null;
                if (dataBuilder2 != null && (dataBuilder3 = dataBuilder2.getData(GCLabels.CLASSES_UNLOADED)) != null) {
                    l = Math.round(((TwoDimensionalData)((Object)dataBuilder3)).getTotalY());
                }
                if (subsystemDataBuilder instanceof SubsystemDataBuilder) {
                    boolean bl;
                    boolean bl2;
                    Object object2;
                    Matcher matcher;
                    Data data2;
                    void var11_13;
                    SubsystemDataBuilder subsystemDataBuilder2 = subsystemDataBuilder;
                    subsystemDataBuilder2.clearValue();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (var11_13 != null) {
                        String string = MessageFormat.format(Messages.getString("ClassLoadingDataPostProcessor.loadedAndUnloadedClasses"), n, l);
                        stringBuffer.append(string);
                    } else {
                        String string = MessageFormat.format(Messages.getString("ClassLoadingDataPostProcessor.loadedClasses"), n);
                        stringBuffer.append(string);
                    }
                    boolean bl3 = false;
                    object = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
                    if (object != null && (data2 = object.getData(EnvironmentLabels.COMMAND_LINE)) instanceof StringData && (matcher = SHARECLASSES_MATCHER.matcher((CharSequence)(object2 = ((StringData)data2).getValue()))).find()) {
                        bl2 = true;
                    }
                    boolean bl4 = bl = n2 > 0 || bl2;
                    if (!bl) {
                        stringBuffer.append(Messages.getString("ClassLoadingDataPostProcessor.phraseSeparator"));
                        object2 = Messages.getString("ClassLoadingDataPostProcessor.classSharingAdvice");
                        stringBuffer.append((String)object2);
                    }
                    object2 = (StructuredStringDataBuilder)subsystemDataBuilder2.getData(ClassesLabels.RECOMMENDATION_LABEL);
                    object2.addGoodThing(stringBuffer.toString());
                    double d = TraceMetricsUtil.getMissingDataRatio(dataBuilder);
                    if (d > 0.0) {
                        String string = Messages.getString("ClassLoadingDataPostProcessor.droppedData.descriptive");
                        object2.addInformation(string);
                    }
                    this.setHighLevelMessage(subsystemDataBuilder2, (StructuredStringDataBuilder)object2);
                }
            }
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }
}

