/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineDumpOptionChecker {
    private final Logger logger;
    private final Collection<String> commandLineOptions;
    private Set<String> dumpTypesDisabledOptions;
    private Set<String> reducedSignalOptions;
    private boolean noCoreMmapIsPresent = false;
    private boolean dumpOptionsReset = false;
    private static final String OPTION_WHICH_RESETS_DUMP_OPTIONS = "-Xdump:none";
    private static final String[] OPTIONS_WHICH_REDUCE_SIGNALS = new String[]{"-Xrs", "-Xnosigcatch", "-Xnosigchain"};

    public CommandLineDumpOptionChecker(Logger logger, Collection<String> collection) {
        this.logger = logger;
        this.commandLineOptions = collection;
    }

    public Level getReportPriority() {
        Level level = null;
        this.populateProblematicOptions();
        if (this.dumpOptionsReset) {
            level = Level.WARNING;
        } else if (this.reducedSignalOptions != null && this.reducedSignalOptions.size() > 0) {
            level = Level.WARNING;
        } else if (this.dumpTypesDisabledOptions != null && this.dumpTypesDisabledOptions.size() > 0) {
            level = Level.WARNING;
        } else if (this.noCoreMmapIsPresent) {
            level = Level.WARNING;
        }
        return level;
    }

    private void populateProblematicOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.commandLineOptions) {
            stringBuffer.append(string + " ");
        }
        this.logger.fine("checking command line options: " + stringBuffer.toString());
        if (this.commandLineOptions.contains(OPTION_WHICH_RESETS_DUMP_OPTIONS)) {
            this.dumpOptionsReset = true;
        }
        for (String string : OPTIONS_WHICH_REDUCE_SIGNALS) {
            if (!this.commandLineOptions.contains(string)) continue;
            if (this.reducedSignalOptions == null) {
                this.reducedSignalOptions = new HashSet<String>();
            }
            this.reducedSignalOptions.add(string);
        }
        for (String string : this.commandLineOptions) {
            if (string.startsWith("-Xdump")) {
                if (string.contains("none") && !string.contains(OPTION_WHICH_RESETS_DUMP_OPTIONS)) {
                    this.initialiseDisabledDumpTypeOptions();
                    this.dumpTypesDisabledOptions.add(string);
                }
                if (!string.contains("CEEDUMP") || string.contains("IEATDUMP")) continue;
                this.initialiseDisabledDumpTypeOptions();
                this.dumpTypesDisabledOptions.add(string);
                continue;
            }
            if (!"-Xdisablejavadump".equals(string)) continue;
            this.initialiseDisabledDumpTypeOptions();
            this.dumpTypesDisabledOptions.add(string);
        }
        for (String string : this.commandLineOptions) {
            if (!string.startsWith("-Xshareclasses") || !string.contains("noCoreMmap")) continue;
            this.noCoreMmapIsPresent = true;
        }
    }

    private void initialiseDisabledDumpTypeOptions() {
        if (this.dumpTypesDisabledOptions == null) {
            this.dumpTypesDisabledOptions = new HashSet<String>();
        }
    }

    public String getReport() {
        String string;
        String string2;
        Object object;
        this.populateProblematicOptions();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dumpOptionsReset) {
            object = Messages.getString("CommandLineDumpOptionChecker.dump.options.reset");
            stringBuffer.append(MessageFormat.format((String)object, OPTION_WHICH_RESETS_DUMP_OPTIONS));
        }
        if (this.reducedSignalOptions != null) {
            object = this.reducedSignalOptions.iterator();
            while (object.hasNext()) {
                string2 = object.next();
                string = Messages.getString("CommandLineDumpOptionChecker.dump.signals");
                stringBuffer.append(MessageFormat.format(string, string2));
            }
        }
        if (this.dumpTypesDisabledOptions != null) {
            object = this.dumpTypesDisabledOptions.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                string = Messages.getString("CommandLineDumpOptionChecker.dump.types.turned.off");
                stringBuffer.append(MessageFormat.format(string, string2));
            }
        }
        if (this.noCoreMmapIsPresent && ((String)(object = System.getProperty("os.name"))).contains("AIX")) {
            stringBuffer.append(Messages.getString("CommandLineDumpOptionChecker.noCoreMmap.warning"));
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(Messages.getString("CommandLineDumpOptionChecker.all.fine"));
        }
        return stringBuffer.toString();
    }
}

