/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.constants;

import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToGigabytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToKilobytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToMegabytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Messages;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.ActionUnitConverter;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.GCNumberConverter;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.GCReasonUnitConverter;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.GCScopeUnitConverter;
import java.util.logging.Logger;

public class GCAxes
extends AxisUtil
implements UnitLabels {
    public static final Logger TRACE = LogFactory.getTrace(GCAxes.class);
    public static final String OBJECTS_FREED = Messages.getString("VGCAxes.objects.freed");
    public static final String LIVE_OBJECTS_AFTER_GC = Messages.getString("VGCAxes.live.objects.after.gc");
    public static final String KB = Messages.getString("VGCAxes.kb");
    public static final String MB = Messages.getString("VGCAxes.mb");
    public static final String GB = Messages.getString("VGCAxes.gb");
    public static final String BYTES = Messages.getString("VGCAxes.bytes");
    public static final String DATA = Messages.getString("VGCAxes.data");
    public static final String HEAP = Messages.getString("VGCAxes.heap");
    public static final String NUMBER_OF_FLIPS = Messages.getString("VGCAxes.number.of.flips");
    public static final String AGE = Messages.getString("VGCAxes.age");
    public static final String OBJECTS = Messages.getString("VGCAxes.objects");
    public static final String NUMBER_FLIPPED = Messages.getString("VGCAxes.number.flipped");
    public static final String COLLECTION = Messages.getString("VGCAxes.collection");
    public static final String TIMESTAMP = Messages.getString("VGCAxes.timestamp");
    public static final String GC_NUMBER = Messages.getString("VGCAxes.gc.number");
    public static final String TOTAL_HEAP = Messages.getString("StrictJ950VGCParser.total.heap");
    public static final String TENURED_HEAP = Messages.getString("StrictJ950VGCParser.tenured.heap");
    public static final String NURSERY_HEAP = Messages.getString("StrictJ950VGCParser.nursery.heap");
    public static final String PERMANENT_HEAP = Messages.getString("VGCLabels.permanent.heap");
    public static final String DATE = Messages.getString("VGCAxes.date");
    public static final String DAYS = Messages.getString("VGCAxes.days");
    public static final String ACTION = Messages.getString("VGCAxes.action");
    public static final String ACTIONCODE = Messages.getString("VGCAxes.actioncode");
    public static final String REASONCODE = Messages.getString("VGCAxes.reasoncode");
    public static final String SCOPECODE = Messages.getString("VGCAxes.scopecode");
    public static final YAxis MB_AXIS = factory.createYAxis(DATA, MB);
    public static final YAxis BYTES_AXIS = factory.createYAxis(DATA, KB);
    public static final YAxis OBJECTS_MOVED_AXIS = factory.createYAxis(Messages.getString("VGCAxes.moved"), MB);
    public static final YAxis ACTION_AXIS = factory.createYAxis(ACTION, ActionUnitConverter.UNITS, 2);
    public static final YAxis HEAP_AXIS = factory.createYAxis(HEAP, MB);
    public static final YAxis AGE_AXIS = factory.createYAxis(AGE, NUMBER_OF_FLIPS);
    public static final YAxis TYPE_AXIS = factory.createYAxis(Messages.getString("VGCAxes.gc.type"), GCReasonUnitConverter.UNITS, 2);
    private static final YAxis SCOPE_AXIS = factory.createYAxis(Messages.getString("VGCAxes.gc.scope"), GCScopeUnitConverter.UNITS, 2);
    public static final YAxis RESTART_AXIS = factory.createYAxis(Messages.getString("VGCAxes.restart"), Messages.getString("VGCAxes.restart.units"), 1);

    public static XDataAxis prepareXAxis(GCNumberConverter gCNumberConverter, OutputProperties outputProperties) {
        XDataAxis xDataAxis = GCAxes.prepareXAxis(outputProperties);
        try {
            if (gCNumberConverter != null) {
                xDataAxis.addUnitConverter(gCNumberConverter);
            }
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return xDataAxis;
    }

    protected GCAxes() {
    }

    public static YDataAxis prepareBytesAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = BYTES_AXIS.createDataAxis(outputProperties, BYTES);
        try {
            yDataAxis.addUnitConverter(new BytesToKilobytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToMegabytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToGigabytesUnitConverter());
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return yDataAxis;
    }

    public static YDataAxis prepareHeapAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = HEAP_AXIS.createDataAxis(outputProperties, BYTES);
        try {
            yDataAxis.addUnitConverter(new BytesToKilobytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToMegabytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToGigabytesUnitConverter());
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return yDataAxis;
    }

    public static YDataAxis prepareObjectsMovedAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = BYTES_AXIS.createDataAxis(outputProperties, BYTES);
        try {
            yDataAxis.addUnitConverter(new BytesToKilobytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToMegabytesUnitConverter());
            yDataAxis.addUnitConverter(new BytesToGigabytesUnitConverter());
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            javaDiagnosticsException.printStackTrace();
        }
        return yDataAxis;
    }

    public static YDataAxis prepareGCScopeAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = SCOPE_AXIS.createDataAxis(outputProperties, SCOPECODE);
        try {
            GCScopeUnitConverter gCScopeUnitConverter = new GCScopeUnitConverter();
            yDataAxis.addUnitConverter(gCScopeUnitConverter);
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return yDataAxis;
    }

    public static YDataAxis prepareGCReasonsAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = TYPE_AXIS.createDataAxis(outputProperties, REASONCODE);
        try {
            GCReasonUnitConverter gCReasonUnitConverter = new GCReasonUnitConverter();
            yDataAxis.addUnitConverter(gCReasonUnitConverter);
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return yDataAxis;
    }

    public static YDataAxis prepareActionAxis(OutputProperties outputProperties) {
        YDataAxis yDataAxis = ACTION_AXIS.createDataAxis(outputProperties, ACTIONCODE);
        try {
            ActionUnitConverter actionUnitConverter = new ActionUnitConverter();
            yDataAxis.addUnitConverter(actionUnitConverter);
        }
        catch (JavaDiagnosticsException javaDiagnosticsException) {
            TRACE.warning(javaDiagnosticsException.toString());
        }
        return yDataAxis;
    }
}

