/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.converters;

import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCType;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Messages;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.EnumerationUnitConverter;

public class GCScopeUnitConverter
extends EnumerationUnitConverter {
    public static final String BASEUNITS = Messages.getString("VGCAxes.scopecode");
    public static final String LABEL = Messages.getString("VGCAxes.gc.scope");
    public static final String UNITS = Messages.getString("GCScopeUnitConverter.region");
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(BASEUNITS, LABEL, UNITS);
    private static final String NURSERY = Messages.getString("GCScopeUnitConverter.nursery");

    @Override
    public String unconvertedFormat(double d) {
        if (d == (double)GCType.NURSERY_INT) {
            return NURSERY;
        }
        return GCType.intToName((int)Math.round(d));
    }

    @Override
    public double parseUnconverted(String string) {
        return GCType.nameToInt(string);
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }
}

