/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.converters;

import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.NonLinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;

public abstract class TwoDimensionalDataConverter
extends AbstractUnitConverter
implements NonLinearUnitConverter {
    protected TwoDimensionalDataBuilder convertToData;
    protected double UNSET = -1.0;

    protected TwoDimensionalDataConverter(TwoDimensionalDataBuilder twoDimensionalDataBuilder) {
        this.convertToData = twoDimensionalDataBuilder;
    }

    @Override
    public double convert(double d, int n) {
        DataPointBuilder dataPointBuilder = this.convertToData.getDataPoint(n);
        if (dataPointBuilder != null) {
            return this.convertToData.getDataPoint(n).getRawY();
        }
        return this.getClosestMatch(n);
    }

    protected DataPointBuilder[] binaryChop(DataPointBuilder[] dataPointBuilderArray, int n) {
        DataPointBuilder[] dataPointBuilderArray2;
        block4: {
            int n2;
            block3: {
                n2 = dataPointBuilderArray.length;
                dataPointBuilderArray2 = new DataPointBuilder[n2 / 2];
                if (n2 <= 2) {
                    return dataPointBuilderArray;
                }
                if (dataPointBuilderArray[n2 / 2].getSequenceUID() <= n) break block3;
                for (int i = 0; i < n2 / 2; ++i) {
                    dataPointBuilderArray2[i] = dataPointBuilderArray[i + n2 / 2];
                }
                break block4;
            }
            if (dataPointBuilderArray[n2 / 2].getSequenceUID() >= n) break block4;
            for (int i = 0; i < n2 / 2; ++i) {
                dataPointBuilderArray2[i] = dataPointBuilderArray[i];
            }
        }
        return this.binaryChop(dataPointBuilderArray2, n);
    }

    private double getClosestMatch(int n) {
        DataPointBuilder[] dataPointBuilderArray = this.binaryChop(this.convertToData.getDataPoints(), n);
        if (dataPointBuilderArray.length != 2) {
            return this.UNSET;
        }
        return this.interpolateValue(n, dataPointBuilderArray[0].getSequenceUID(), dataPointBuilderArray[1].getSequenceUID());
    }

    protected double interpolateValue(int n, int n2, int n3) {
        double d;
        double d2 = this.convertToData.getDataPoint(n2).getRawY();
        if (d2 == (d = this.convertToData.getDataPoint(n3).getRawY())) {
            return d2;
        }
        if (n < n3 && n > n2) {
            double d3 = ((double)n - (double)n2) / ((double)n3 - (double)n2);
            double d4 = d3 * (d - d2) + d2;
            return d4;
        }
        if (n > n3) {
            double d5 = ((double)n - (double)n3) / ((double)n3 - (double)n2);
            double d6 = d5 * (d - d2) + d;
            return d6;
        }
        double d7 = 1.0 - (double)(n3 - n) / (double)(n3 - n2);
        double d8 = 1.0 - (double)(n - n2) / (double)(n3 - n2);
        double d9 = d2 * d8 + d * d7;
        return d9;
    }

    @Override
    public void setOffset(double d) {
    }

    public double getOffset() {
        return -1.0;
    }
}

