/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Messages;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.AllocationThresholdDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.OutOfLineAllocationDataPoint;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.ThreadState;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ObjectAllocationEventHandler;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ObjectAllocationInternalObject;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Logger;

public class GCModelUtil {
    private static final Logger TRACE = LogFactory.getTrace(GCModelUtil.class);
    private DataBuilder data;
    private final String comment;
    private int sequenceNumber = -1;
    private AxisPair timeAxes;
    private AxisPair nativeTimeAxes;
    private AxisPair heapAxes;
    private AxisPair numberAxes;
    private AxisPair bytesAxes;
    private AxisPair flippedAxes;
    private AxisPair ageAxes;
    private AxisPair scopeAxes;
    private AxisPair reasonAxes;
    private boolean isEnabled;
    private DataBuilder rootData;
    private static ObjectAllocationInternalObject cachedOAEvent = null;
    private static boolean oaStackDetected = false;
    private static final DataFactory factory = DataFactory.getFactory();

    public GCModelUtil(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData, DataBuilder dataBuilder2) {
        this.comment = null;
        assert (dataBuilder != null);
        this.data = dataBuilder;
        this.rootData = dataBuilder2;
        YDataAxis yDataAxis = GCAxes.prepareGCReasonsAxis(outputProperties);
        YDataAxis yDataAxis2 = GCAxes.prepareTimeAxis(outputProperties);
        YDataAxis yDataAxis3 = AxisUtil.prepareTimeAxis(outputProperties);
        YDataAxis yDataAxis4 = GCAxes.prepareHeapAxis(outputProperties);
        YDataAxis yDataAxis5 = GCAxes.prepareNumberAxis(outputProperties);
        XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
        YDataAxis yDataAxis6 = GCAxes.AGE_AXIS.createDataAxis(outputProperties, Messages.getString("VGCAxes.number.of.flips"));
        YDataAxis yDataAxis7 = GCAxes.prepareBytesAxis(outputProperties);
        this.numberAxes = factory.createAxisPair(xDataAxis, yDataAxis5);
        this.timeAxes = factory.createAxisPair(xDataAxis, yDataAxis2);
        this.nativeTimeAxes = factory.createAxisPair(xDataAxis, yDataAxis3);
        this.heapAxes = factory.createAxisPair(xDataAxis, yDataAxis4);
        this.bytesAxes = factory.createAxisPair(xDataAxis, yDataAxis7);
        this.reasonAxes = factory.createAxisPair(xDataAxis, yDataAxis);
        YDataAxis yDataAxis8 = GCAxes.prepareObjectsMovedAxis(outputProperties);
        this.flippedAxes = factory.createAxisPair(xDataAxis, yDataAxis8);
        this.ageAxes = factory.createAxisPair(xDataAxis, yDataAxis6);
        YDataAxis yDataAxis9 = GCAxes.prepareGCScopeAxis(outputProperties);
        this.scopeAxes = factory.createAxisPair(xDataAxis, yDataAxis9);
        this.isEnabled = dataBuilder.isEnabled();
    }

    public TwoDimensionalDataBuilder getTimeTwoDimensionalData(String string) {
        return this.getTwoDimensionalData(string, this.timeAxes);
    }

    public TwoDimensionalDataBuilder getNativeTimeTwoDimensionalData(String string) {
        return this.getTwoDimensionalData(string, this.nativeTimeAxes);
    }

    public TwoDimensionalDataBuilder getNumberTwoDimensionalData(String string) {
        return this.getTwoDimensionalData(string, this.numberAxes);
    }

    public TwoDimensionalDataBuilder getHeapTwoDimensionalData(String string) {
        return this.getTwoDimensionalData(string, this.heapAxes);
    }

    public TwoDimensionalDataBuilder getScopeTwoDimensionalData(String string) {
        return this.getTwoDimensionalData(string, this.scopeAxes);
    }

    public TwoDimensionalDataBuilder getTwoDimensionalData(String string, AxisPair axisPair) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)this.data.getData(string);
        if (twoDimensionalDataBuilder == null) {
            twoDimensionalDataBuilder = factory.createTwoDimensionalData(string, axisPair);
            twoDimensionalDataBuilder.setEnabled(this.isEnabled);
            this.data.addData(twoDimensionalDataBuilder);
        }
        return twoDimensionalDataBuilder;
    }

    public void addFlippedDataPoint(ThreadState threadState, String string, double d, double d2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.flippedAxes);
        DataPointBuilder dataPointBuilder = this.flippedAxes.createDataPointBuilder(threadState.sequenceUID, d, d2, this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addAgeDataPoint(ThreadState threadState, String string, double d, double d2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.ageAxes);
        DataPointBuilder dataPointBuilder = this.ageAxes.createDataPointBuilder(threadState.sequenceUID, d, d2, this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addAfterTenuredInformation(ThreadState threadState, double d, long l, long l2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        this.addHeapDataPoint(threadState, GCLabels.FREE_TENURED_HEAP_AFTER_GC, d, l);
        this.addHeapDataPoint(threadState, GCLabels.TENURED_SIZE, d, l2);
    }

    public void addNativeTimeDataPoint(ThreadState threadState, String string, double d, double d2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (d2 >= 0.0) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getNativeTimeTwoDimensionalData(string);
            DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getAxisPair().createDataPointBuilder(threadState.sequenceUID, d, d2, this.comment);
            twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
        } else {
            this.warnForNegativePause(string, d, d2);
        }
    }

    public void addTimeDataPoint(ThreadState threadState, String string, double d, double d2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (d2 >= 0.0) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTimeTwoDimensionalData(string);
            DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.getAxisPair().createDataPointBuilder(threadState.sequenceUID, d, d2, this.comment);
            twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
        } else {
            this.warnForNegativePause(string, d, d2);
        }
    }

    private void warnForNegativePause(String string, double d, double d2) {
        String string2 = Messages.getString("VGCModelUtil.adding.negative.time");
        String string3 = MessageFormat.format(string2, string, new Date((long)d), d2);
        TRACE.warning(string3);
    }

    public void addHeapDataPoint(ThreadState threadState, String string, double d, Long l, String string2) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getHeapTwoDimensionalData(string);
        DataPointBuilder dataPointBuilder = this.heapAxes.createDataPointBuilder(threadState.sequenceUID, d, l.longValue(), string2);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addHeapDataPoint(ThreadState threadState, String string, double d, Long l) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        this.addHeapDataPoint(threadState, string, d, l, this.comment);
    }

    public void addScopeDataPoint(ThreadState threadState, String string, double d, int n) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getScopeTwoDimensionalData(string);
        DataPointBuilder dataPointBuilder = this.scopeAxes.createDataPointBuilder(threadState.sequenceUID, d, n, this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addNumberDataPoint(ThreadState threadState, String string, double d, Long l) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.numberAxes);
        DataPointBuilder dataPointBuilder = this.numberAxes.createDataPointBuilder(threadState.sequenceUID, d, l.longValue(), this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addByteDataPoint(ThreadState threadState, String string, double d, Long l) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.bytesAxes);
        DataPointBuilder dataPointBuilder = this.bytesAxes.createDataPointBuilder(threadState.sequenceUID, d, l.longValue(), this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void addAllocationThresholdSettings(ThreadState threadState, Long l, Long l2, boolean bl) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (!bl && this.data.getData("low_allocation_threshold") != null) {
            return;
        }
        StringDataImpl stringDataImpl = new StringDataImpl("low_allocation_threshold", l.toString());
        this.data.removeData("low_allocation_threshold");
        this.data.addData(stringDataImpl);
        StringDataImpl stringDataImpl2 = new StringDataImpl("high_allocation_threshold", l2.toString());
        this.data.removeData("high_allocation_threshold");
        this.data.addData(stringDataImpl2);
    }

    public AllocationThresholdDataPointImpl addLargeAllocationDataPoint(ThreadState threadState, String string, double d, Long l, Long l2, Long l3) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.bytesAxes);
        AllocationThresholdDataPointImpl allocationThresholdDataPointImpl = new AllocationThresholdDataPointImpl(threadState.sequenceUID, d, l.longValue(), this.bytesAxes, l2.longValue(), l3.longValue(), this.rootData);
        ObjectAllocationEventHandler.setCachedObject(new ObjectAllocationInternalObject(null, (long)allocationThresholdDataPointImpl.getRawX(), allocationThresholdDataPointImpl.getFullStack(), (long)allocationThresholdDataPointImpl.getRawY(), allocationThresholdDataPointImpl.getStackTop()));
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return null;
        }
        twoDimensionalDataBuilder.addDataPointBuilder(allocationThresholdDataPointImpl);
        return allocationThresholdDataPointImpl;
    }

    public OutOfLineAllocationDataPoint addOutOfLineAllocationDataPoint(ThreadState threadState, double d, Long l, Long l2, String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(GCLabels.OUT_OF_LINE_OBJECT_ALLOCATION, this.bytesAxes);
        OutOfLineAllocationDataPoint outOfLineAllocationDataPoint = new OutOfLineAllocationDataPoint(threadState.sequenceUID, d, l.longValue(), this.bytesAxes, l2, string, this.rootData);
        ObjectAllocationEventHandler.setCachedObject(new ObjectAllocationInternalObject(outOfLineAllocationDataPoint.getClassName(), (long)outOfLineAllocationDataPoint.getRawX(), outOfLineAllocationDataPoint.getFullStack(), (long)outOfLineAllocationDataPoint.getRawY(), outOfLineAllocationDataPoint.getStackTop()));
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return null;
        }
        twoDimensionalDataBuilder.addDataPointBuilder(outOfLineAllocationDataPoint);
        Data data = twoDimensionalDataBuilder.getTopLevelData(string);
        if (data == null) {
            data = factory.createTwoDimensionalData(string, this.bytesAxes);
            twoDimensionalDataBuilder.addData((DataBuilder)data);
        }
        ((TwoDimensionalDataBuilder)data).addDataPointBuilder(outOfLineAllocationDataPoint);
        return outOfLineAllocationDataPoint;
    }

    public void addReasonDataPoint(ThreadState threadState, String string, double d, int n) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(string, this.reasonAxes);
        DataPointBuilder dataPointBuilder = this.reasonAxes.createDataPointBuilder(threadState.sequenceUID, d, n, this.comment);
        twoDimensionalDataBuilder.addDataPointBuilder(dataPointBuilder);
    }

    public void incrementSequenceNumber(ThreadState threadState) {
        ++this.sequenceNumber;
        threadState.sequenceUID = this.sequenceNumber;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }
}

