/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.PostProcessorThread;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Slicer;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParsingJob
extends MarshallerJob {
    private static final String RUN_METHOD = "run";
    public static final Logger TRACE = LogFactory.getTrace(ParsingJob.class);
    private static final String PARSING = Messages.getString("ParsingJob.parsing");
    private static final String TO_STRING_TEMPLATE = Messages.getString("ParsingJob.to.string.template");
    private Slicer slicer;
    private PostProcessorThread ppt;

    public ParsingJob(Slicer slicer, RootDataImpl rootDataImpl, OutputProperties outputProperties, PostProcessorThread postProcessorThread) {
        super(PARSING, rootDataImpl, outputProperties);
        this.slicer = slicer;
        this.ppt = postProcessorThread;
    }

    @Override
    public long run() {
        ProgressIndicator progressIndicator;
        TRACE.entering(this.getClass().getName(), RUN_METHOD);
        long l = 0L;
        this.data.switchToParsing();
        if (TRACE.isLoggable(Level.FINE)) {
            TRACE.fine("About to parse with slicer " + this.slicer);
        }
        if ((progressIndicator = this.slicer.triggerParse(this.data.getParsedData(), this.properties)) != null) {
            l = progressIndicator.getProgressInBytes();
            if (progressIndicator.getProgress() > 0) {
                this.ppt.requestPostProcessing();
            }
        }
        TRACE.exiting(this.getClass().getName(), RUN_METHOD);
        return l;
    }

    public String toString() {
        return MessageFormat.format(TO_STRING_TEMPLATE, this.slicer);
    }
}

