/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.HealthCenterThread;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.PostProcessingJob;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.util.logging.Logger;

public class PostProcessorThread
extends HealthCenterThread {
    private static final String QUEUE_POSTPROCESSORS_METHOD = "queuePostProcessors";
    private static final int TIMING_INTERVAL = 10000;
    private static final Logger TRACE = LogFactory.getTrace(PostProcessorThread.class);
    private final String className = this.getClass().getName();
    private final RootDataImpl data;
    private OutputProperties outputProperties;
    private volatile boolean hasChanged = true;

    public PostProcessorThread(Marshaller marshaller, RootDataImpl rootDataImpl, OutputProperties outputProperties) {
        super(Messages.getString("PostProcessorThread.thread.name"), marshaller);
        this.data = rootDataImpl;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueWork() {
        TRACE.entering(this.className, QUEUE_POSTPROCESSORS_METHOD);
        if (this.hasChanged) {
            PostProcessingJob postProcessingJob = new PostProcessingJob(this.data, this.outputProperties, this.marshaller);
            Object object = this.marshaller.getQueueLock();
            synchronized (object) {
                this.marshaller.addJobToQueue(postProcessingJob);
            }
            this.hasChanged = false;
        }
        TRACE.exiting(this.className, QUEUE_POSTPROCESSORS_METHOD);
    }

    public void requestPostProcessing() {
        this.hasChanged = true;
    }

    public void triggerPostProcess() {
        this.queueWork();
    }

    @Override
    protected int getDefaultTimingInterval() {
        return 10000;
    }

    @Override
    public void terminate() {
        super.terminate();
        this.outputProperties = null;
    }
}

