/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.slicer;

import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LineLimitReader
extends FilterReader {
    long countWithNoBreak;
    final int limit;

    public LineLimitReader(Reader reader, int n) {
        super(reader);
        this.limit = n;
    }

    public LineLimitReader(Reader reader) {
        this(reader, 500000);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 > 0) {
            for (int i = n; i < n + n3; ++i) {
                this.checkChar(cArray[i]);
            }
        }
        return n3;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    private void checkChar(int n) throws IOException {
        this.countWithNoBreak = n == 10 || n == 13 ? 0L : ++this.countWithNoBreak;
        if (this.countWithNoBreak > (long)this.limit) {
            throw new IOException(Messages.getString("LineLimitReader.Line.too.long"));
        }
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        this.checkChar(n);
        return n;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.countWithNoBreak = 0L;
    }
}

