/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.AbstractClockCyclesConverter;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class ClockCyclesToTimeConverter
extends AbstractClockCyclesConverter {
    private static final long MS_PER_DAY = 86400000L;
    private final DateFormat hhmmssFormat = new SimpleDateFormat("HH:mm:ss");
    private long mostRecentDate = 0L;
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.CLOCKCYCLES, UnitLabels.CLOCK_TIME, UnitLabels.TIME);
    private static final Logger TRACE = LogFactory.getTrace(ClockCyclesToTimeConverter.class);

    public ClockCyclesToTimeConverter(TraceMetaData traceMetaData) {
        super(traceMetaData, false, false);
    }

    @Override
    protected double getConversionConstant() {
        return 1.0;
    }

    @Override
    public String unconvertedFormat(double d) {
        this.refreshMostRecentDate(d);
        long l = Math.round(d);
        return this.hhmmssFormat.format(new Date(l));
    }

    private void refreshMostRecentDate(double d) {
        this.mostRecentDate = (long)Math.floor(d / 8.64E7) * 86400000L;
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return this.unconvertedFormat(d);
    }

    @Override
    public double parseUnconverted(String string) {
        try {
            double d = this.hhmmssFormat.parse(string).getTime();
            double d2 = d + (double)this.mostRecentDate;
            return d2;
        }
        catch (ParseException parseException) {
            TRACE.warning(parseException.toString());
            return this.mostRecentDate;
        }
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    public boolean shouldFormatWithUnits() {
        return false;
    }
}

