/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TraceExporter {
    private static final int EYE_CATCHER_LENGTH = 4;

    public static void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean bl = false;
        do {
            byte[] byArray;
            int n;
            bl = (n = TraceExporter.readFully(inputStream, byArray = new byte[4])) < 0;
            ChunkType chunkType = null;
            for (ChunkType chunkType2 : ChunkType.ALL_VALID_CHUNK_TYPES) {
                if (!Arrays.equals(byArray, chunkType2.getEyeCatcher())) continue;
                chunkType = chunkType2;
                break;
            }
            byte[] objectArray = new byte[8];
            if (!bl) {
                n = TraceExporter.readFully(inputStream, objectArray);
                boolean bl2 = bl = n < 0;
            }
            if (bl) break;
            ByteBuffer byteBuffer = ByteBuffer.wrap(objectArray);
            long l = byteBuffer.getLong();
            byte[] byArray2 = new byte[(int)l];
            if (bl) continue;
            n = TraceExporter.readFully(inputStream, byArray2);
            boolean bl3 = bl = n < 0;
            if (chunkType != ChunkType.TRACE_BUFFER && chunkType != ChunkType.TRACE_METADATA) continue;
            outputStream.write(byArray2);
        } while (!bl);
    }

    private static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray);
        while (n >= 0 && n < byArray.length) {
            int n2 = inputStream.read(byArray, n, byArray.length - n);
            if (n2 > 0) {
                n += n2;
                continue;
            }
            if (n2 >= 0) continue;
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            TraceExporter.convert(fileInputStream, fileOutputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage EyeCatcherStripper inputFile outputFile");
            return;
        }
        TraceExporter traceExporter = new TraceExporter();
        try {
            traceExporter.convert(stringArray[0], stringArray[1]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final class ChunkType
    extends Enum<ChunkType> {
        public static final /* enum */ ChunkType TRACE_BUFFER = new ChunkType("HCTB");
        public static final /* enum */ ChunkType TRACE_METADATA = new ChunkType("HCTH");
        public static final /* enum */ ChunkType DROPPED_BUFFERS = new ChunkType("HCDB");
        static final ChunkType[] ALL_VALID_CHUNK_TYPES;
        private final byte[] eyeCatcher;
        private static final /* synthetic */ ChunkType[] $VALUES;

        public static ChunkType[] values() {
            return (ChunkType[])$VALUES.clone();
        }

        public static ChunkType valueOf(String string) {
            return Enum.valueOf(ChunkType.class, string);
        }

        private ChunkType(String string2) {
            assert (string2.length() == 4);
            char[] cArray = string2.toCharArray();
            this.eyeCatcher = new byte[4];
            for (int i = 0; i < 4; ++i) {
                this.eyeCatcher[i] = (byte)cArray[i];
            }
        }

        public byte[] getEyeCatcher() {
            return this.eyeCatcher;
        }

        static {
            $VALUES = new ChunkType[]{TRACE_BUFFER, TRACE_METADATA, DROPPED_BUFFERS};
            ALL_VALID_CHUNK_TYPES = ChunkType.values();
        }
    }
}

