/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace.impl;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TraceMetaDataImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TracePointImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TracedThreadImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.UnneededEntryAndExitTraceLister;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.trace.TracePointHandlerList;
import com.ibm.jvm.trace.format.api.MissingDataException;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceParser
implements ByteParser {
    private static final int PARSED_TRACE_BYTES_REPORT_HEARTBEAT_INTERVAL_SECS = 10;
    private static final String INVALID_TRACE_HEADER = Messages.getString("TraceParser.invalid.header");
    private static final String INVALID_TRACE_BUFFER = Messages.getString("TraceParser.invalid.buffer");
    private static final String METHODNAME = "getTracePointHandlers";
    protected static final String J9TRACE_FORMAT_DAT = "/deps/J9TraceFormat.dat";
    protected static final String OMRTRACE_FORMAT_DAT = "/deps/OMRTraceFormat.dat";
    protected static final String TRACE_FORMAT_DAT = "/deps/TraceFormat.dat";
    protected static final String J9TRACE_FORMAT_DAT_REALTIME = "/deps/J9TraceFormatRT.dat";
    private static final Logger TRACE = LogFactory.getTrace(TraceParser.class);
    private final String CLASSNAME = TraceParser.class.getName();
    private final int BIG_ENDIAN_SIG = 305419896;
    private final int LITTLE_ENDIAN_SIG = 2018915346;
    protected TracePointHandler[] handlers = this.getTracePointHandlers();
    protected TraceMetaData metaData = null;
    protected TraceContext traceContext = null;
    protected boolean suppressTraceFormatMessages = true;
    private int traceFileBufferSize = 0;
    private Map<TraceThread, TracedThreadImpl> traceThreadMap = new HashMap<TraceThread, TracedThreadImpl>();
    private AxisPair traceBytesDataAxisPair;
    private TwoDimensionalDataBuilder parsedTraceBytesData;
    private TwoDimensionalDataBuilder missingTraceBytesData;
    protected int unreportedMissingTraceBytes = 0;
    protected int unreportedParsedTraceBytes = 0;
    private double lastReportedParsedTraceBytesTimeSecs = Double.NaN;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, byte[] byArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        int n = 0;
        int n2 = 0;
        if (this.traceContext == null) {
            object = this.getTraceFileHeader(byArray);
            if (object == null) {
                return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
            }
            n2 = ((byte[])object).length;
            try {
                this.traceContext = this.suppressTraceFormatMessages ? TraceContext.getContext(object, ((byte[])object).length, TraceParser.class.getResourceAsStream(J9TRACE_FORMAT_DAT), null, null, null, null) : TraceContext.getContext(object, ((byte[])object).length, TraceParser.class.getResourceAsStream(J9TRACE_FORMAT_DAT));
                this.traceContext.addMessageData(TraceParser.class.getResourceAsStream(OMRTRACE_FORMAT_DAT));
                this.traceContext.addMessageData(TraceParser.class.getResourceAsStream(TRACE_FORMAT_DAT));
                TracePointHandler[] tracePointHandlerArray = new VMLevelChecker(this.traceContext.getVmVersionString());
                if (tracePointHandlerArray.isVMRealtime()) {
                    this.traceContext.addMessageData(TraceParser.class.getResourceAsStream(J9TRACE_FORMAT_DAT_REALTIME));
                }
                if (dynamicSource instanceof ConfigurableSource) {
                    Collection<String> collection = UnneededEntryAndExitTraceLister.getList();
                    ((ConfigurableSource)dynamicSource).disable(collection);
                }
            }
            catch (IOException iOException) {
                TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", INVALID_TRACE_BUFFER, iOException);
                return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
            }
            this.metaData = new TraceMetaDataImpl(this.traceContext);
            TraceAxisUtil.clearConverter();
            for (TracePointHandler tracePointHandler : this.handlers) {
                tracePointHandler.handleTraceStart(dynamicSource, this.metaData, dataBuilder, outputProperties);
            }
        }
        if (this.traceContext != null) {
            int n3;
            object = new HashSet();
            n = n3 = this.traceFileBufferSize;
            int n4 = byArray.length - n2;
            while (n2 < byArray.length && n3 <= n4) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                boolean bl = true;
                int n5 = 0;
                for (byte by : byArray2) {
                    if (by <= 0 || ++n5 <= 100) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.unreportedMissingTraceBytes += n3;
                    n2 += n3;
                    continue;
                }
                try {
                    TraceThread exception = this.traceContext.addData(byArray2);
                    object.add(exception);
                    n4 = byArray.length - (n2 += n3);
                    this.notifyTracePointHandlers(dynamicSource, (Set<TraceThread>)object, dataBuilder, outputProperties);
                    this.unreportedParsedTraceBytes += n3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", INVALID_TRACE_BUFFER, illegalArgumentException);
                    return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
                }
                catch (Exception exception) {
                    TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", INVALID_TRACE_HEADER, exception);
                    return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
                }
            }
        }
        return new ProgressIndicatorImpl(n2, n);
    }

    protected void notifyTracePointHandlers(DynamicSource dynamicSource, Set<TraceThread> set, DataBuilder dataBuilder, OutputProperties outputProperties) {
        for (TraceThread traceThread : set) {
            TracedThreadImpl tracedThreadImpl = this.getTracedThread(traceThread);
            Iterator iterator = traceThread.getIterator();
            while (iterator.hasNext()) {
                try {
                    TracePoint tracePoint = (TracePoint)iterator.next();
                    TracePointImpl tracePointImpl = new TracePointImpl(tracedThreadImpl, tracePoint);
                    if (this.unreportedParsedTraceBytes > 0 && !iterator.hasNext()) {
                        double d = TraceAxisUtil.getTimestampMS(tracePointImpl, this.metaData);
                        if (Double.compare(this.lastReportedParsedTraceBytesTimeSecs, Double.NaN) == 0 || this.convertRawTimeToSeconds(outputProperties, d) - this.lastReportedParsedTraceBytesTimeSecs > 10.0) {
                            this.recordParsedTraceBytes(d, dataBuilder, outputProperties);
                        }
                    }
                    this.handleMissingTraceData(dynamicSource, dataBuilder, outputProperties, tracedThreadImpl, tracePoint);
                    for (TracePointHandler tracePointHandler : this.handlers) {
                        try {
                            tracePointHandler.handleTracePoint(dynamicSource, this.metaData, tracePointImpl, dataBuilder, outputProperties);
                        }
                        catch (Exception exception) {
                            TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", MessageFormat.format(Messages.getString("TraceParser.tracePointHandler.exception"), tracePointHandler), exception);
                        }
                    }
                    if (!this.isThreadEnd(tracePoint)) continue;
                    this.removeTracedThread(traceThread);
                }
                catch (MissingDataException missingDataException) {
                    long l = missingDataException.getMissingBytes();
                    tracedThreadImpl.setMissingDataBytes(l += tracedThreadImpl.getMissingDataBytes());
                }
            }
        }
    }

    private double convertRawTimeToSeconds(OutputProperties outputProperties, double d) {
        AxisPair axisPair = this.getTraceBytesDataAxisPair(outputProperties, this.metaData);
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, this.unreportedParsedTraceBytes, axisPair);
        double d2 = dataPointImpl.getX(UnitLabels.SECONDS);
        return d2;
    }

    private boolean isThreadEnd(TracePoint tracePoint) {
        if (tracePoint == null) {
            return false;
        }
        String string = tracePoint.getComponent();
        return string != null && string.equals("dg") && tracePoint.getID() == 262;
    }

    private TracedThreadImpl getTracedThread(TraceThread traceThread) {
        TracedThreadImpl tracedThreadImpl = this.traceThreadMap.get(traceThread);
        if (tracedThreadImpl == null) {
            tracedThreadImpl = new TracedThreadImpl(traceThread);
            this.traceThreadMap.put(traceThread, tracedThreadImpl);
        }
        return tracedThreadImpl;
    }

    private TwoDimensionalDataBuilder getParsedTraceBytesData(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        if (this.parsedTraceBytesData == null) {
            this.parsedTraceBytesData = this.createTraceBytesData(dataBuilder, TraceLabels.PARSED_TRACE_DATA, outputProperties, traceMetaData);
            dataBuilder.addData(this.parsedTraceBytesData);
        }
        return this.parsedTraceBytesData;
    }

    private TwoDimensionalDataBuilder getMissingTraceBytesData(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        if (this.missingTraceBytesData == null) {
            this.missingTraceBytesData = this.createTraceBytesData(dataBuilder, TraceLabels.MISSING_TRACE_DATA, outputProperties, traceMetaData);
            dataBuilder.addData(this.missingTraceBytesData);
        }
        return this.missingTraceBytesData;
    }

    private AxisPair getTraceBytesDataAxisPair(OutputProperties outputProperties, TraceMetaData traceMetaData) {
        if (this.traceBytesDataAxisPair == null) {
            this.traceBytesDataAxisPair = this.createTraceBytesDataAxisPair(outputProperties, traceMetaData);
        }
        return this.traceBytesDataAxisPair;
    }

    private AxisPair createTraceBytesDataAxisPair(OutputProperties outputProperties, TraceMetaData traceMetaData) {
        DataFactory dataFactory = DataFactory.getFactory();
        XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
        YDataAxis yDataAxis = AxisUtil.prepareAmountAxis(outputProperties);
        return dataFactory.createAxisPair(xDataAxis, yDataAxis);
    }

    private TwoDimensionalDataBuilder createTraceBytesData(DataBuilder dataBuilder, String string, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        DataFactory dataFactory = DataFactory.getFactory();
        AxisPair axisPair = this.getTraceBytesDataAxisPair(outputProperties, traceMetaData);
        return dataFactory.createTwoDimensionalData(string, axisPair);
    }

    private void removeTracedThread(TraceThread traceThread) {
        this.traceThreadMap.remove(traceThread);
    }

    protected byte[] getTraceFileHeader(byte[] byArray) {
        Object object;
        int n = 0;
        try {
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).getInt();
            n = ((ByteBuffer)object).getInt();
            ((ByteBuffer)object).getInt();
            ((ByteBuffer)object).getInt();
            this.traceFileBufferSize = ((ByteBuffer)object).getInt();
            int n2 = ((ByteBuffer)object).getInt();
            switch (n2) {
                case 305419896: {
                    ((ByteBuffer)object).order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 2018915346: {
                    ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
                    n = TraceParser.convertEndian(n);
                    this.traceFileBufferSize = TraceParser.convertEndian(this.traceFileBufferSize);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            TRACE.logp(Level.FINE, this.CLASSNAME, "parse", INVALID_TRACE_HEADER, bufferUnderflowException);
            return null;
        }
        object = null;
        if (n > 0) {
            object = new byte[n];
            for (int i = 0; i < n; ++i) {
                object[i] = byArray[i];
            }
        }
        return object;
    }

    protected static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    private TracePointHandler[] getTracePointHandlers() {
        TRACE.entering(this.CLASSNAME, METHODNAME);
        ArrayList<TracePointHandler> arrayList = new ArrayList<TracePointHandler>();
        String[] stringArray = TracePointHandlerList.getTracePointHandlers();
        boolean bl = false;
        if (System.getProperty("com.ibm.java.diagnostics.healthcenter.jit.gui.disabled") != null) {
            bl = true;
        }
        for (String string : stringArray) {
            if (string.equals("com.ibm.java.diagnostics.healthcenter.jit.JITTracePointHandler") && bl) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                arrayList.add((TracePointHandler)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", INVALID_TRACE_BUFFER, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", INVALID_TRACE_BUFFER, instantiationException);
            }
        }
        Object[] objectArray = arrayList.toArray(new TracePointHandler[arrayList.size()]);
        return objectArray;
    }

    private void handleMissingTraceData(DynamicSource dynamicSource, DataBuilder dataBuilder, OutputProperties outputProperties, TracedThreadImpl tracedThreadImpl, TracePoint tracePoint) {
        TracePointImpl tracePointImpl = new TracePointImpl(tracedThreadImpl, tracePoint);
        double d = TraceAxisUtil.getTimestampMS(tracePointImpl, this.metaData);
        if (this.unreportedMissingTraceBytes > 0) {
            this.handleMissingTraceData(null, d, this.unreportedMissingTraceBytes, dynamicSource, dataBuilder, outputProperties);
            this.unreportedMissingTraceBytes = 0;
        }
        if (tracedThreadImpl.getMissingDataBytes() > 0L) {
            int n = (int)tracedThreadImpl.getMissingDataBytes();
            this.handleMissingTraceData(tracedThreadImpl, d, n, dynamicSource, dataBuilder, outputProperties);
            tracedThreadImpl.setMissingDataBytes(0L);
        }
    }

    protected void handleMissingTraceData(TracedThread tracedThread, double d, int n, DynamicSource dynamicSource, DataBuilder dataBuilder, OutputProperties outputProperties) {
        if (this.unreportedParsedTraceBytes > 0) {
            this.recordParsedTraceBytes(d, dataBuilder, outputProperties);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getMissingTraceBytesData(dataBuilder, outputProperties, this.metaData);
        twoDimensionalDataBuilder.getAxisPair().getXAxis().setX(d);
        twoDimensionalDataBuilder.addDataPointBuilder(n);
        for (TracePointHandler tracePointHandler : this.handlers) {
            try {
                tracePointHandler.handleMissingData(dynamicSource, this.metaData, tracedThread, d, n, dataBuilder, outputProperties);
            }
            catch (Exception exception) {
                TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", MessageFormat.format(Messages.getString("TraceParser.tracePointHandler.exception"), tracePointHandler), exception);
            }
        }
    }

    private void recordParsedTraceBytes(double d, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getParsedTraceBytesData(dataBuilder, outputProperties, this.metaData);
        twoDimensionalDataBuilder.getAxisPair().getXAxis().setX(d);
        DataPointBuilder dataPointBuilder = twoDimensionalDataBuilder.addDataPointBuilder(this.unreportedParsedTraceBytes);
        this.lastReportedParsedTraceBytesTimeSecs = dataPointBuilder.getX(UnitLabels.SECONDS);
        this.unreportedParsedTraceBytes = 0;
    }
}

