/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.impl.data.MethodNode;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ForwardMethodNode;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.Messages;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.MethodTwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ReverseMethodNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MethodTree
extends DataImpl {
    private MethodNode syntheticReverseRoot;
    private final Map<String, Collection<MethodNode>> methodNodesIndex;
    private DataBuilder profileGenerators;
    private DataBuilder cumulativeCounts;
    private AxisPair axisPair;
    private Object nodesLock = new Object();
    private static final Logger TRACE = LogFactory.getTrace(MethodTree.class);

    public MethodTree(OutputProperties outputProperties, TraceMetaData traceMetaData) {
        super(ProfilingLabels.PROFILE_DATA);
        this.syntheticReverseRoot = ReverseMethodNode.createRootNode();
        this.methodNodesIndex = new HashMap<String, Collection<MethodNode>>();
        this.profileGenerators = new StringDataImpl(ProfilingLabels.METHOD_COUNTS);
        this.addData(this.profileGenerators);
        this.cumulativeCounts = new StringDataImpl(ProfilingLabels.CUMULATIVE_METHOD_COUNTS);
        this.addData(this.cumulativeCounts);
        DataFactory dataFactory = DataFactory.getFactory();
        XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
        YDataAxis yDataAxis = dataFactory.createYAxis(Messages.getString("MethodTree.count"), UnitLabels.NUMBER_SIGN, 1).createDataAxis(outputProperties, UnitLabels.NUMBER_SIGN);
        this.axisPair = dataFactory.createAxisPair(xDataAxis, yDataAxis);
    }

    private MethodNode addMethod(Method method, MethodNode methodNode) {
        MethodNode methodNode2 = null;
        if (methodNode != null) {
            methodNode2 = methodNode.findChild(method);
            if (methodNode2 != null) {
                methodNode2.incrementRefCount();
            } else {
                methodNode2 = methodNode.createChild(method);
                methodNode.addChild(methodNode2);
                if (methodNode2 != null) {
                    this.addToMethodNodeSets(methodNode2);
                }
            }
        }
        return methodNode2;
    }

    public void addCallStack(List<Method> list, double d) {
        int n = list.size();
        if (n == 0) {
            return;
        }
        HashSet<Method> hashSet = new HashSet<Method>();
        MethodNode methodNode = this.syntheticReverseRoot;
        Method method = null;
        for (int i = n - 1; i >= 0; --i) {
            method = list.get(i);
            methodNode = this.addMethod(method, methodNode);
            if (methodNode == null || !hashSet.add(method)) continue;
            this.addRow(method, methodNode.getCount(), d, this.cumulativeCounts);
        }
        Method method2 = method;
        MethodNode methodNode2 = methodNode;
        this.addRow(method2, methodNode2.getCount(), d, this.profileGenerators);
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMethodNodeSets(MethodNode methodNode) {
        Object object = this.nodesLock;
        synchronized (object) {
            Method method = methodNode.getMethod();
            String string = method.getUniqueId();
            Collection<MethodNode> collection = this.getMethodNodes(string);
            if (collection == null) {
                collection = new ArrayList<MethodNode>();
            }
            collection.add(methodNode);
            this.methodNodesIndex.put(string, collection);
        }
    }

    public void addRow(Method method, int n, double d, DataBuilder dataBuilder) {
        MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl = (MethodTwoDimensionalDataImpl)dataBuilder.getTopLevelData(method.getUniqueId());
        if (methodTwoDimensionalDataImpl == null) {
            methodTwoDimensionalDataImpl = new MethodTwoDimensionalDataImpl(method, this.axisPair);
            dataBuilder.addData(methodTwoDimensionalDataImpl);
        }
        this.axisPair.getXAxis().setX(d);
        DataPointBuilder dataPointBuilder = this.axisPair.createEventDataPoint();
        methodTwoDimensionalDataImpl.addDataPointBuilder(dataPointBuilder);
    }

    private Collection<MethodNode> getMethodNodes(String string) {
        return this.methodNodesIndex.get(string);
    }

    private MethodNode addClonedChildMethodNode(MethodNode methodNode, MethodNode methodNode2, int n) {
        Method method = methodNode.getMethod();
        MethodNode methodNode3 = methodNode2.findChild(method);
        if (methodNode3 == null) {
            methodNode3 = methodNode2.createChild(method, n);
            methodNode2.addChild(methodNode3);
        } else {
            methodNode3.incrementRefCount(methodNode.getCount());
        }
        return methodNode3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodNode getMethodsThatCall(String string) {
        Object object = this.nodesLock;
        synchronized (object) {
            Collection<MethodNode> collection = this.getMethodNodes(string);
            if (collection == null) {
                return null;
            }
            MethodNode methodNode = ForwardMethodNode.createRootNode();
            for (MethodNode methodNode2 : collection) {
                MethodNode methodNode3 = methodNode;
                for (MethodNode methodNode4 = methodNode2; methodNode4 != this.syntheticReverseRoot; methodNode4 = methodNode4.getParent()) {
                    MethodNode methodNode5;
                    methodNode3 = methodNode5 = this.addClonedChildMethodNode(methodNode4, methodNode3, methodNode2.getCount());
                }
            }
            return methodNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodNode getMethodsCalledBy(String string) {
        Collection<MethodNode> collection = this.getMethodNodes(string);
        if (collection == null) {
            return null;
        }
        MethodNode methodNode = ReverseMethodNode.createRootNode();
        Object object = this.nodesLock;
        synchronized (object) {
            for (MethodNode methodNode2 : collection) {
                MethodNode methodNode3 = this.addClonedChildMethodNode(methodNode2, methodNode, methodNode2.getCount());
                this.cloneAndMergeChildren(methodNode2, methodNode3);
            }
        }
        return methodNode;
    }

    private void cloneAndMergeChildren(MethodNode methodNode, MethodNode methodNode2) {
        if (methodNode == null) {
            return;
        }
        DataBuilder[] dataBuilderArray = methodNode.getChildren();
        if (dataBuilderArray.length > 0) {
            for (DataBuilder dataBuilder : dataBuilderArray) {
                if (!(dataBuilder instanceof MethodNode)) continue;
                MethodNode methodNode3 = (MethodNode)dataBuilder;
                MethodNode methodNode4 = this.addClonedChildMethodNode(methodNode3, methodNode2, methodNode3.getCount());
                this.cloneAndMergeChildren(methodNode3, methodNode4);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public MethodNode getReverseRoot() {
        return this.syntheticReverseRoot;
    }
}

