/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.postprocessor.nodejs;

import com.ibm.java.diagnostics.common.datamodel.data.ControlledData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.JavaMethod;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.jit.JITCompileDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetricsUtil;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.MethodDictionaryDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.MethodTwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingTableDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingTableDataRowImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingTableRow;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.SampleCounter;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.postprocessor.nodejs.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class PercentProfilingDataPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final String L_BRACKET = "(";
    private static final String DOT = ".";
    private static final String F_SLASH = "/";
    private static final String EQUALS = "=";
    private static final int DATE_METHOD_DICTIONARY_AVAILABLE = 20090330;
    private static final int MINIMUM_SAMPLES_FOR_RECOMMENDATION = 200;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int LARGE_PERCENT_THRESHOLD = 15;
    private static final Logger TRACE = LogFactory.getTrace(PercentProfilingDataPostProcessor.class);
    private static final String CLASS_NAME = PercentProfilingDataPostProcessor.class.getName();
    private static final String POSSIBLE_MISSING_METHODS = Messages.getString("Profiling.droppedData.short");
    private static final double DEFAULT_MINOR_THRESHOLD = 0.1;
    private static final double DEFAULT_MODERATE_THRESHOLD = 0.3;
    private static final double DEFAULT_MAJOR_THRESHOLD = 0.6;
    private boolean lowOverheadMode = false;
    private EnvironmentData environmentData;
    private SampleCounter totalSamplesObject = new SampleCounter();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.PROFILING);
        if (subsystemDataBuilder != null) {
            Data data2;
            Collection<ControlledData> collection = subsystemDataBuilder.getControllableData();
            for (Data data2 : collection) {
                if (!"j9jit.16".equals(data2.getID())) continue;
                this.lowOverheadMode = data2.isEnabled();
            }
            DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.ENVIRONMENT);
            if (dataBuilder2 instanceof EnvironmentData) {
                this.environmentData = (EnvironmentData)((Object)dataBuilder2);
            }
            data2 = (MethodDictionaryDataImpl)dataBuilder.getData(ProfilingLabels.METHOD_DICTIONARY);
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(ProfilingLabels.PROFILE_INTERPRETATION);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(ProfilingLabels.PROFILE_INTERPRETATION);
            subsystemDataBuilder.addData(structuredStringDataImpl);
            this.analyseProfilingData(subsystemDataBuilder, (MethodDictionaryDataImpl)data2, dataBuilder);
            double d = TraceMetricsUtil.getMissingDataRatio(dataBuilder);
            if (d > 0.1) {
                if (structuredStringDataImpl.getStatus() == Status.BLANK) {
                    subsystemDataBuilder.addValue(POSSIBLE_MISSING_METHODS);
                }
                String string = d > 0.6 ? Messages.getString("Profiling.major.dropped") : (d > 0.3 ? Messages.getString("Profiling.moderate.dropped") : Messages.getString("Profiling.minor.dropped"));
                structuredStringDataImpl.addInformation(string);
            } else if (structuredStringDataImpl.getStatus() == Status.BLANK) {
                String string = Messages.getString("PercentProfilingDataPostProcessor.evenly.balanced");
                subsystemDataBuilder.addValue(string);
                structuredStringDataImpl.addGoodThing(string);
            }
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void analyseProfilingData(SubsystemDataBuilder subsystemDataBuilder, MethodDictionaryDataImpl methodDictionaryDataImpl, DataBuilder dataBuilder) {
        Data data = subsystemDataBuilder.getData(ProfilingLabels.PROFILE_DATA);
        if (data != null) {
            int n;
            int n2;
            MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl;
            DataBuilder dataBuilder2 = data.getData(ProfilingLabels.METHOD_COUNTS);
            DataBuilder dataBuilder3 = data.getData(ProfilingLabels.CUMULATIVE_METHOD_COUNTS);
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            long l = 0L;
            for (Data data2 : dataBuilder2.getChildren()) {
                int n3;
                if (!(data2 instanceof MethodTwoDimensionalDataImpl) || (n3 = (int)(methodTwoDimensionalDataImpl = (MethodTwoDimensionalDataImpl)data2).getTotalY()) == 0) continue;
                String string = methodTwoDimensionalDataImpl.getID();
                if (!methodTwoDimensionalDataImpl.isMethodNameKnown()) {
                    hashSet2.add(string);
                }
                hashSet.add(string);
                l += (long)n3;
            }
            if (!this.lowOverheadMode) {
                for (Data data2 : dataBuilder3.getChildren()) {
                    if (!(data2 instanceof MethodTwoDimensionalDataImpl)) continue;
                    methodTwoDimensionalDataImpl = (MethodTwoDimensionalDataImpl)data2;
                    String string = methodTwoDimensionalDataImpl.getID();
                    int n4 = (int)methodTwoDimensionalDataImpl.getTotalY();
                    if (n4 == 0) continue;
                    if (!methodTwoDimensionalDataImpl.isMethodNameKnown()) {
                        hashSet2.add(string);
                    }
                    hashSet.add(string);
                }
            }
            this.totalSamplesObject.setSampleCount(l);
            if (methodDictionaryDataImpl != null) {
                methodDictionaryDataImpl.lookup(hashSet2.toArray(EMPTY_STRING_ARRAY));
            }
            StructuredStringDataBuilder structuredStringDataBuilder = (StructuredStringDataBuilder)subsystemDataBuilder.getData(ProfilingLabels.PROFILE_INTERPRETATION);
            ProfilingTableDataImpl profilingTableDataImpl = this.getMethodTable((DataBuilder)data);
            this.clearObsoleteMethods(profilingTableDataImpl, hashSet);
            int n5 = 0;
            double d = 0.0;
            double d2 = 0.0;
            for (String string : hashSet) {
                DataPointBuilder[] dataPointBuilderArray;
                ProfilingTableDataRowImpl profilingTableDataRowImpl = (ProfilingTableDataRowImpl)profilingTableDataImpl.get(string);
                if (profilingTableDataRowImpl == null) {
                    MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl2 = (MethodTwoDimensionalDataImpl)dataBuilder2.getTopLevelData(string);
                    MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl3 = null;
                    if (!this.lowOverheadMode) {
                        methodTwoDimensionalDataImpl3 = (MethodTwoDimensionalDataImpl)dataBuilder3.getTopLevelData(string);
                    }
                    profilingTableDataRowImpl = new ProfilingTableDataRowImpl(methodTwoDimensionalDataImpl2, methodTwoDimensionalDataImpl3, this.totalSamplesObject);
                    profilingTableDataImpl.addRow(string, profilingTableDataRowImpl);
                }
                double d3 = profilingTableDataRowImpl.getPercentage();
                double d4 = profilingTableDataRowImpl.getCumulativePercentage();
                d = Math.max(d3, d);
                d2 = Math.max(d4, d2);
                n5 |= this.checkForExpensiveMethod(structuredStringDataBuilder, d3, profilingTableDataRowImpl.getSampleCount(), profilingTableDataRowImpl.getProfiledMethod());
                SubsystemDataBuilder subsystemDataBuilder2 = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.JIT);
                if (subsystemDataBuilder2 == null) continue;
                Data data3 = subsystemDataBuilder2.getData(JITLabels.COMPILE_END);
                TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data3;
                String string2 = ((JavaMethod)methodDictionaryDataImpl.get(profilingTableDataRowImpl.getMethodId())).getName();
                profilingTableDataRowImpl.setJITCount(0);
                if (twoDimensionalDataBuilder == null || twoDimensionalDataBuilder.isEmpty()) continue;
                for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()) {
                    String string3 = ((JITCompileDataPointImpl)dataPointBuilder).getComment();
                    if (!string2.equals(string3)) continue;
                    profilingTableDataRowImpl.setJITCount(profilingTableDataRowImpl.getJITCount() + 1);
                    profilingTableDataRowImpl.setHotness(((JITCompileDataPointImpl)dataPointBuilder).getHotness());
                }
            }
            if (n5 != 0) {
                subsystemDataBuilder.addValue(structuredStringDataBuilder.getWarnings()[0]);
            }
            if ((n2 = dataBuilder2.getChildren().length) > 0 && (n = hashSet2.size() * 100 / n2) > 40) {
                this.addWarningExplainingMissingMethodNames(structuredStringDataBuilder);
            }
            if (n5 == 0 && l < 200L) {
                String string = Messages.getString("PercentProfilingDataPostProcessor.too.few.samples");
                structuredStringDataBuilder.addInformation(string);
                subsystemDataBuilder.addValue(string);
            }
        }
    }

    private void addWarningExplainingMissingMethodNames(StructuredStringDataBuilder structuredStringDataBuilder) {
        String string;
        if (this.environmentData != null) {
            if (this.environmentData.isVMOlderThan(20090330)) {
                string = Messages.getString("PercentProfilingDataPostProcessor.missing.method.names");
            } else {
                string = Messages.getString("PercentProfilingDataPostProcessor.missing.method.names.but.should.be.there");
                String string2 = Messages.getString("PercentProfilingDataPostProcessor.missing.method.names.workaround");
                structuredStringDataBuilder.addInformation(string2);
            }
        } else {
            string = Messages.getString("PercentProfilingDataPostProcessor.missing.method.names.version.unknown");
        }
        structuredStringDataBuilder.addWarning(string);
    }

    private ProfilingTableDataImpl getMethodTable(DataBuilder dataBuilder) {
        ProfilingTableDataImpl profilingTableDataImpl = (ProfilingTableDataImpl)dataBuilder.getData(ProfilingLabels.PROFILE_TABLE);
        if (profilingTableDataImpl == null) {
            profilingTableDataImpl = new ProfilingTableDataImpl(ProfilingLabels.PROFILE_TABLE);
            dataBuilder.addData(profilingTableDataImpl);
        }
        return profilingTableDataImpl;
    }

    private boolean checkForExpensiveMethod(StructuredStringDataBuilder structuredStringDataBuilder, double d, int n, Method method) {
        boolean bl = false;
        if (d > 15.0 && n > 200) {
            bl = true;
            if (structuredStringDataBuilder != null) {
                double d2 = Math.round(d);
                String string = method.getShortName();
                String string2 = Messages.getString("PercentProfilingDataPostProcessor.expensive.method");
                String string3 = MessageFormat.format(string2, string, d2);
                structuredStringDataBuilder.addWarning(string3);
            }
        }
        return bl;
    }

    private void clearObsoleteMethods(ProfilingTableDataImpl profilingTableDataImpl, Collection<String> collection) {
        ProfilingTableRow[] profilingTableRowArray;
        for (ProfilingTableRow profilingTableRow : profilingTableRowArray = profilingTableDataImpl.getContents()) {
            Object object = profilingTableRow.get(0);
            if (collection.contains(object)) continue;
            profilingTableDataImpl.removeRow(object.toString());
        }
    }
}

