/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.threads.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullEventDataPoint;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ThreadInternalObject;
import com.ibm.java.diagnostics.healthcenter.threads.Messages;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadLabels;
import com.ibm.java.diagnostics.healthcenter.threads.parser.AbstractThreadParser;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.text.MessageFormat;

public class ThreadParser307
extends AbstractThreadParser {
    private static final String VERSION = "startThreads3.0.7";
    private static final String MONITORS = "monitors";

    public ThreadParser307() {
        CLASSNAME = ThreadParser307.class.getName();
    }

    @Override
    protected boolean populateThreadData(DataBuilder dataBuilder, String[] stringArray) {
        if (!stringArray[0].startsWith("startThreads")) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        SubsystemDataBuilder subsystemDataBuilder = this.getThreadSubsystemData(dataBuilder);
        for (String string : stringArray) {
            if (!string.startsWith("startThreads")) continue;
            this.position = 0;
            this.position = this.findNextDelimeter(string) + 2;
            l = this.readNextLong(string, this.position);
            if (l2 != 0L && l2 != l) {
                this.createThreadNumberDataPoint(subsystemDataBuilder, n, l2);
                n = 0;
            }
            l2 = l;
            n = this.readNextInteger(string, this.position);
            while (this.position < string.length()) {
                int n2;
                int n3;
                int n4;
                String string2;
                int n5;
                int n6;
                int n7 = this.readNextInteger(string, this.position);
                long l3 = this.readNextLong(string, this.position);
                int n8 = this.readNextInteger(string, this.position);
                String string3 = this.readNextString(string, this.position, n8);
                int n9 = this.readNextInteger(string, this.position);
                String string4 = this.readNextString(string, this.position, n9);
                StackTraceElement[] stackTraceElementArray = null;
                int n10 = this.readNextInteger(string, this.position);
                if (n10 > 0) {
                    stackTraceElementArray = new StackTraceElement[n10];
                    for (n6 = 0; n6 < n10; ++n6) {
                        int n11 = this.readNextInteger(string, this.position);
                        String string5 = this.readNextString(string, this.position, n11);
                        n5 = this.readNextInteger(string, this.position);
                        string2 = this.readNextString(string, this.position, n5);
                        n4 = this.readNextInteger(string, this.position);
                        String string6 = this.readNextString(string, this.position, n4);
                        int n12 = this.readNextInteger(string, this.position);
                        stackTraceElementArray[n6] = new StackTraceElement(string5, string2, string6, n12);
                    }
                }
                n6 = this.readNextInteger(string, this.position);
                MonitorInfo[] monitorInfoArray = null;
                monitorInfoArray = new MonitorInfo[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    n5 = this.readNextInteger(string, this.position);
                    string2 = this.readNextString(string, this.position, n5);
                    n4 = this.readNextInteger(string, this.position);
                    int n13 = this.readNextInteger(string, this.position);
                    StackTraceElement stackTraceElement = n13 == -1 ? null : stackTraceElementArray[n13];
                    monitorInfoArray[n3] = new MonitorInfo(string2, n4, n13, stackTraceElement);
                }
                n3 = this.readNextInteger(string, this.position);
                LockInfo[] lockInfoArray = null;
                lockInfoArray = new LockInfo[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    n4 = this.readNextInteger(string, this.position);
                    String string7 = this.readNextString(string, this.position, n4);
                    int n14 = this.readNextInteger(string, this.position);
                    lockInfoArray[n2] = new LockInfo(string7, n14);
                }
                n2 = this.readNextInteger(string, this.position);
                String string8 = null;
                if (n2 > 0) {
                    string8 = this.readNextString(string, this.position, n2);
                }
                this.createThreadDetailsDataPoint(subsystemDataBuilder, l, l3, string3, string4, n6, monitorInfoArray, lockInfoArray, string8, stackTraceElementArray);
            }
        }
        this.createThreadNumberDataPoint(subsystemDataBuilder, n, l);
        return true;
    }

    private void createThreadNumberDataPoint(DataBuilder dataBuilder, int n, double d) {
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        String string = ThreadLabels.THREAD_NUMBER;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, n, this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private void createThreadDetailsDataPoint(DataBuilder dataBuilder, double d, long l, String string, String string2, int n, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray, String string3, StackTraceElement[] stackTraceElementArray) {
        ThreadInternalObject threadInternalObject = new ThreadInternalObject((long)d, string);
        threadInternalObject.setThreadID(l);
        threadInternalObject.setContendedMonitor(string3);
        threadInternalObject.setLocksOwned(lockInfoArray);
        threadInternalObject.setNumMonitorsOwned(n);
        threadInternalObject.setOwnedMonitors(monitorInfoArray);
        threadInternalObject.setState(string2);
        threadInternalObject.setThreadCallStack(stackTraceElementArray);
        MarshallerImpl.getMarshaller().getThreadEventHandler().addEvent(threadInternalObject);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        String string4 = ThreadLabels.THREADS;
        DataBuilder dataBuilder2 = dataBuilder.getData(string4);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string4, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        TwoDimensionalDataImpl twoDimensionalDataImpl = null;
        if (monitorInfoArray != null) {
            Object object;
            twoDimensionalDataImpl = new TwoDimensionalDataImpl(MONITORS, this.numberAxisPair);
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                object = monitorInfo.getLockedStackFrame() == null ? Messages.getString("ThreadParser308.data.unavailable") : monitorInfo.getLockedStackFrame().toString();
                String string5 = monitorInfo.getClassName() + " " + MessageFormat.format(Messages.getString("ThreadParser308.frame"), object);
                FullEventDataPoint fullEventDataPoint = new FullEventDataPoint(0, d, string5, this.numberAxisPair);
                twoDimensionalDataImpl.addDataPointBuilder(fullEventDataPoint);
            }
            for (LockInfo lockInfo : lockInfoArray) {
                object = new FullEventDataPoint(0, d, lockInfo.getClassName(), this.numberAxisPair);
                twoDimensionalDataImpl.addDataPointBuilder((DataPointBuilder)object);
            }
        }
        ThreadDataPointImpl threadDataPointImpl = new ThreadDataPointImpl(0, d, string, string2, n, twoDimensionalDataImpl, string3, this.numberAxisPair, stackTraceElementArray, monitorInfoArray, lockInfoArray);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(threadDataPointImpl);
    }

    @Override
    protected boolean canHandleVersion(String string) {
        return string.startsWith(VERSION);
    }
}

