/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.vmControl.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerUtil;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.StackControlDataImpl;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.TraceControlDataImpl;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.VmControlLabels;

public class VmControlSourceConfigurationParser
implements LineParser {
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String PROPERTY_ASSIGNMENT = "=";
    private static final String CONFIGURATION = SubsystemDataBuilder.CONFIGURATION;
    public static final String SOURCE_TAG = "#Configuration saved by";
    private static final String HASH = "#";
    private boolean gotGoodData = false;
    private static final String EMPTY_STRING = "";

    protected String getConfigurationFileTag() {
        return "TRACE";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        void var8_11;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(CONFIGURATION);
        int n = 0;
        int n2 = 0;
        for (String string : stringArray) {
            Object object;
            Object object2;
            if (!this.gotGoodData && string.contains(SOURCE_TAG) && string.contains(this.getConfigurationFileTag())) {
                this.gotGoodData = true;
                if (dataBuilder2 == null) {
                    dataBuilder2 = new StringDataImpl(CONFIGURATION);
                    dataBuilder.addData(dataBuilder2);
                }
                object2 = new StringDataImpl(VmControlLabels.VMCONTROL);
                dataBuilder2.addData((DataBuilder)object2);
                object = new TraceControlDataImpl((ConfigurableSource)dynamicSource);
                object2.addData((DataBuilder)object);
                object2.addData(new StackControlDataImpl((ConfigurableSource)dynamicSource));
            } else if (this.gotGoodData && !string.startsWith(HASH) && string.contains(PROPERTY_ASSIGNMENT)) {
                object2 = string.split(PROPERTY_ASSIGNMENT);
                object = object2[0];
                String string2 = object2[1];
                boolean bl = ON.equals(object2[1]);
                if (!((String)object).endsWith("subsystem")) {
                    DataBuilder dataBuilder3;
                    Object object3;
                    if (((String)object).startsWith("capability.")) {
                        this.handleCapability(dataBuilder2, (String)object, string2);
                    } else if (((String)object).endsWith("_stacktrace.trigger")) {
                        object3 = ((String)object).substring(0, ((String)object).lastIndexOf("_stacktrace.trigger"));
                        dataBuilder3 = dataBuilder2.getData(VmControlLabels.STACKTRIGGERCONTROL);
                        if (dataBuilder3 instanceof StackControlDataImpl) {
                            ((StackControlDataImpl)dataBuilder3).updateTrigger((String)object3, bl);
                        }
                    } else if (((String)object).equals("verbose.gc")) {
                        object3 = dataBuilder2.getData(VmControlLabels.VMCONTROL);
                        if (object3 != null) {
                            if (OFF.equals(string2)) {
                                object3.removeData(VmControlLabels.VERBOSEGC_CONTROL);
                            } else {
                                dataBuilder3 = (StringDataImpl)object3.getTopLevelData(VmControlLabels.VERBOSEGC_CONTROL);
                                String string3 = bl ? this.checkVerboseGCSubscription(dataBuilder) : string2;
                                if (dataBuilder3 == null || !string3.equals(((StringDataImpl)dataBuilder3).getValue())) {
                                    if (!string3.equals(EMPTY_STRING) && this.isConnectionLive(dataBuilder)) {
                                        this.displayPopUp(string3);
                                    }
                                    object3.addData(new StringDataImpl(VmControlLabels.VERBOSEGC_CONTROL, string3));
                                }
                            }
                        }
                    } else {
                        object3 = dataBuilder2.getData(VmControlLabels.TRACECONTROL);
                        if (object3 instanceof TraceControlDataImpl) {
                            ((TraceControlDataImpl)object3).update((String)object, bl);
                        }
                    }
                }
            }
            ++n2;
        }
        if (this.gotGoodData) {
            ProgressIndicatorImpl progressIndicatorImpl = new ProgressIndicatorImpl(n2, n, 1000);
        } else {
            ProgressIndicator progressIndicator = ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        return var8_11;
    }

    public void displayPopUp(String string) {
    }

    private void handleCapability(DataBuilder dataBuilder, String string, String string2) {
        String string3 = string.substring("capability.".length());
        DataBuilder dataBuilder2 = dataBuilder.getData(VmControlLabels.VMCONTROL);
        if (dataBuilder2 != null) {
            if (string3.equals("verbose.gc.available")) {
                dataBuilder2.addData(new StringDataImpl("verboseGC.control.available", string2));
            } else if (string3.equals("allocation.sampling.available")) {
                dataBuilder2.addData(new StringDataImpl("allocation.sampling.available", string2));
            } else if (string3.equals("allocation.threshold.available")) {
                dataBuilder2.addData(new StringDataImpl("allocation.threshold.available", string2));
            }
        }
    }

    private String checkVerboseGCSubscription(DataBuilder dataBuilder) {
        String string;
        AgentInfo agentInfo = null;
        agentInfo = MarshallerUtil.getMarshallerUtil().getAgentInfo(dataBuilder);
        if (agentInfo != null && (string = agentInfo.getInfo("verbosegcfilename")) != null) {
            return string;
        }
        return EMPTY_STRING;
    }

    private boolean isConnectionLive(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getData(JVMLabels.CONNECTION);
        if (dataBuilder2 instanceof ConnectionData) {
            ConnectionData connectionData = (ConnectionData)((Object)dataBuilder2);
            return connectionData.getConnectionType() == ConnectionType.JMX || connectionData.getConnectionType() == ConnectionType.MQTT || connectionData.getConnectionType() == ConnectionType.BLUEMIX;
        }
        return false;
    }
}

