/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.Message;
import java.util.ArrayList;

public class Component {
    private String name;
    private byte[] nameBytes;
    ArrayList messageList;
    private int base;

    public Component(String componentName) {
        this.name = componentName;
        this.nameBytes = componentName.getBytes();
        this.messageList = new ArrayList();
        this.base = -1;
    }

    public void setBase(int newBase) {
        this.base = newBase;
    }

    public String getName() {
        return this.name;
    }

    public void addMessage(Message msg) {
        this.messageList.add(msg);
    }

    public Message getMessageByID(int id) {
        if (id < 0) {
            return null;
        }
        if (this.base == -1) {
            if (id >= this.messageList.size()) {
                return null;
            }
            return (Message)this.messageList.get(id);
        }
        if (id - this.base >= this.messageList.size()) {
            return null;
        }
        return (Message)this.messageList.get(id - this.base);
    }

    public void addMessage(Message msg, int id) {
        if (this.base == -1) {
            throw new Error("must set base before adding an IDed message");
        }
        int currSize = this.messageList.size();
        id -= this.base;
        for (int i = 0; i < id + 1 - currSize; ++i) {
            this.messageList.add(null);
        }
        this.messageList.add(id, msg);
        this.messageList.remove(id + 1);
    }

    public int compareTo(byte[] otherName) {
        int len = this.nameBytes.length;
        if (len > otherName.length) {
            return 1;
        }
        if (len < otherName.length) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            if (this.nameBytes[i] == otherName[i]) continue;
            return this.nameBytes[i] > otherName[i] ? 1 : -1;
        }
        return 0;
    }
}

