/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.logging.glug.support;

import com.ibm.bi.logging.glug.support.InvalidLoggingCookieException;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class LoggingCookie {
    public static final String COOKIE_NAME = "ba-logging-session";
    private static final int NTERMS = 4;
    private static final int VERSIONTERM = 0;
    private static final int IDTERM = 1;
    private static final int EXPIRYTERM = 2;
    private static final int DURATIONTERM = 3;
    private static final String CURRENTVERSION = "v1";
    private String sessionId;
    private long expiry;
    private int durationSecs;

    private LoggingCookie(String sessionId, long expiry, int durationSeconds) {
        this.sessionId = sessionId;
        this.expiry = expiry;
        this.durationSecs = durationSeconds;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public int getDurationSeconds() {
        return this.durationSecs;
    }

    public static LoggingCookie makeNew(int durationSeconds) {
        return LoggingCookie.cookieBuilder(durationSeconds, UUID.randomUUID().toString());
    }

    public static LoggingCookie update(LoggingCookie logCookie) {
        return LoggingCookie.cookieBuilder(logCookie.getDurationSeconds(), logCookie.getSessionId());
    }

    public static LoggingCookie cookieBuilder(int durationSeconds, String sessionid) {
        long ts = DateUtils.addSeconds((Date)new Date(), (int)durationSeconds).getTime();
        return new LoggingCookie(sessionid, ts, durationSeconds);
    }

    public static LoggingCookie parseCookie(String cookieValue) throws InvalidLoggingCookieException {
        LoggingCookie cookie = null;
        if (StringUtils.isEmpty((String)cookieValue)) {
            return cookie;
        }
        try {
            cookie = LoggingCookie.parseString(new String(Base64.getUrlDecoder().decode(cookieValue)));
        }
        catch (IllegalArgumentException x) {
            throw new InvalidLoggingCookieException("failed to parse cookie, encoding is invalid");
        }
        return cookie;
    }

    static LoggingCookie parseString(String input) throws InvalidLoggingCookieException {
        LoggingCookie cookie = null;
        try {
            String[] terms = StringUtils.split((String)input, (char)':');
            if (terms.length != 4) {
                throw new InvalidLoggingCookieException("malformed cookie: wrong number of terms");
            }
            if (!CURRENTVERSION.equals(terms[0])) {
                throw new InvalidLoggingCookieException("malformed cookie: unsupported version: " + terms[0]);
            }
            String sessionId = terms[1];
            long expiry = Long.parseLong(terms[2]);
            int duration = Integer.parseInt(terms[3]);
            cookie = new LoggingCookie(sessionId, expiry, duration);
        }
        catch (NumberFormatException nfx) {
            throw new InvalidLoggingCookieException("failed to decode cookie, expiry is not a valid number");
        }
        return cookie;
    }

    public String toString() {
        return CURRENTVERSION + ':' + this.sessionId + ':' + this.expiry + ':' + this.durationSecs;
    }

    public String toEncodedString() {
        return Base64.getUrlEncoder().encodeToString(this.toString().getBytes());
    }

    public boolean isExpired() {
        return this.expiry < new Date().getTime();
    }
}

