/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.filters;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterBase.class);
    static final String COGNOS_NS_ROOT = "xOg__";
    private static final String UPS = "/bi/v1/users/~/user_profile_settings";
    private static final String NAMESPACE_FOLDER = "rootFolder_CognosNamespace";
    private static final String ADD_BUILTIN_OBJECTS = "addBuiltinObjects";

    String getTenantNamespaceFolderId(HttpServletRequest servletRequest, Map<String, String[]> parameterMap, String paramValue) {
        if (StringUtils.equals((String)paramValue, (String)COGNOS_NS_ROOT)) {
            return this.getNamespaceFolder(servletRequest, parameterMap);
        }
        return paramValue;
    }

    String getNamespaceFolder(HttpServletRequest servletRequest, Map<String, String[]> parameterMap) {
        String nsf = COGNOS_NS_ROOT;
        try (RESTClient client = this.getCARESTClient(servletRequest);){
            JsonObject ups = client.getResource(UPS, "application/json");
            if (ups != null && ups.containsKey((Object)NAMESPACE_FOLDER)) {
                nsf = ups.getString(NAMESPACE_FOLDER);
                if (!(nsf.isEmpty() || nsf.equals(COGNOS_NS_ROOT) || parameterMap.containsKey(ADD_BUILTIN_OBJECTS))) {
                    parameterMap.put(ADD_BUILTIN_OBJECTS, new String[]{"true"});
                }
            } else {
                nsf = COGNOS_NS_ROOT;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return nsf != null ? nsf : COGNOS_NS_ROOT;
    }

    RESTClient getCARESTClient(HttpServletRequest servletRequest) {
        return RESTClientFactory.getInstance().getClient(servletRequest);
    }
}

