/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.json.JsonEngine;
import java.io.IOException;
import java.lang.reflect.Type;

public class JacksonEngine
implements JsonEngine {
    private ObjectMapper mapper = new ObjectMapper();

    public JacksonEngine() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public String toJson(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new AdminException(e);
        }
    }

    @Override
    public Object fromJson(String json, Type t) {
        throw new UnsupportedOperationException("The method is not supported by Jackson.");
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new AdminException(e);
        }
    }
}

