/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.model.search;

import com.ibm.bi.admin.commons.model.search.ConditionalExpression;
import com.ibm.bi.admin.commons.model.search.PredicateExpression;
import com.ibm.bi.admin.commons.model.search.RelationalExpression;
import com.ibm.bi.admin.commons.model.search.SearchFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchFilterParser {
    private static final Logger logger = LoggerFactory.getLogger(SearchFilterParser.class);

    private SearchFilterParser() {
    }

    private static String parsePropertyName(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c = reader.read();
        if (c == -1) {
            throw new IllegalArgumentException("invalid filter, premature eol");
        }
        while (c != 61) {
            if (c == 34 || c == -1 || c == 64) {
                throw new IllegalArgumentException("invalid filter. Found: " + c);
            }
            builder.append((char)c);
            c = reader.read();
        }
        return builder.toString();
    }

    private static String parseConstraint(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int c = reader.read();
        if (c == -1) {
            throw new IllegalArgumentException("invalid filter, premature eol");
        }
        if (c != 34) {
            throw new IllegalArgumentException("invalid filter, expecting quote found " + c);
        }
        c = reader.read();
        while (c != 34) {
            if (c == -1) {
                throw new IllegalArgumentException("invalid filter, expecting quote found eol");
            }
            builder.append((char)c);
            c = reader.read();
        }
        return builder.toString();
    }

    private static SearchFilter parseOneFilter(Reader reader) throws IOException {
        String property = SearchFilterParser.parsePropertyName(reader);
        String constraint = SearchFilterParser.parseConstraint(reader);
        return new RelationalExpression("=", property, constraint);
    }

    public static SearchFilter parse(String filterString) {
        StringReader reader = new StringReader(filterString);
        SearchFilter filter = null;
        String operator = null;
        try {
            while (true) {
                filter = filter == null ? SearchFilterParser.parseOneFilter(reader) : new ConditionalExpression(operator, filter, SearchFilterParser.parseOneFilter(reader));
                int c = reader.read();
                if (c == 38) {
                    operator = "and";
                    continue;
                }
                if (c == 124) {
                    operator = "or";
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return new PredicateExpression(filter);
    }
}

