/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.model.search;

import com.ibm.bi.admin.commons.model.search.ConditionalExpression;
import com.ibm.bi.admin.commons.model.search.FunctionCall;
import com.ibm.bi.admin.commons.model.search.PredicateExpression;
import com.ibm.bi.admin.commons.model.search.RelationalExpression;
import com.ibm.bi.admin.commons.model.search.SearchFilter;

public final class SearchFilterSerializer {
    private SearchFilterSerializer() {
    }

    public static String serialize(SearchFilter filter) {
        StringBuilder buffer = new StringBuilder();
        SearchFilterSerializer.serialize(filter, buffer);
        return buffer.toString();
    }

    public static void serialize(SearchFilter filter, StringBuilder buffer) {
        if (filter instanceof RelationalExpression) {
            RelationalExpression f = (RelationalExpression)filter;
            buffer.append('@');
            buffer.append(f.getProperty());
            buffer.append(f.getOperator());
            buffer.append('\"');
            buffer.append(f.getConstraint());
            buffer.append('\"');
        } else if (filter instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)filter;
            String[] params = f.getParameters();
            buffer.append(f.getFunction());
            buffer.append("(@");
            buffer.append(params[0]);
            for (int i = 1; i < params.length; ++i) {
                buffer.append(",\"");
                buffer.append(params[i]);
                buffer.append('\"');
            }
            buffer.append(')');
        } else if (filter instanceof ConditionalExpression) {
            ConditionalExpression f = (ConditionalExpression)filter;
            boolean leftIsPredicate = f.getLeft() instanceof PredicateExpression;
            boolean rightIsPredicate = f.getRight() instanceof PredicateExpression;
            if (!(leftIsPredicate && rightIsPredicate || !leftIsPredicate && !rightIsPredicate)) {
                throw new IllegalArgumentException("both filters must be predicates or none");
            }
            if (leftIsPredicate && rightIsPredicate) {
                if (!f.getCondition().equals("and")) {
                    throw new IllegalArgumentException("predicates must have an 'and' relationship");
                }
                SearchFilterSerializer.serialize(f.getLeft(), buffer);
                SearchFilterSerializer.serialize(f.getRight(), buffer);
            } else {
                SearchFilterSerializer.serialize(f.getLeft(), buffer);
                buffer.append(' ');
                buffer.append(f.getCondition());
                buffer.append(' ');
                SearchFilterSerializer.serialize(f.getRight(), buffer);
            }
        } else if (filter instanceof PredicateExpression) {
            PredicateExpression f = (PredicateExpression)filter;
            buffer.append('[');
            SearchFilterSerializer.serialize(f.getFilter(), buffer);
            buffer.append(']');
        }
    }
}

