/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.utilities;

import org.slf4j.Logger;

public final class AdminLogger {
    static final String LOG_MSG_PREFIX = "Admin: ";
    private Logger logger;

    public AdminLogger(Logger logger) {
        this.logger = logger;
    }

    private Logger getLoggerInst() {
        return this.logger;
    }

    private String formatMsg(String msg) {
        return LOG_MSG_PREFIX + msg;
    }

    public boolean isErrorEnabled() {
        return this.getLoggerInst().isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLoggerInst().isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLoggerInst().isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.getLoggerInst().isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLoggerInst().isTraceEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.getLoggerInst().error(this.formatMsg(msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.getLoggerInst().error(this.formatMsg(format), arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.getLoggerInst().error(this.formatMsg(format), arg1, arg2);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.isErrorEnabled()) {
            this.getLoggerInst().error(this.formatMsg(format), argArray);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLoggerInst().error(this.formatMsg(msg), t);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.getLoggerInst().warn(this.formatMsg(msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.getLoggerInst().warn(this.formatMsg(format), arg);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.isWarnEnabled()) {
            this.getLoggerInst().warn(this.formatMsg(format), argArray);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.getLoggerInst().warn(this.formatMsg(format), arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLoggerInst().warn(this.formatMsg(msg), t);
        }
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.getLoggerInst().trace(this.formatMsg(msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.getLoggerInst().trace(this.formatMsg(format), arg);
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.isTraceEnabled()) {
            this.getLoggerInst().trace(this.formatMsg(format), argArray);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.getLoggerInst().trace(this.formatMsg(format), arg1, arg2);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.getLoggerInst().trace(this.formatMsg(msg), t);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.getLoggerInst().debug(this.formatMsg(msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.getLoggerInst().debug(this.formatMsg(format), arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.getLoggerInst().debug(this.formatMsg(format), arg1, arg2);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.isDebugEnabled()) {
            this.getLoggerInst().debug(this.formatMsg(format), argArray);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLoggerInst().debug(this.formatMsg(msg), t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.getLoggerInst().info(this.formatMsg(msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.getLoggerInst().info(this.formatMsg(format), arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.getLoggerInst().info(this.formatMsg(format), arg1, arg2);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.isInfoEnabled()) {
            this.getLoggerInst().info(this.formatMsg(format), argArray);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLoggerInst().info(this.formatMsg(msg), t);
        }
    }
}

