/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.utilities;

import com.ibm.bi.admin.crypto.utilities.ServiceTrustedContex;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.SoapDeserializer;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapTransportFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.json.utils.XML;
import org.xml.sax.SAXException;

public class BiBusUtils {
    public static BiBus getBiBus(HttpServletRequest request) throws Exception {
        SoapContext soapContext = new SoapContext(request);
        return new BiBus(soapContext, BiBusUtils.buildBaseURL(request));
    }

    public static BiBus getTrustedBiBus(HttpServletRequest request, String service) throws Exception {
        ServiceTrustedContex soapContext = new ServiceTrustedContex(request);
        return new BiBus(SoapTransportFactory.getInstance().create(), (SoapContext)soapContext, BiBusUtils.buildBaseURL(request));
    }

    public static String buildBaseURL(HttpServletRequest httpServletRequest) {
        String original = (String)httpServletRequest.getAttribute("X-Original-URI");
        if (original != null) {
            return original;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(httpServletRequest.getContextPath());
        buf.append(httpServletRequest.getServletPath());
        return buf.toString();
    }

    public static Object toJsonFromSoapType(String value, String type) throws XMLStreamException {
        TypeLibrary typeLib = BiBus.getTypeLibrary();
        SoapDeserializer soapDeserializer = new SoapDeserializer(typeLib, DefaultJsonFactory.instance, "");
        Schema bus = typeLib.getSchemaByName("bus");
        Object objectJson = soapDeserializer.parse((Reader)new StringReader(value), bus.getType(type));
        return objectJson;
    }

    public static String toJsoFromXml(InputStream stream) throws IOException, SAXException {
        return XML.toJson((InputStream)stream, (boolean)false);
    }
}

