/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.cognos.cclcfgapi.jniCFGAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CCLConfigurationUtils {
    private static Object m_mutex = new Object();
    private static String m_binDirectoryPath = null;

    public static String resolveEffectivePath(String path) {
        return CCLConfigurationUtils.convertToAbsolutePath(path);
    }

    static String convertToAbsolutePath(String path) {
        if (null != path) {
            if (path.length() > 0) {
                boolean isAbsolutePath;
                File f = new File(path);
                boolean bl = isAbsolutePath = f.isAbsolute() || path.charAt(0) == '/' || path.charAt(0) == '\\';
                if (!isAbsolutePath) {
                    String binDir = CCLConfigurationUtils.determineBinDir();
                    if (null != binDir && 0 < binDir.length()) {
                        try {
                            path = new File(binDir, path).getCanonicalPath();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        path = f.getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                path = CCLConfigurationUtils.determineBinDir();
            }
            return path.replace('\\', '/');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineBinDir() {
        String binPath;
        Object object = m_mutex;
        synchronized (object) {
            binPath = m_binDirectoryPath;
        }
        String binFolderName = "bin";
        String propValue = System.getProperty("sun.arch.data.model");
        if (propValue != null) {
            if (propValue.equals("64")) {
                binFolderName = "bin64";
            }
        } else {
            propValue = System.getProperty("com.ibm.vm.bitmode");
            if (propValue != null && propValue.equals("64")) {
                binFolderName = "bin64";
            }
        }
        if (null == binPath) {
            File f;
            try {
                String cogExecPath = System.getProperty("COG_EXEC_PATH");
                if (null != cogExecPath) {
                    try {
                        binPath = new File(cogExecPath).getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (SecurityException cogExecPath) {
                // empty catch block
            }
            if (null == binPath) {
                try {
                    String cogRoot = System.getProperty("COG_ROOT");
                    if (null != cogRoot) {
                        try {
                            binPath = new File(cogRoot, "./" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (SecurityException cogRoot) {
                    // empty catch block
                }
            }
            if (null == binPath) {
                f = new File("../configuration/cogstartup.xml");
                try {
                    if (null != f && f.exists()) {
                        try {
                            binPath = new File("../" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (null == binPath) {
                try {
                    InputStream locationStream = Class.forName("com.cognos.cclcfgapi.CCLConfiguration2").getClassLoader().getResourceAsStream("cogroot.link");
                    if (null != locationStream) {
                        BufferedReader read = new BufferedReader(new InputStreamReader(locationStream));
                        try {
                            binPath = new File(read.readLine(), "./" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (SecurityException locationStream) {
                }
                catch (ClassNotFoundException locationStream) {
                    // empty catch block
                }
            }
            if (null != binPath) {
                f = new File(binPath);
                if (null == f || !f.isDirectory()) {
                    binPath = new String();
                }
            } else {
                binPath = new String();
            }
            Object object2 = m_mutex;
            synchronized (object2) {
                int idx;
                m_binDirectoryPath = binPath;
                if (System.getProperty("jniCFGAPI.setCogRoot", "true").equals("true") && (idx = m_binDirectoryPath.lastIndexOf(File.separator)) != -1) {
                    if (idx == m_binDirectoryPath.length() - 1) {
                        idx = m_binDirectoryPath.lastIndexOf(File.separator, idx - 1);
                    }
                    if (idx != -1) {
                        jniCFGAPI.setCogRoot(m_binDirectoryPath.substring(0, idx));
                    }
                }
            }
        }
        return binPath;
    }
}

