/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class CCLResolveInetAddress {
    private static final String NETWORK_PREFERENCE_VALUE_IPV6 = "IPv6";
    private static final String NETWORK_PREFERENCE_NAME = "networkConfiguration";
    private static final String DNS_UNAVAILABLE_IP_SEGMENT = "169.254";

    public static InetAddress getByName(String host) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(host);
        return address;
    }

    public static InetAddress getLoopbackAddress() {
        boolean preferV4 = CCLResolveInetAddress.isNetworkPreferenceIPV4();
        return CCLResolveInetAddress.getNetworkAddresses(true, preferV4);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress adr = null;
        boolean preferV4 = CCLResolveInetAddress.isNetworkPreferenceIPV4();
        try {
            adr = CCLResolveInetAddress.getNetworkAddresses(false, preferV4);
        }
        catch (Exception e) {
            throw new UnknownHostException();
        }
        return adr;
    }

    private static boolean isNetworkPreferenceIPV4() {
        boolean preferV4 = true;
        try {
            String param = CCLConfigurationFactory.getInstance().getValue(NETWORK_PREFERENCE_NAME, false);
            if (param != null && param.equalsIgnoreCase(NETWORK_PREFERENCE_VALUE_IPV6)) {
                preferV4 = false;
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return preferV4;
    }

    private static InetAddress getNetworkAddresses(boolean loopbackFlag, boolean preferV4) {
        Enumeration<NetworkInterface> interfaces = null;
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interf = interfaces.nextElement();
                if (interf == null || !interf.isUp() || loopbackFlag != interf.isLoopback()) continue;
                Enumeration<InetAddress> adrs = interf.getInetAddresses();
                while (adrs.hasMoreElements()) {
                    byte[] b;
                    int addrLen;
                    InetAddress inadr = adrs.nextElement();
                    if (inadr == null || (addrLen = (b = inadr.getAddress()).length) != 4 && addrLen != 16) continue;
                    String fqdn = inadr.getCanonicalHostName();
                    String ip = inadr.getHostAddress();
                    if (fqdn == null || ip == null || ip.length() <= 0) continue;
                    if (fqdn.length() > 0 && !fqdn.equalsIgnoreCase(ip) && !ip.startsWith(DNS_UNAVAILABLE_IP_SEGMENT)) {
                        if (preferV4 && addrLen == 4 || !preferV4 && addrLen == 16) {
                            addresses.add(0, inadr);
                            continue;
                        }
                        addresses.add(inadr);
                        continue;
                    }
                    addresses.add(inadr);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (addresses.isEmpty()) {
            return null;
        }
        return (InetAddress)addresses.get(0);
    }
}

