/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.cognos.cclcfgapi.CCLConfiguration2;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class CCLStartupConfiguration {
    public static final int CCLCFGAPI_Success = 0;
    public static final int CCLCFGAPI_StartupFileNotFound = 1;
    public static final int CCLCFGAPI_StartupFileEmpty = 2;
    public static final int CCLCFGAPI_StartupFileParseError = 3;
    public static final int CCLCFGAPI_StartupFileViolation = 4;
    public static final int CCLCFGAPI_RuntimeDocParseError = 5;
    public static final int CCLCFGAPI_InitAPIWarning = 6;
    public static final int CCLCFGAPI_InitCryptoError = 7;
    public static final int CCLCFGAPI_CryptoDecryptionError = 8;
    public static final int CCLCFGAPI_UnknownException = 9;
    public static final int CCLCFGAPI_InvalidArguments = 10;
    public static final String CRN_NAMESPACE = "http://developer.cognos.com/schemas/crconfig/1/";
    public static final String CFG_NAMESPACE = "http://developer.cognos.com/schemas/configparams/XMLSchema/1/";
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private Map m_parameterNameValueMap = new HashMap();
    protected static final String PARAMETERS_TAG = "parameters";
    protected static final String PARAMETER_TAG = "parameter";
    protected static final String INSTANCES_TAG = "instances";
    protected static final String INSTANCE_TAG = "instance";
    protected static final String VALUE_TAG = "value";
    protected static final String NAME_ATTR = "name";
    protected static final String OPAQUE_ATTR = "opaque";
    protected static final String DISABLED_ATTR = "disabled";
    protected static final String ENCRYPTED_ATTR = "encrypted";
    protected static final String VERSION_ATTR = "version";
    protected static final Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    protected static final Namespace nsCFG = new Namespace("cfg", "http://developer.cognos.com/schemas/configparams/XMLSchema/1/");
    protected static final Namespace nsXSD = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    protected static final Namespace nsXSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    protected static final QName qnParameters = new QName("parameters", nsCRN);
    protected static final QName qnParameter = new QName("parameter", nsCRN);
    protected static final QName qnValue = new QName("value", nsCRN);
    protected static final QName qnXSIType = new QName("type", nsXSI);
    protected static final QName qnXSIArrayType = new QName("arrayType", nsXSI);
    static final String DEFAULT_CONFIGURATION_FILE = "../configuration/cogstartup.xml";

    public static synchronized int getStartupConfigurationDocument(StringBuffer sStartupConfigurationDocument) {
        return CCLStartupConfiguration.getStartupConfigurationDocument(sStartupConfigurationDocument, true);
    }

    static synchronized int getStartupConfigurationDocument(StringBuffer sStartupConfigurationDocument, boolean bResolvePaths) {
        if (null == sStartupConfigurationDocument) {
            return 10;
        }
        Document doc = DocumentHelper.createDocument();
        int result = CCLStartupConfiguration.getConfigDoc(DEFAULT_CONFIGURATION_FILE, doc);
        if (result == 0) {
            if (bResolvePaths) {
                CCLConfiguration2.fixupPaths(doc.getRootElement());
            }
            sStartupConfigurationDocument.setLength(0);
            sStartupConfigurationDocument.append(doc.asXML());
        }
        return result;
    }

    static int getStartupConfigurationDocument(String startupConfigFilePath, StringBuilder startupConfigurationAsString, boolean resolvePaths) {
        if (null == startupConfigurationAsString) {
            return 10;
        }
        Document doc = DocumentHelper.createDocument();
        int result = CCLStartupConfiguration.getConfigDoc(startupConfigFilePath, doc);
        if (result == 0) {
            if (resolvePaths) {
                CCLConfiguration2.fixupPaths(doc.getRootElement());
            }
            startupConfigurationAsString.setLength(0);
            startupConfigurationAsString.append(doc.asXML());
        }
        return result;
    }

    public synchronized int getParameterNames(List iteration) {
        if (null == iteration) {
            return 10;
        }
        int result = this.initialize();
        if (result == 0) {
            Iterator parameterNamesList = this.m_parameterNameValueMap.entrySet().iterator();
            while (parameterNamesList.hasNext()) {
                String pair = parameterNamesList.next().toString();
                pair = pair.substring(0, pair.indexOf("="));
                iteration.add(pair);
            }
        }
        return result;
    }

    public synchronized int getValue(String paramName, boolean decrypt, StringBuffer valueBuffer) {
        if (null == paramName || null == valueBuffer) {
            return 10;
        }
        int result = this.initialize();
        if (result == 0) {
            String sValue = (String)this.m_parameterNameValueMap.get(paramName);
            valueBuffer.setLength(0);
            valueBuffer.append(sValue);
        }
        return result;
    }

    private int initialize() {
        Element rootElement;
        if (!this.m_parameterNameValueMap.isEmpty()) {
            return 0;
        }
        Document doc = DocumentHelper.createDocument();
        int result = CCLStartupConfiguration.getConfigDoc(doc);
        if (result == 0 && (rootElement = doc.getRootElement()).getQName().equals((Object)qnParameters)) {
            List parameterNodeList = rootElement.elements(qnParameter);
            for (Element paramElement : parameterNodeList) {
                String value;
                String name = paramElement.attributeValue(NAME_ATTR);
                String opaque = paramElement.attributeValue(OPAQUE_ATTR);
                Element valueElement = paramElement.element(qnValue);
                if (opaque != null && opaque.compareToIgnoreCase("true") == 0) {
                    valueElement.add(nsCFG);
                    valueElement.add(nsXSD);
                    valueElement.add(nsXSI);
                    value = valueElement.asXML();
                } else {
                    value = valueElement.getText();
                }
                this.m_parameterNameValueMap.put(name, value);
            }
        }
        return result;
    }

    private static int getConfigDoc(String startupConfigFilePath, Document cfgdoc) {
        if (cfgdoc == null) {
            return 10;
        }
        try {
            File configFile = new File(CCLConfigurationUtils.resolveEffectivePath(startupConfigFilePath));
            if (!configFile.exists()) {
                return 1;
            }
            SAXReader reader = new SAXReader();
            Document doc = reader.read(configFile);
            Element rootElement = doc.getRootElement();
            if (rootElement != null) {
                List parameterElementList = rootElement.elements(qnParameter);
                for (Element parameterElement : parameterElementList) {
                    CCLStartupConfiguration.removeDisabledElements(parameterElement);
                }
                rootElement.detach();
                cfgdoc.setRootElement(rootElement);
                return 0;
            }
            return 3;
        }
        catch (DocumentException e) {
            return 3;
        }
    }

    private static int getConfigDoc(Document cfgdoc) {
        return CCLStartupConfiguration.getConfigDoc(DEFAULT_CONFIGURATION_FILE, cfgdoc);
    }

    private static void removeDisabledElements(Element element) {
        if (null != element) {
            String disabledAttrValue = element.attributeValue(DISABLED_ATTR);
            if (null != disabledAttrValue && disabledAttrValue.equalsIgnoreCase("true")) {
                element.detach();
            } else {
                List childElementList = element.elements();
                for (Element childElement : childElementList) {
                    if (null == childElement || !childElement.getName().equals(PARAMETER_TAG) && !childElement.getName().equals(INSTANCES_TAG) && !childElement.getName().equals(INSTANCE_TAG) && !childElement.getName().equals(VALUE_TAG)) continue;
                    CCLStartupConfiguration.removeDisabledElements(childElement);
                }
            }
        }
    }
}

