/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external;

import com.ibm.bi.config.external.CheckedFileContentException;
import com.ibm.bi.config.external.CheckedFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedInputStreamFilter
extends FilterInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CheckedInputStreamFilter.class);
    private static final int HDRSIZE = 128;
    private CheckedInputStream dataStream;
    private InputStream readFrom;
    private long checkSum;
    private byte[] headerBuffer = new byte[128];
    private int headerLen;

    public CheckedInputStreamFilter(InputStream upstream) throws IOException {
        super(upstream);
        this.checkSum = this.getChecksumFromHeader(upstream);
        if (this.checkSum != -1L) {
            this.dataStream = new CheckedInputStream(upstream, new CRC32());
            this.readFrom = this.dataStream;
        } else {
            this.readFrom = new SequenceInputStream(new ByteArrayInputStream(this.headerBuffer, 0, this.headerLen), upstream);
        }
    }

    long getChecksumFromHeader(InputStream is) throws CheckedFileContentException {
        try {
            this.headerLen = IOUtils.read((InputStream)is, (byte[])this.headerBuffer);
            if (CheckedFileInputStream.startsWithCRC32Prefix(this.headerBuffer)) {
                if (this.headerLen < 128) {
                    throw new CheckedFileContentException("crc32 header is truncated");
                }
                return CheckedFileInputStream.parseChecksum(this.headerBuffer);
            }
            LOG.debug("no crc32 prefix, assuming not checksummed");
            return -1L;
        }
        catch (NumberFormatException nfx) {
            throw new CheckedFileContentException("checksum header is invalid, does not parse as long");
        }
        catch (CheckedFileContentException cfcx) {
            throw cfcx;
        }
        catch (IOException iox) {
            LOG.debug("failed to read checksum header", (Throwable)iox);
            throw new CheckedFileContentException("failed to read checksum header");
        }
    }

    @Override
    public int read() throws IOException {
        int res = this.readFrom.read();
        if (res == -1) {
            this.validate();
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.readFrom.read(b, off, len);
        if (res == -1) {
            this.validate();
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        this.readFrom.close();
        this.validate();
    }

    private void validate() throws CheckedFileContentException {
        if (this.checkSum != -1L && this.dataStream.getChecksum().getValue() != this.checkSum) {
            throw new CheckedFileContentException("checksum error");
        }
    }
}

