/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import org.w3c.dom.Element;

public class ServiceProperty {
    String serviceName;
    String name;
    String type;
    String defaultValue;
    String label;
    String minValue;
    String maxValue;
    boolean isGlobal;
    boolean isLegacy;
    boolean isSecureKey;

    public ServiceProperty(String serviceName, Element param) {
        this.serviceName = serviceName;
        this.name = param.getAttribute("name");
        this.type = param.getAttribute("type");
        this.defaultValue = param.hasAttribute("default") ? param.getAttribute("default") : null;
        this.label = param.getAttribute("label");
        this.minValue = param.getAttribute("minValue");
        this.maxValue = param.getAttribute("maxValue");
        String sGlobal = param.getAttribute("global");
        this.isGlobal = Boolean.valueOf(sGlobal);
        String sLegacy = param.getAttribute("legacy");
        this.isLegacy = Boolean.valueOf(sLegacy);
        String sSecureKey = param.getAttribute("encrypted");
        this.isSecureKey = Boolean.valueOf(sSecureKey);
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getType() {
        return this.type;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isSecureKey() {
        return this.isSecureKey;
    }

    public String getFullName() {
        if (this.isLegacy) {
            return this.name;
        }
        return this.serviceName + "." + this.name;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }
}

