/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.util;

import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);

    public static Document load(File xmlfile) {
        if (xmlfile == null) {
            LOG.error("XMLUtils.load() - No file is passed in calling load()");
            return null;
        }
        if (!xmlfile.exists()) {
            LOG.error("The file " + xmlfile.getAbsolutePath() + " doesn't exist.");
            return null;
        }
        try {
            Document doc = XMLUtils.load(new FileInputStream(xmlfile));
            return doc;
        }
        catch (Exception e) {
            LOG.error("Unable to parse the xml file '" + xmlfile.getAbsolutePath() + "'. Exception:  " + e.toString());
            return null;
        }
    }

    public static Document load(InputStream is) throws Exception {
        if (is == null) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        return doc;
    }

    public static Document xmlStringToDocument(String xmlString) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xmlString));
        Document dom = builder.parse(is);
        return dom;
    }

    public static boolean serialize(Document doc, File xmlFile) {
        if (doc == null) {
            LOG.error("XMLUtils.serialize() - input Document is null, nothing to serialize.");
            return false;
        }
        boolean res = false;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(xmlFile);
            transformer.transform(source, result);
            res = true;
            LOG.info("Saved to file " + xmlFile.getAbsolutePath());
        }
        catch (TransformerException e) {
            res = false;
            LOG.error("Failed to serialize to file " + xmlFile.getAbsolutePath() + ". - " + e.toString());
        }
        return res;
    }

    public static String serializeToString(Element param) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)param.getOwnerDocument().getImplementation().getFeature("ls", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        serializer.getDomConfig().setParameter("comments", false);
        String serialized = serializer.writeToString(param);
        serialized = serialized.replace("\n", "").replace("\r", "");
        return serialized;
    }

    private static Element getAuthProviders(String aaaXML) {
        Element orginputaaaElem = XMLUtils.getDocElementFromXMLString(aaaXML);
        if (orginputaaaElem == null) {
            LOG.error("getAuthProviders - the input AAA string is not valid.");
            return null;
        }
        Element valueElem = XMLUtils.getChildElement(orginputaaaElem, "crn:value", null);
        if (valueElem == null) {
            LOG.error("getAuthProviders - the input AAA value string is not valid. It should have value element.");
            return null;
        }
        Element authProviderElem = XMLUtils.getChildElement(valueElem, "crn:instances", "authProvider");
        return authProviderElem;
    }

    public static Element getChildElement(Element currentElement, String nodeName, String attrName) {
        return XMLUtils.getChildElement(currentElement, nodeName, "name", attrName);
    }

    private static Element getChildElement(Element currentElement, String nodeName, String attrName, String attrValue) {
        if (currentElement != null) {
            NodeList childList = currentElement.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                String nodetagname;
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element) || (nodetagname = w3cNode.getNodeName()) == null || !nodetagname.equals(nodeName)) continue;
                if (attrValue != null) {
                    String nodeattrname = ((Element)w3cNode).getAttribute(attrName);
                    if (nodeattrname == null || !nodeattrname.equals(attrValue)) continue;
                    return (Element)w3cNode;
                }
                return (Element)w3cNode;
            }
        }
        return null;
    }

    public static Element getDocElementFromXMLString(String xmlstr) {
        Element rootElem = null;
        try {
            Document inputDoc = XMLUtils.xmlStringToDocument(xmlstr);
            if (inputDoc != null) {
                rootElem = inputDoc.getDocumentElement();
            }
        }
        catch (Exception e) {
            LOG.error("getValueElemFromXMLString(). Failed to convert the following string to XML Document: \r\n" + xmlstr + "\r\n root cause: " + e.getMessage());
            rootElem = null;
        }
        return rootElem;
    }

    public static Map<String, String> getNamespaceNameNId(String aaaXML) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        Element authProvidersElem = XMLUtils.getAuthProviders(aaaXML);
        if (authProvidersElem != null) {
            NodeList instanceList = authProvidersElem.getElementsByTagName("crn:instance");
            for (int i = 0; i < instanceList.getLength(); ++i) {
                Element instanceElem = (Element)instanceList.item(i);
                String nsName = instanceElem.getAttribute("name");
                String nsId = XMLUtils.getParameterValue(instanceElem, "id");
                nsMap.put(nsName, nsId);
            }
        }
        return nsMap;
    }

    private static String getParameterValue(Element instanceElem, String parmName) {
        NodeList parmList = instanceElem.getElementsByTagName("crn:parameter");
        for (int i = 0; i < parmList.getLength(); ++i) {
            Element parmElem = (Element)parmList.item(i);
            if (!parmElem.getAttribute("name").equals(parmName)) continue;
            NodeList list = parmElem.getElementsByTagName("crn:value");
            if (list.getLength() < 1) {
                return "";
            }
            Element valueElem = (Element)list.item(0);
            return valueElem.getTextContent();
        }
        return null;
    }

    public static String addNSInstancesToAAA(String origAAASetting, ArrayList<String> instancesInXML) {
        String newAAASetting = "";
        int pos = origAAASetting.indexOf("</crn:instances>");
        StringBuffer newProvidersXML = new StringBuffer("");
        for (int i = 0; i < instancesInXML.size(); ++i) {
            String instanceXML = instancesInXML.get(i);
            newProvidersXML.append(instanceXML);
        }
        newAAASetting = origAAASetting.substring(0, pos) + newProvidersXML.toString() + origAAASetting.substring(pos);
        return newAAASetting;
    }

    public static Element createCFGArrayXMLElement(Element parmElem, JsonObject propValue) {
        Document originalDoc = parmElem.getOwnerDocument();
        Element valueElem = originalDoc.createElement("crn:value");
        valueElem.setAttribute("xsi:type", "cfg:array");
        for (String parmName : propValue.keySet()) {
            valueElem.appendChild(XMLUtils.createParmElement(originalDoc, parmName, propValue.getString(parmName)));
        }
        return valueElem;
    }

    private static Element createParmElement(Document originalDoc, String parmName, String value) {
        Element parmElem = originalDoc.createElement("crn:parameter");
        parmElem.setAttribute("name", parmName);
        Element valueElem = originalDoc.createElement("crn:value");
        valueElem.setAttribute("xsi:type", "xsd:string");
        valueElem.setTextContent(value);
        parmElem.appendChild(valueElem);
        return parmElem;
    }

    public static Element createTenancyInfoValueElement(Element parmElem, String tenancyPropName, String tenancyPropValue) {
        Document originalDoc = parmElem.getOwnerDocument();
        Element valueElem = originalDoc.createElement("crn:value");
        valueElem.setAttribute("xsi:type", "cfg:tenancyInfo");
        Element itemElem = originalDoc.createElement("crn:item");
        itemElem.setAttribute("name", tenancyPropName);
        itemElem.setTextContent(tenancyPropValue);
        valueElem.appendChild(itemElem);
        return valueElem;
    }

    public static String updateAAAAuthentication(JsonObject objectIn, String aaaSettings) throws ConfigurationException {
        Element valueElem;
        String sNewAAA = "";
        Element AAAElem = XMLUtils.getAAARoot(aaaSettings);
        boolean updated = false;
        if (AAAElem != null && (valueElem = (Element)AAAElem.getElementsByTagName("crn:value").item(0)) != null) {
            NodeList childList = valueElem.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                Element parmElem;
                Node w3cNode = childList.item(j);
                if (!(w3cNode instanceof Element) || !(parmElem = (Element)w3cNode).getTagName().equals("crn:parameter")) continue;
                updated = XMLUtils.updateElement(parmElem, objectIn) || updated;
            }
        }
        if (updated) {
            sNewAAA = XMLUtils.serializeToString(AAAElem);
        }
        return sNewAAA;
    }

    private static boolean updateElement(Element parmElem, JsonObject objectIn) {
        String parmName = parmElem.getAttribute("name");
        boolean updated = false;
        if (objectIn.get(parmName) != null) {
            Object valueToUpdate = objectIn.get(parmName);
            updated = XMLUtils.updateValueElem(parmElem, valueToUpdate, parmName);
        }
        return updated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean updateValueElem(Element parmElem, Object valueToUpdate, String parmName) {
        Element valueElem = (Element)parmElem.getElementsByTagName("crn:value").item(0);
        String parmType = valueElem.getAttribute("xsi:type");
        if (parmType.equals("cfg:array")) {
            if (!(valueToUpdate instanceof JsonObject)) {
                LOG.error("value for advancedProperties is invalid. Expecting JsonObject.");
                return false;
            }
            JsonObject propValue = (JsonObject)valueToUpdate;
            Element newValueElem = XMLUtils.createCFGArrayXMLElement(parmElem, propValue);
            LOG.debug("updating {} key with value {}", (Object)parmName, valueToUpdate);
            parmElem.replaceChild(newValueElem, valueElem);
            return true;
        }
        if (parmType.equals("cfg:tenancyInfo")) {
            try {
                LOG.debug("updating {} key with value {}", (Object)parmName, valueToUpdate);
                XMLUtils.replaceTenancyValue(valueToUpdate, parmElem, parmName, valueElem);
                return true;
            }
            catch (ConfigurationException e) {
                LOG.error("Failed to update {}, due to {}", (Object)parmName, (Object)e.getMessage());
                return false;
            }
        }
        if (!parmType.equals("xsd:boolean")) {
            LOG.debug("updating {} key with value {}", (Object)parmName, valueToUpdate);
            valueElem.setTextContent(valueToUpdate.toString());
            return true;
        }
        String newValue = valueToUpdate.toString();
        if (!newValue.equalsIgnoreCase("true") && !newValue.equalsIgnoreCase("false")) {
            LOG.error("value, {}, for boolean type key, {} is invalid.", valueToUpdate, (Object)parmName);
            return false;
        }
        LOG.debug("updating {} key with value {}", (Object)parmName, valueToUpdate);
        valueElem.setTextContent(newValue);
        return true;
    }

    public static Element getAAARoot(String aaaSettings) throws ConfigurationException {
        Element rootElem = null;
        try {
            Document aaaDoc = XMLUtils.xmlStringToDocument(aaaSettings);
            rootElem = aaaDoc.getDocumentElement();
            String paramName = rootElem.getAttribute("name");
            if (!paramName.equals("AAA")) {
                LOG.error("Invalid AAA settings : {}", (Object)aaaSettings);
                throw new ConfigurationException("Invalid AAA XML settings to parse.");
            }
        }
        catch (Exception e) {
            LOG.error("Error occur when XML parsing aaaSettings: {}", (Object)aaaSettings);
            throw new ConfigurationException("Error parsing: " + aaaSettings);
        }
        return rootElem;
    }

    public static void replaceTenancyValue(Object parmValue, Element parmElem, String parmName, Element oldValueElem) throws ConfigurationException {
        if (!(parmValue instanceof JsonObject)) {
            String errorMsg = "value for field, " + parmName + " is invalid. Expecting JsonObject.";
            LOG.debug(errorMsg);
            throw new ConfigurationException(errorMsg);
        }
        JsonObject jsonObj = (JsonObject)parmValue;
        if (jsonObj.size() == 0) {
            return;
        }
        if (jsonObj.size() > 1) {
            String errorMsg = "value for field, " + parmName + " is invalid. Expecting maximum of one pair of value.";
            LOG.debug(errorMsg);
            throw new ConfigurationException(errorMsg);
        }
        if (jsonObj.size() == 1) {
            for (String tenancyInfoName : jsonObj.keySet()) {
                String value = jsonObj.getString(tenancyInfoName);
                Element valueElem = XMLUtils.createTenancyInfoValueElement(parmElem, tenancyInfoName, value);
                parmElem.replaceChild(valueElem, oldValueElem);
            }
        }
    }
}

