/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.Property;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DynamicSetProperty<T>
implements Property<Set<T>> {
    private volatile Set<T> values;
    private Set<T> defaultValues;
    private DynamicStringProperty delegate;
    private Splitter splitter;
    public static final String DEFAULT_DELIMITER = ",";
    private final List<Runnable> callbackList = Lists.newArrayList();

    public DynamicSetProperty(String propName, String defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicSetProperty(String propName, String defaultValue, String delimiterRegex) {
        this.splitter = Splitter.onPattern((String)delimiterRegex).omitEmptyStrings().trimResults();
        this.setup(propName, this.transform(this.split(defaultValue)), this.splitter);
    }

    public DynamicSetProperty(String propName, Set<T> defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicSetProperty(String propName, Set<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, delimiterRegex);
    }

    public DynamicSetProperty(String propName, Set<T> defaultValue, Splitter splitter) {
        this.setup(propName, defaultValue, splitter);
    }

    private void setup(String propName, Set<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, Splitter.onPattern((String)delimiterRegex).omitEmptyStrings().trimResults());
    }

    private void setup(String propName, Set<T> defaultValue, Splitter splitter) {
        this.defaultValues = defaultValue == null ? null : Collections.unmodifiableSet(new HashSet<T>(defaultValue));
        this.splitter = splitter;
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(propName, null);
        this.load();
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                DynamicSetProperty.this.propertyChangedInternal();
            }
        };
        this.delegate.addCallback(callback);
        this.callbackList.add(callback);
    }

    private void propertyChangedInternal() {
        this.load();
        this.propertyChanged();
    }

    protected void propertyChanged() {
    }

    public Set<T> get() {
        return this.values;
    }

    @Override
    public Set<T> getValue() {
        return this.get();
    }

    @Override
    public Set<T> getDefaultValue() {
        return this.defaultValues;
    }

    private Set<String> split(String value) {
        return Sets.newHashSet((Iterable)this.splitter.split((CharSequence)Strings.nullToEmpty((String)value)));
    }

    protected Set<T> transform(Set<String> stringValues) {
        HashSet<T> set = new HashSet<T>(stringValues.size());
        for (String s : stringValues) {
            set.add(this.from(s));
        }
        return Collections.unmodifiableSet(set);
    }

    protected void load() {
        this.values = this.delegate.get() == null ? this.defaultValues : this.transform(this.split(this.delegate.get()));
    }

    @Override
    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    @Override
    public void addCallback(Runnable callback) {
        if (callback != null) {
            this.delegate.addCallback(callback);
            this.callbackList.add(callback);
        }
    }

    @Override
    public void removeAllCallbacks() {
        for (Runnable callback : this.callbackList) {
            this.delegate.prop.removeCallback(callback);
        }
    }

    protected abstract T from(String var1);

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

