/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.appenders.LogJDBCAppender;
import com.cognos.indications.appenders.LogLocalUDPAppender;
import com.cognos.indications.appenders.LogTCPSocketAppender;
import com.cognos.indications.appenders.LogWindowsEventLogAppender;
import com.cognos.indications.dbstore.LogDbStoreFactory;
import com.cognos.indications.internal.AuditLoggerNameResolver;
import com.cognos.indications.internal.LogIPFUtils;
import com.cognos.indications.internal.config.LogIPFControlInternal;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.CronTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Protocol;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class LogIPFConfigure {
    private static final int DEFAULT_RSYSLOG_PORT = 514;
    private static final int MAX_CONNECTION_TIME = 60000;
    private static final String EMPTY_STRING = "";
    private static final String APPENDER_REF_TAG = "appender-ref";
    private static final String APPENDER_TAG = "appender";
    private static final String APPENDER_VALUE = "appender";
    private static final String LOGGER_VALUE = "logger";
    private static final String AUDITLEVEL = "logLevel";
    private static final String CLASS_ATTR = "class";
    private static final String CONFIGURATION_TAG = "log4j:configuration";
    private static final String PARAMETER_TAG = "parameter";
    private static final String IPF_TAG = "IPF";
    private static final String LABEL_ATTR = "label";
    private static final String LEVEL_TAG = "level";
    private static final String LAYOUT_TAG = "layout";
    private static final String LOGGER_TAG = "logger";
    private static final String CATEGORY_TAG = "category";
    private static final String LOGSERVERPORT = "logServerPort";
    private static final String NAME_ATTR = "name";
    private static final String PARAM_TAG = "param";
    private static final String FILTER_TAG = "filter";
    private static final String REF_ATTR = "ref";
    private static final String RENDERED_CLASS_ATTR = "renderedClass";
    private static final String RENDERER_TAG = "renderer";
    private static final String RENDERING_CLASS_ATTR = "renderingClass";
    private static final String VALUE_ATTR = "value";
    private static final String VALUE_TAG = "value";
    private static final String UTF8ENCODING_VALUE = "useUTF8Encoding";
    private static final String ENABLE_TCP_VALUE = "enableTCPConnection";
    private static final String ENABLE_SSL_VALUE = "enableServerSSL";
    private static final String WORKER_THREADS_VALUE = "workerThreads";
    private static final String ENABLE_VALUE = "enable";
    private static final String CRN_DBMS_APPENDER_CLASS = "ipf_database";
    private static final String CRN_FILE_APPENDER_CLASS = "file";
    private static final String CRN_NTEVENT_APPENDER_CLASS = "eventLog";
    private static final String CRN_REMOTE_APPENDER_CLASS = "consolidator";
    private static final String CRN_SYSLOG_APPENDER_CLASS = "sysLog";
    private static final String CRN_INSTANCE_TAG = "instance";
    private static final String CRN_INSTANCES_TAG = "instances";
    private static final String CRN_PARAMETER_TAG = "parameter";
    private static final String CRN_VALUE_TAG = "value";
    public static final String ELEM_CONFIG_LOGIN_ENTRY_NAME = "login.entry.name";
    public static final String ELEM_ADVANCED_PROPERTIES = "advancedProperties";
    public static final String FEEDBACK_APPENDER = "FeedbackAppender";
    protected static final Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    protected static final QName qnParameter = new QName("parameter", nsCRN);
    protected static final QName qnInstances = new QName("instances", nsCRN);
    protected static final QName qnInstance = new QName("instance", nsCRN);
    protected static final QName qnValue = new QName("value", nsCRN);
    private static int m_logServerPort = 9362;
    private static int m_logFeedbackPort = 9363;
    protected static int m_dispatcherPort = 9300;
    private static int m_serverWorkerThreads = 10;
    protected static boolean useEncryption = true;
    private static String auditLevel = "5";
    private static String auditRTUsageLevel = "";
    private static String auditAdminLevel = "";
    private static String auditOtherLevel = "";
    private static boolean m_useUTF8Encoding;
    private static boolean m_useTCPProtocol;
    private static boolean m_useSSL;
    private static boolean m_nativeQuery;
    private static boolean firstRuntimeInit;
    private static boolean m_firstRuntimeInit;
    public static Properties IPFPropRead;
    public static int DispatcherID;
    private static String m_dbInitializationStatus;
    private static String m_dbURL;
    private static String m_dbUser;
    private static String m_dbSpecifier;
    public static String m_LoginEntryName;
    public static Properties m_advancedProperties;
    private static String m_dbErrMessage;
    private static boolean m_serverFileAppenderExists;
    private static boolean m_serverDBAppenderExists;
    private static boolean m_serverDBAppenderDefined;
    private static boolean m_serverRemoteAppenderExists;
    private static boolean m_serverNTAppenderExists;
    private static boolean m_serverSyslogAppenderExists;
    private static int m_numberOfServerAppenders;
    private static Map<String, String> m_compServiceMap;
    private static Map<String, String> m_serviceLevelMap;
    public static boolean enableIPFDebug;
    static final LoggerContext IPFLoggerCtx;
    private static final AppenderRef[] NOREFS;

    protected static native int getDispatcherPID();

    private static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static boolean useUTF8encoding() {
        return m_useUTF8Encoding;
    }

    public static boolean isNativeQueryEnabled() {
        return m_nativeQuery;
    }

    public static boolean enableTCP() {
        return m_useTCPProtocol;
    }

    public static boolean enableSSL() {
        return m_useSSL;
    }

    public static int getServerPort() {
        return m_logServerPort;
    }

    public static int getDispatcherPort() {
        return m_dispatcherPort;
    }

    protected static int getFeedbackPort() {
        return m_logFeedbackPort;
    }

    public static int getServerWorkerThreads() {
        return m_serverWorkerThreads;
    }

    public static void setProcessID(int procID) {
        DispatcherID = procID;
    }

    public static SigningSession initCAMCrypto() {
        LogIPFLog.debug("LogIPFConfigure::initCAMCrypto() - begin.");
        SigningSession CAMSigningSession = null;
        try {
            CAMFactory cf = new CAMFactory();
            cf.initialize("<initializeDocument><serviceID>IPF</serviceID></initializeDocument>".getBytes());
            CAMSigningSession = cf.createSigningSession();
            if (CAMSigningSession == null) {
                LogIPFLog.error("LogIPFConfigure::initCAMCrypto() - Cannot create CAM signing session, m_CAMSigningSession is null.");
            } else {
                LogIPFLog.debug("LogIPFConfigure::initCAMCrypto() - succeed.");
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfigure::initCAMCrypto() - Cannot create CAM signing session.", e);
            CAMSigningSession = null;
        }
        return CAMSigningSession;
    }

    public static void closeFeedbackLoop() {
        Appender feedbackAppender;
        LogIPFLog.debug("closeFeedbackLoop() - is called...");
        Configuration config = IPFLoggerCtx.getConfiguration();
        try {
            Thread.sleep(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoggerConfig serverLoggerConfig = config.getLoggerConfig("server");
        if (serverLoggerConfig != null) {
            serverLoggerConfig.removeAppender(FEEDBACK_APPENDER);
            LogIPFLog.debug("closeFeedbackLoop() - FeedBackAppender is removed from 'server' configLogger.");
        }
        if (null != (feedbackAppender = config.getAppender(FEEDBACK_APPENDER))) {
            feedbackAppender.stop();
            LogIPFLog.debug("closeFeedbackLoop() - FeedBackAppender is stopped.");
        }
        LogIPFLog.debug("closeFeedbackLoop() - succeed.");
    }

    public static void openFeedbackLoop() {
        Configuration config = IPFLoggerCtx.getConfiguration();
        LoggerConfig serverLoggerConfig = config.getLoggerConfig("server");
        if (serverLoggerConfig != null && StringUtils.equals((String)serverLoggerConfig.getName(), (String)"server")) {
            LogLocalUDPAppender feedbackappender = LogLocalUDPAppender.createAppender(FEEDBACK_APPENDER, null);
            feedbackappender.setPort(m_logFeedbackPort);
            feedbackappender.setUseInProcessServer(false);
            feedbackappender.start();
            config.addAppender((Appender)feedbackappender);
            serverLoggerConfig.addAppender((Appender)feedbackappender, Level.FATAL, null);
            IPFLoggerCtx.updateLoggers();
            LogIPFLog.debug("openFeedbackLoop() - FeedBackAppender is added.");
        }
        LogIPFLog.debug("openFeedbackLoop() - succeed.");
    }

    public static synchronized void serverInit(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - begin");
        if (cclConfig == null) {
            LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - called with a NULL ICCLConfiguration, return");
            return;
        }
        LinkedList<Element> instanceElementList = new LinkedList<Element>();
        try {
            LogIPFConfigure.initializeIPFBootstrapParams(cclConfig, instanceElementList);
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::serverInit(cclConfig) - exception while calling initializeIPFBootstrapParams(): ", e);
            throw e;
        }
        LogIPFConfigure.generateServerConfig(instanceElementList);
        LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - end.");
    }

    public static void configWithDefaultClientSettings() {
        LogIPFLog.debug("LogIPFConfigure::configWithDefaultClientSettings() - begin.");
        Configuration config = IPFLoggerCtx.getConfiguration();
        config.removeLogger("Audit");
        String appenderName = "cogauditdefaultfile";
        Appender rfileappender = LogIPFConfigure.createRollingFileAppender(appenderName, "10 MB", "10", "../logs/cogaudit_log4j2_default.log");
        rfileappender.start();
        config.addAppender(rfileappender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)appenderName, null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfigNew = LoggerConfig.createLogger((boolean)true, (Level)Level.FATAL, (String)"Audit", null, (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfigNew.addAppender(rfileappender, null, null);
        loggerConfigNew.setAdditive(false);
        config.addLogger("Audit", loggerConfigNew);
        config.getRootLogger().setLevel(Level.OFF);
        IPFLoggerCtx.updateLoggers();
        LogIPFLog.debug("LogIPFConfigure::configWithDefaultClientSettings() - end.");
    }

    public static void clientInitialize(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfigure::clientInitialize(cclConfig) - begin.");
        if (cclConfig == null) {
            throw new CCLConfigurationException("cclConfig is null, failed to init IPF.");
        }
        try {
            boolean initStat = LogIPFConfigure.initialWithRuntimeConfig(cclConfig);
            if (!initStat) {
                LogIPFLog.debug("LogIPFConfigure::clientInitialize(cclConfig) - calling initialWithRuntimeConfig(cclConfig) and return false. ");
                return;
            }
            if (m_firstRuntimeInit) {
                m_firstRuntimeInit = false;
            }
            LogIPFConfigure.configClientSettings();
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::clientInitialize(cclConfig) - exception: ", e);
            throw e;
        }
        LogIPFConfigure.updateServiceLoggers();
        LogIPFControlInternal.notifyConfigObservers();
        LogIPFLog.debug("LogIPFConfigure::clientInitialize(cclConfig) - end.");
    }

    private static boolean initialWithRuntimeConfig(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfigure::initialWithRuntimeConfig(cclConfig) - begin.");
        if (m_firstRuntimeInit) {
            try {
                LogIPFConfigure.initializeIPFBootstrapParams(cclConfig, null);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.warn("LogIPFConfigure::initialWithRuntimeConfig(cclConfig) - Failed to get AUDIT LEVEL(S) from ICCLConfiguration; error ", e);
                throw e;
            }
        }
        Set<String> services = m_serviceLevelMap.keySet();
        Iterator servIter = services.iterator();
        String auditLevel = EMPTY_STRING;
        while (servIter.hasNext()) {
            try {
                String servName = (String)servIter.next();
                auditLevel = cclConfig.getValue(servName + "AuditLevel", true);
                LogIPFLog.debug("LogIPFConfiguration::initialWithRuntimeConfig(cclConfig) - For service [" + servName + "] level is [" + auditLevel + "]");
                if (null == auditLevel || auditLevel.length() == 0) continue;
                m_serviceLevelMap.put(servName, auditLevel);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfiguration::initialWithRuntimeConfig(cclConfig) - Failed to get AUDIT LEVEL(S) from ICCLConfiguration; error ", e);
                throw e;
            }
        }
        if (!m_firstRuntimeInit) {
            LogIPFLog.debug("LogIPFConfiguration::initialWithRuntimeConfig(cclConfig) - NOT firstRuntimeInit, update loggers and return false.");
            LogIPFConfigure.updateServiceLoggers();
            LogIPFControlInternal.notifyConfigObservers();
            return false;
        }
        LogIPFLog.debug("initialWithRuntimeConfig::initialWithRuntimeConfig(cclConfig) - end.");
        return true;
    }

    private static void configClientSettings() {
        LogIPFLog.debug("LogIPFConfiguration::configClientSettings() - begin.");
        try {
            Configuration config = IPFLoggerCtx.getConfiguration();
            Appender logserverappender = LogIPFConfigure.createLogServerAppender();
            if (logserverappender == null) {
                LogIPFLog.error("configClientSettings - Failed to create logserver remote appender.");
                return;
            }
            logserverappender.start();
            config.addAppender(logserverappender);
            Appender defaultfileAppender = config.getAppender("cogauditdefaultfile");
            if (null != defaultfileAppender) {
                defaultfileAppender.stop();
            }
            LoggerConfig loggerConfig = config.getLoggerConfig("Audit");
            loggerConfig.removeAppender("cogauditdefaultfile");
            config.removeLogger("Audit");
            AppenderRef ref = AppenderRef.createAppenderRef((String)"clientRemote", null, null);
            AppenderRef[] refs = new AppenderRef[]{ref};
            LoggerConfig loggerConfigNew = LoggerConfig.createLogger((boolean)true, (Level)Level.FATAL, (String)"Audit", null, (AppenderRef[])refs, null, (Configuration)config, null);
            loggerConfigNew.addAppender(logserverappender, null, null);
            loggerConfigNew.setAdditive(false);
            config.addLogger("Audit", loggerConfigNew);
            IPFLoggerCtx.updateLoggers();
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::configClientSettings() - exception while configure for client: ", e);
        }
        LogIPFLog.debug("LogIPFConfiguration::configClientSettings() - end.");
    }

    private static Appender createLogServerAppender() throws Exception {
        String ipaddrStr;
        if (!m_useTCPProtocol) {
            LogLocalUDPAppender udpappender = LogLocalUDPAppender.createAppender("clientRemote", null);
            udpappender.setPort(m_logServerPort);
            return udpappender;
        }
        try {
            ipaddrStr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFConfiguration::createLogServerAppender() - exception while get IP address: ", e);
            throw e;
        }
        LogTCPSocketAppender tcpappender = LogTCPSocketAppender.createAppender("clientRemote", null, ipaddrStr, m_logServerPort);
        tcpappender.setSecure(m_useSSL);
        return tcpappender;
    }

    public static String getLogFileFullPath(String relPath) {
        String fullpath = relPath;
        try {
            fullpath = CCLConfigurationFactory.getInstance().resolveEffectivePath(relPath);
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::getLogFileFullPath() - failed to get full path for '" + relPath + "' with exception: ", e);
        }
        return fullpath;
    }

    private static void generateServerConfig(List<Element> instanceElementList) {
        LogIPFLog.debug("LogIPFConfiguration::generateServerConfig() - begin.");
        if (null == instanceElementList) {
            LogIPFLog.warn("LogIPFConfiguration::generateServerConfig() - Logserver initialization: No appenders added");
            return;
        }
        try {
            Configuration config = IPFLoggerCtx.getConfiguration();
            config.removeLogger("server");
            List<Appender> appenders = LogIPFConfigure.addAppenders(instanceElementList, config);
            Appender cnfgFeedbackAppender = LogIPFConfigure.addCNFGFeedbackAppender(config);
            AppenderRef[] refs = new AppenderRef[appenders.size() + 1];
            int i = 0;
            for (Appender appender : appenders) {
                refs[i++] = AppenderRef.createAppenderRef((String)appender.getName(), null, null);
            }
            refs[i++] = AppenderRef.createAppenderRef((String)cnfgFeedbackAppender.getName(), (Level)Level.FATAL, null);
            LogIPFLog.debug("LogIPFConfiguration::generateServerConfig() - created " + i + " appenders. refs size = " + refs.length);
            LoggerConfig serverloggerConfig = LoggerConfig.createLogger((boolean)true, (Level)Level.DEBUG, (String)"server", null, (AppenderRef[])refs, null, (Configuration)config, null);
            for (Appender appender : appenders) {
                serverloggerConfig.addAppender(appender, null, null);
            }
            serverloggerConfig.addAppender(cnfgFeedbackAppender, Level.FATAL, LogIPFConfigure.createCnfgFeedbackAppenderFilter());
            serverloggerConfig.setAdditive(false);
            config.addLogger("server", serverloggerConfig);
            IPFLoggerCtx.updateLoggers();
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::generateServerConfig() - exception while configure for server: ", e);
        }
        LogIPFLog.debug("LogIPFConfiguration::generateServerConfig() - end.");
    }

    private static List<Appender> addAppenders(List<Element> instanceElementList, Configuration config) {
        ArrayList<Appender> addedAppenders = new ArrayList<Appender>();
        for (Element instanceElement : instanceElementList) {
            Appender remoteappender;
            if (null == instanceElement) continue;
            String classAttr = instanceElement.attribute(CLASS_ATTR).getValue();
            String nameAttr = instanceElement.attribute(NAME_ATTR).getValue();
            if (null == classAttr || null == nameAttr) continue;
            if (classAttr.equalsIgnoreCase(CRN_DBMS_APPENDER_CLASS)) {
                Element databaseInstancesElement = instanceElement.element(qnInstances);
                Element databaseInstanceElement = databaseInstancesElement.element(qnInstance);
                Appender jdbcappender = LogIPFConfigure.createJDBCAppender(nameAttr, databaseInstanceElement);
                if (jdbcappender == null) continue;
                jdbcappender.start();
                config.addAppender(jdbcappender);
                addedAppenders.add(jdbcappender);
                continue;
            }
            List instanceParameterElementList = instanceElement.elements(qnParameter);
            if (classAttr.equalsIgnoreCase(CRN_FILE_APPENDER_CLASS)) {
                Appender fileappender = LogIPFConfigure.createFileAppender(nameAttr, instanceParameterElementList);
                if (fileappender == null) continue;
                fileappender.start();
                config.addAppender(fileappender);
                addedAppenders.add(fileappender);
                continue;
            }
            if (classAttr.equalsIgnoreCase(CRN_NTEVENT_APPENDER_CLASS)) {
                Appender nteventappender = LogIPFConfigure.createNTEventLogAppender(nameAttr, instanceParameterElementList);
                if (nteventappender == null) continue;
                nteventappender.start();
                config.addAppender(nteventappender);
                addedAppenders.add(nteventappender);
                continue;
            }
            if (classAttr.equalsIgnoreCase(CRN_SYSLOG_APPENDER_CLASS)) {
                Appender syslogappender = LogIPFConfigure.createSyslogAppender(nameAttr, instanceParameterElementList);
                if (syslogappender == null) continue;
                syslogappender.start();
                config.addAppender(syslogappender);
                addedAppenders.add(syslogappender);
                continue;
            }
            if (!classAttr.equalsIgnoreCase(CRN_REMOTE_APPENDER_CLASS) || (remoteappender = LogIPFConfigure.createTcpConsolidatorAppender(nameAttr, instanceParameterElementList)) == null) continue;
            remoteappender.start();
            config.addAppender(remoteappender);
            addedAppenders.add(remoteappender);
        }
        return addedAppenders;
    }

    private static Appender createFileAppender(String appenderName, List<Element> parameterElementList) {
        LogIPFLog.debug("createFileAppender - begin");
        String sizeStr = EMPTY_STRING;
        String maxStr = EMPTY_STRING;
        String logfile = EMPTY_STRING;
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element parameterElement = parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if ("appenderName".equalsIgnoreCase(nameAttr)) {
                logfile = LogIPFConfigure.getLogFileFullPath(parameterValue);
                LogIPFConfigure.verifyPath(logfile);
                LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - Resolved file path : " + logfile);
                continue;
            }
            if ("appenderMaxSize".equalsIgnoreCase(nameAttr)) {
                int fileSize = 10;
                try {
                    fileSize = Integer.parseInt(parameterValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sizeStr = fileSize + " MB";
                LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - max file size : '" + sizeStr + "'");
                continue;
            }
            if ("appenderRollOver".equalsIgnoreCase(nameAttr)) {
                maxStr = parameterValue;
                LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - max number of log files : '" + maxStr + "'");
                continue;
            }
            if (!UTF8ENCODING_VALUE.equals(nameAttr)) continue;
            m_useUTF8Encoding = parameterValue.equalsIgnoreCase("true");
            LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - UTF8 encoding set to: " + m_useUTF8Encoding);
        }
        Appender rfileappender = LogIPFConfigure.createRollingFileAppender(appenderName, sizeStr, maxStr, logfile);
        LogIPFLog.debug("createFileAppender - end");
        return rfileappender;
    }

    private static Appender createRollingFileAppender(String appenderName, String sizeStr, String maxStr, String logfile) {
        LogIPFLog.debug("createRollingFileAppender - begin");
        String logfullpath = LogIPFConfigure.getLogFileFullPath(logfile);
        PatternLayout layout = m_useUTF8Encoding ? PatternLayout.newBuilder().withPattern("%msg%n%throwable").withCharset(Charset.forName("UTF-8")).build() : PatternLayout.newBuilder().withPattern("%msg%n%throwable").build();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)sizeStr);
        CronTriggeringPolicy cronPolicy = CronTriggeringPolicy.createPolicy((Configuration)IPFLoggerCtx.getConfiguration(), null, (String)"0 0 0 * * ?");
        CompositeTriggeringPolicy policies = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{policy, cronPolicy});
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMax(maxStr).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(appenderName)).setLayout((Layout)layout)).withPolicy((TriggeringPolicy)policies).withStrategy((RolloverStrategy)strategy).withFileName(logfullpath).withFilePattern(logfullpath + "_%d{yyyy-MM-dd}-%i.log.gz").build();
        LogIPFLog.debug("createRollingFileAppender with file '" + logfullpath + "' - end");
        return appender;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Map<String, String> parseDBParameters(Element dbInstanceElement) {
        int dbType;
        String dbConnectionStringUpd;
        String dbsslencryptionenabled;
        HashMap<String, String> dbParameterMap;
        block27: {
            int noOfTokens;
            StringTokenizer st;
            String loginEntryName;
            String databaseSpecifier;
            String databaseName;
            String serverHost;
            String databaseType;
            block31: {
                boolean isDB2Type2;
                block30: {
                    block29: {
                        block28: {
                            dbParameterMap = new HashMap<String, String>();
                            databaseType = dbInstanceElement.attributeValue(CLASS_ATTR);
                            List dbInstanceParameterElementList = dbInstanceElement.elements(qnParameter);
                            serverHost = EMPTY_STRING;
                            databaseName = EMPTY_STRING;
                            databaseSpecifier = EMPTY_STRING;
                            loginEntryName = EMPTY_STRING;
                            dbsslencryptionenabled = EMPTY_STRING;
                            dbParameterMap.put("username", EMPTY_STRING);
                            dbParameterMap.put("password", EMPTY_STRING);
                            dbParameterMap.put("server", serverHost);
                            dbParameterMap.put(NAME_ATTR, databaseName);
                            dbParameterMap.put("specifier", databaseSpecifier);
                            dbParameterMap.put("sslencryptionenabled", dbsslencryptionenabled);
                            for (Element paramElem : dbInstanceParameterElementList) {
                                String nameAttr = paramElem.attributeValue(NAME_ATTR);
                                if (null == nameAttr) continue;
                                Element valueElement = paramElem.element(qnValue);
                                if (nameAttr.equalsIgnoreCase("user")) {
                                    String dbUser;
                                    Element credentialElement = valueElement.element("credential");
                                    m_dbUser = dbUser = LogIPFConfigure.getElementText(credentialElement, "username");
                                    String dbPassword = LogIPFConfigure.getElementText(credentialElement, "password");
                                    dbParameterMap.put("username", dbUser);
                                    dbParameterMap.put("password", dbPassword);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("server")) {
                                    serverHost = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put("server", serverHost);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase(NAME_ATTR)) {
                                    databaseName = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put(NAME_ATTR, databaseName);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("specifier")) {
                                    databaseSpecifier = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put("specifier", databaseSpecifier);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("servicename")) {
                                    databaseName = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put(NAME_ATTR, databaseName);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("SSLencryptionEnabled")) {
                                    dbsslencryptionenabled = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put("sslencryptionenabled", dbsslencryptionenabled);
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase(ELEM_CONFIG_LOGIN_ENTRY_NAME)) {
                                    loginEntryName = LogIPFConfigure.getValueText(valueElement);
                                    dbParameterMap.put(ELEM_CONFIG_LOGIN_ENTRY_NAME, loginEntryName);
                                    continue;
                                }
                                if (!nameAttr.equalsIgnoreCase(ELEM_ADVANCED_PROPERTIES)) continue;
                                LogIPFConfigure.parseValueElement(valueElement);
                            }
                            m_dbSpecifier = (String)dbParameterMap.get("specifier");
                            m_LoginEntryName = (String)dbParameterMap.get(ELEM_CONFIG_LOGIN_ENTRY_NAME);
                            String driverString = IPFPropRead.getProperty("IPFDbDriver" + databaseType);
                            if (null == driverString || driverString.trim().length() == 0) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file is missing the " + databaseType + " driver");
                                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Available properties are:");
                                Enumeration<?> e = IPFPropRead.propertyNames();
                                while (true) {
                                    if (!e.hasMoreElements()) {
                                        return dbParameterMap;
                                    }
                                    LogIPFLog.debug(e.nextElement().toString());
                                }
                            }
                            dbParameterMap.put("driver", driverString);
                            String dbConnectionString = EMPTY_STRING;
                            isDB2Type2 = false;
                            if (databaseType.equalsIgnoreCase("db2") && serverHost.length() == 0) {
                                dbConnectionString = IPFPropRead.getProperty("IPFDatabase" + databaseType + "Type2");
                                isDB2Type2 = true;
                            } else {
                                dbConnectionString = IPFPropRead.getProperty("IPFDatabase" + databaseType);
                            }
                            if (null == dbConnectionString) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file is missing the " + databaseType + " connection string");
                                dbParameterMap.put("connection_string", null);
                                return dbParameterMap;
                            }
                            st = new StringTokenizer(dbConnectionString, "{}", false);
                            noOfTokens = st.countTokens();
                            dbConnectionStringUpd = st.nextToken();
                            st.nextToken();
                            dbType = 0;
                            if (!databaseType.equalsIgnoreCase("microsoft") || noOfTokens != 4) break block28;
                            dbType = 2;
                            if (serverHost.length() == 0) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the MSSQLDB database server and port from CFGAPI");
                                dbParameterMap.put("connection_string", null);
                                return dbParameterMap;
                            }
                            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - MSSQL db connection string : " + dbConnectionStringUpd);
                            break block27;
                        }
                        if (!databaseType.equalsIgnoreCase("microsoftwinauth") || noOfTokens != 5) break block29;
                        dbType = 7;
                        if (serverHost.length() == 0) {
                            LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the SSQLWinAuthDB database server and port from CFGAPI");
                            dbParameterMap.put("connection_string", null);
                            return dbParameterMap;
                        }
                        dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                        st.nextToken();
                        dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                        LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - MSSQL WinAuth connection string : " + dbConnectionStringUpd);
                        break block27;
                    }
                    if (!databaseType.equalsIgnoreCase("oracle") || noOfTokens != 4) break block30;
                    dbType = 1;
                    dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Oracle db connection string : " + dbConnectionStringUpd);
                    break block27;
                }
                if (!databaseType.equalsIgnoreCase("db2")) break block31;
                dbType = 3;
                if (isDB2Type2 && noOfTokens == 3) {
                    dbConnectionStringUpd = dbConnectionStringUpd + databaseName + st.nextToken();
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - DB2 db connection string with no sever(Type 2): " + dbConnectionStringUpd);
                    break block27;
                } else if (!isDB2Type2 && noOfTokens == 5) {
                    dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                    st.nextToken();
                    dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - DB2 db connection string with sever(Type 4): " + dbConnectionStringUpd);
                    break block27;
                } else {
                    LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - DB2 database connection string is wrong:" + dbConnectionStringUpd);
                    dbParameterMap.put("connection_string", null);
                    return dbParameterMap;
                }
            }
            if (databaseType.equalsIgnoreCase("informix") && noOfTokens == 5) {
                dbType = 8;
                dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                st.nextToken();
                dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Informix db connection string : " + dbConnectionStringUpd);
            } else if (databaseType.equalsIgnoreCase("oracleadvanced") && noOfTokens == 2) {
                dbType = 4;
                dbConnectionStringUpd = dbConnectionStringUpd + databaseSpecifier;
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Oracle Advanced db connection string : " + dbConnectionStringUpd);
            } else {
                if (!databaseType.equalsIgnoreCase("OracleKerberos")) {
                    LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file has corrupted entry for " + databaseType + " connection string");
                    dbParameterMap.put("connection_string", null);
                    return dbParameterMap;
                }
                dbType = 9;
                dbConnectionStringUpd = dbConnectionStringUpd + databaseSpecifier;
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - OracleKerberos db connection string : " + dbConnectionStringUpd + ", loggin entry : " + loginEntryName);
            }
        }
        if (dbsslencryptionenabled != null && dbsslencryptionenabled.equalsIgnoreCase("true")) {
            dbConnectionStringUpd = LogIPFConfigure.enableDBSSLEncryption(dbConnectionStringUpd, dbType);
            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - enable db ssl encryption: " + dbConnectionStringUpd);
        } else {
            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - do not enable db ssl encryption:" + dbConnectionStringUpd);
        }
        dbParameterMap.put("type", String.valueOf(dbType));
        dbParameterMap.put("connection_string", dbConnectionStringUpd);
        return dbParameterMap;
    }

    private static String getValueText(Element valueElement) {
        return Optional.ofNullable(valueElement.getText()).orElse(EMPTY_STRING);
    }

    private static void parseValueElement(Element valueElement) {
        List parameters;
        if (valueElement != null && valueElement.hasContent() && (parameters = valueElement.elements(qnParameter)) != null && !parameters.isEmpty()) {
            m_advancedProperties = new Properties();
            for (Element param : parameters) {
                String nameAttr = param.attributeValue(NAME_ATTR);
                Element valueElem = param.element(qnValue);
                m_advancedProperties.put(nameAttr, LogIPFConfigure.getValueText(valueElem));
            }
        }
    }

    private static String getElementText(Element element, String key) {
        return Optional.ofNullable(element.elementText(key)).orElse(EMPTY_STRING);
    }

    private static Appender createJDBCAppender(String appenderName, Element dbInstanceElement) {
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - begin.");
        Map<String, String> dbParameterMap = LogIPFConfigure.parseDBParameters(dbInstanceElement);
        String serverHost = dbParameterMap.get("server");
        String databaseName = dbParameterMap.get(NAME_ATTR);
        String dbUser = dbParameterMap.get("username");
        String dbPassword = dbParameterMap.get("password");
        String dbType = dbParameterMap.get("type");
        String driverString = dbParameterMap.get("driver");
        if (!StringUtils.isNotBlank((String)driverString)) {
            m_dbURL = serverHost + " " + databaseName;
            LogIPFLog.error("LogIPFConfiguration::createJDBCAppender() - DB driver is invalid. Set m_dbURL to '" + m_dbURL + "', return null");
            return null;
        }
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - Setting DB Driver to: " + driverString);
        String dbConnectionString = dbParameterMap.get("connection_string");
        if (StringUtils.isBlank((String)dbConnectionString)) {
            m_dbURL = serverHost + " " + databaseName;
            LogIPFLog.error("LogIPFConfiguration::createJDBCAppender() - DB connection string is invalid. Set m_dbURL to '" + m_dbURL + "', return null");
            return null;
        }
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - Setting DB Connection to: " + dbConnectionString);
        m_dbURL = dbConnectionString;
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - create db store factory with ('" + appenderName + "', '" + m_dbURL + "', " + dbType + "', '" + driverString + "', '" + dbUser + "', '" + dbPassword + "', '" + dbParameterMap.get(ELEM_CONFIG_LOGIN_ENTRY_NAME) + "', '" + m_advancedProperties + "') \n");
        LogDbStoreFactory dbstoreFactory = LogDbStoreFactory.createFactory(appenderName, m_dbURL, dbType, driverString, dbUser, dbPassword, dbParameterMap.get(ELEM_CONFIG_LOGIN_ENTRY_NAME), m_advancedProperties);
        LogJDBCAppender jdbcappender = LogJDBCAppender.createAppender(appenderName, null, dbstoreFactory);
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - end.");
        return jdbcappender;
    }

    private static Appender createNTEventLogAppender(String appenderName, List<Element> parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createNTEventLogAppender() - begin.");
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%msg%n%throwable").build();
        String logServer = IPF_TAG;
        String logsource = "IBM Cognos";
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element parameterElement = parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr || !"logSource".equals(nameAttr)) continue;
            logsource = parameterElement.elementText(qnValue);
        }
        LogWindowsEventLogAppender eventAppender = LogWindowsEventLogAppender.createAppender(appenderName, null, (Layout<String>)layout, logServer, logsource);
        LogIPFLog.debug("LogIPFConfiguration::createNTEventLogAppender() - end.");
        return eventAppender;
    }

    private static Appender createSyslogAppender(String appenderName, List<Element> parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createSyslogAppender() - begin.");
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%msg%n%throwable").build();
        String sysLogHost = EMPTY_STRING;
        String facility = EMPTY_STRING;
        String facilityPrinting = EMPTY_STRING;
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element parameterElement = parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if (nameAttr.equalsIgnoreCase("host")) {
                sysLogHost = parameterValue;
                continue;
            }
            if (nameAttr.equalsIgnoreCase("facility")) {
                facility = parameterValue;
                continue;
            }
            if (!nameAttr.equalsIgnoreCase("facilityPrinting")) continue;
            facilityPrinting = parameterValue;
        }
        SyslogAppender syslogappener = ((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)SyslogAppender.newSyslogAppenderBuilder().setAppName("IBM Cognos").setId("1000").setLayout((Layout)layout)).setIgnoreExceptions(false)).setNewLine(true).setFacility(Facility.valueOf((String)facility)).setName("syslogappender")).withConnectTimeoutMillis(60000)).withPort(514)).withHost(sysLogHost)).withAdvertise(false)).withProtocol(Protocol.UDP)).build();
        LogIPFLog.debug("LogIPFConfiguration::createSyslogAppender() - end.");
        return syslogappener;
    }

    private static Appender createTcpConsolidatorAppender(String appenderName, List<Element> parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createTcpConsolidatorAppender() - begin.");
        String remoteHost = EMPTY_STRING;
        int port = 0;
        int consolidatorReconnectionDelay = 0;
        boolean useSSL = false;
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element parameterElement = parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if ("consolidatorConnection".equalsIgnoreCase(nameAttr)) {
                int delPos = parameterValue.lastIndexOf(":");
                String hostStr = parameterValue.substring(0, delPos);
                if (hostStr.startsWith("[") && hostStr.endsWith("]")) {
                    hostStr = hostStr.substring(1, hostStr.length() - 1);
                }
                remoteHost = hostStr;
                String portstr = parameterValue.substring(delPos + 1);
                try {
                    port = Integer.parseInt(portstr);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if ("consolidatorReconnectionDelay".equalsIgnoreCase(nameAttr)) {
                int reconnDelay = 30;
                try {
                    reconnDelay = Integer.parseInt(parameterValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                consolidatorReconnectionDelay = reconnDelay *= 1000;
                continue;
            }
            if (!nameAttr.equalsIgnoreCase("enableConsolidatorSSL")) continue;
            useSSL = "True".equalsIgnoreCase(parameterValue);
        }
        LogTCPSocketAppender tcpappender = LogTCPSocketAppender.createAppender(appenderName, null, remoteHost, port);
        tcpappender.setSecure(useSSL);
        tcpappender.setReconnectionDelay(consolidatorReconnectionDelay);
        LogIPFLog.debug("LogIPFConfiguration::createTcpConsolidatorAppender(" + appenderName + "), host = " + remoteHost + ", port = " + port + ", usessl = " + useSSL + ", reconnDelay = " + consolidatorReconnectionDelay);
        LogIPFLog.debug("LogIPFConfiguration::createTcpConsolidatorAppender() - end.");
        return tcpappender;
    }

    private static Appender addCNFGFeedbackAppender(Configuration config) {
        LogIPFLog.debug("LogIPFConfiguration::addCNFGFeedbackAppender() - begin with feedbackPort = " + m_logFeedbackPort);
        LogLocalUDPAppender udpappender = LogLocalUDPAppender.createAppender(FEEDBACK_APPENDER, null);
        udpappender.setPort(m_logFeedbackPort);
        udpappender.setUseInProcessServer(false);
        udpappender.start();
        config.addAppender((Appender)udpappender);
        LogIPFLog.debug("LogIPFConfiguration::addCNFGFeedbackAppender() - end.");
        return udpappender;
    }

    private static Filter createCnfgFeedbackAppenderFilter() {
        LogIPFLog.error("createCnfgFeedbackAppenderFilter - is called.");
        try {
            RegexFilter regexFilter = RegexFilter.createFilter((String)".*UpgradeDetails.*", null, (Boolean)false, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.ACCEPT);
            return regexFilter;
        }
        catch (Exception e) {
            LogIPFLog.error("createCnfgFeedbackAppenderFilter - failed , return null.", e);
            return null;
        }
    }

    private static String enableDBSSLEncryption(String dbURL, int dbType) {
        StringBuffer tmp = new StringBuffer(dbURL);
        if (dbType == 2 || dbType == 7) {
            String ssl = IPFPropRead.getProperty("IPFDatabaseMicrosoftSSL");
            tmp.append(ssl);
        } else if (dbType == 3 || dbType == 8) {
            String ssl = IPFPropRead.getProperty("IPFDatabaseDB2SSL");
            tmp.append(ssl);
        } else if (dbType == 4) {
            LogIPFConfigure.addOraclePKIProvider();
        }
        return tmp.toString();
    }

    private static void addOraclePKIProvider() {
        try {
            String oraclePKIProviderClassPath = IPFPropRead.getProperty("OraclePKIProvider");
            Security.addProvider((Provider)Class.forName(oraclePKIProviderClassPath).newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setUseEncryptonForTesting(boolean useEnc) {
        useEncryption = useEnc;
    }

    public static Element parseIPFStartupParams(ICCLConfiguration cclConfig, List<Element> instanceElementList) throws CCLConfigurationException {
        Element configElement;
        LogIPFLog.debug("LogIPFConfiguration::parseIPFStartupParams() - start.");
        if (cclConfig == null) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - ICCLConfiguration is null.");
            throw new CCLConfigurationException(9);
        }
        try {
            configElement = cclConfig.getValueElement(IPF_TAG, useEncryption);
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - Failed to read IPF startup parameters from ICCLConfiguration; error ", e);
            throw e;
        }
        if (null == configElement) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - ICCLConfiguration returned no IPF startup parameters");
            throw new CCLConfigurationException(9);
        }
        if (null != instanceElementList) {
            List instancesElementList = configElement.elements(qnInstances);
            int length = instancesElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                Element instancesElement = (Element)instancesElementList.get(loop);
                String nameAttr = instancesElement.attributeValue(NAME_ATTR);
                if (null == nameAttr || !nameAttr.equals("appender")) continue;
                instanceElementList.addAll(instancesElement.elements(qnInstance));
                break;
            }
        }
        LogIPFLog.debug("LogIPFConfiguration::parseIPFStartupParams() - end.");
        return configElement;
    }

    private static void verifyPath(String pathStr) {
        File parentPath = new File(pathStr).getParentFile();
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
    }

    private static void initializeIPFBootstrapParams(ICCLConfiguration cclConfig, List<Element> instanceElementList) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - begin.");
        String feedbackPortStr = null;
        try {
            feedbackPortStr = cclConfig.getValue("feedbackPort", false);
            if (null != feedbackPortStr && feedbackPortStr.length() != 0) {
                m_logFeedbackPort = Integer.parseInt(feedbackPortStr);
            }
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::initializeIPFBootstrapParams() - Failed to read feedbackPort from ICCLConfiguration; error ", e);
            throw e;
        }
        Element configElement = LogIPFConfigure.parseIPFStartupParams(cclConfig, instanceElementList);
        List parameterElementList = configElement.elements(qnParameter);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element parameterElement = (Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            if (nameAttr.equals(LOGSERVERPORT)) {
                String logServerPortString = parameterElement.elementText(qnValue);
                m_logServerPort = Integer.parseInt(logServerPortString);
                LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Log Server Port is: " + logServerPortString);
                continue;
            }
            if (nameAttr.equals(ENABLE_TCP_VALUE)) {
                String useTCPS = parameterElement.elementText(qnValue);
                m_useTCPProtocol = useTCPS.equalsIgnoreCase("true");
                LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Using TCP protocol: " + m_useTCPProtocol);
                continue;
            }
            if (!nameAttr.equals(WORKER_THREADS_VALUE)) continue;
            String workerThreadsString = parameterElement.elementText(qnValue);
            m_serverWorkerThreads = Integer.parseInt(workerThreadsString);
            LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Number of Server Worker Threads is: " + workerThreadsString);
        }
        m_useSSL = cclConfig.isInternalSSL();
        LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - end.");
    }

    public static void showDoc(Document doc) {
        if (doc != null) {
            try {
                System.out.println(doc.asXML());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String dumpAsXML(Element theElement) {
        String sResultXML = EMPTY_STRING;
        int XML_DOC_SIZE = 8192;
        StringWriter sw = new StringWriter(XML_DOC_SIZE);
        OutputFormat prettyformat = OutputFormat.createPrettyPrint();
        prettyformat.setSuppressDeclaration(false);
        XMLWriter writer = new XMLWriter((Writer)sw, prettyformat);
        boolean bSuccess = true;
        try {
            writer.write(theElement);
            writer.close();
        }
        catch (IOException e) {
            bSuccess = false;
        }
        if (bSuccess) {
            sResultXML = sw.toString();
        }
        return sResultXML;
    }

    private static String convertToUnixStyleSep(String winStyleStr) {
        StringTokenizer st = new StringTokenizer(winStyleStr, "\\", false);
        int noOfTokens = st.countTokens();
        String unixStyleStr = st.nextToken();
        for (int ii = 0; ii < noOfTokens - 1; ++ii) {
            unixStyleStr = unixStyleStr + "/" + st.nextToken();
        }
        return unixStyleStr;
    }

    public static Level convertIPFBeLevelToLog4jLevel(String ipfLevel) {
        if (ipfLevel.equalsIgnoreCase("minimal")) {
            return Level.FATAL;
        }
        if (ipfLevel.equalsIgnoreCase("basic")) {
            return Level.WARN;
        }
        if (ipfLevel.equalsIgnoreCase("request")) {
            return Level.INFO;
        }
        if (ipfLevel.equalsIgnoreCase("trace")) {
            return Level.DEBUG;
        }
        if (ipfLevel.equalsIgnoreCase("full")) {
            return Level.DEBUG;
        }
        return Level.FATAL;
    }

    public static void configAndInitIPFLoggers(String configFilename) {
        LoggerConfig auditConfig;
        if (LogIPFConfigure.configWithConfigFile(configFilename) && (auditConfig = IPFLoggerCtx.getConfiguration().getLoggerConfig("Audit")) != null && "Audit".equals(auditConfig.getName())) {
            auditConfig.setAdditive(false);
        }
    }

    public static boolean configWithConfigFile(String filename) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                URI fileuri = file.toURI();
                Configurator.reconfigure((URI)fileuri);
                LogIPFLog.debug("configWithConfigFile(" + filename + ") - succeed.");
                return true;
            }
            LogIPFLog.error("Configuration file '" + filename + "' does not exist. Failed to configure IPF logging.");
        }
        catch (Exception ex) {
            LogIPFLog.error("Failed to configure IPF logging with file '" + filename + "'. ", ex);
        }
        return false;
    }

    public static void stopIPFLoggers() {
        LogManager.shutdown();
    }

    public static String getDBURL() {
        return m_dbURL;
    }

    public static String getDBUser() {
        return m_dbUser;
    }

    public static String getDBSpecifier() {
        return m_dbSpecifier;
    }

    public static String getLoginEntryName() {
        return m_LoginEntryName;
    }

    public static Properties getAdvancedProperties() {
        return m_advancedProperties;
    }

    public static String getDBInitializationStatus() {
        return m_dbInitializationStatus;
    }

    public static String getDBErrorMessage() {
        return m_dbErrMessage;
    }

    public static boolean isDBAppenderDefined() {
        return m_serverDBAppenderDefined;
    }

    private static void updateLoggers(Configuration config, String serviceStr, Level someLevel) {
        LogIPFLog.debug("updateLoggers() - update for service '" + serviceStr + "' with level " + someLevel);
        for (String prefix : AuditLoggerNameResolver.getStdStr()) {
            String loggerName = prefix + serviceStr;
            LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
            if (loggerConfig.getLevel().equals((Object)someLevel)) continue;
            if (loggerConfig.getName().equals(loggerName)) {
                loggerConfig.setLevel(someLevel);
                continue;
            }
            loggerConfig = LoggerConfig.createLogger((boolean)true, (Level)someLevel, (String)loggerName, null, (AppenderRef[])NOREFS, null, (Configuration)config, null);
            config.addLogger(loggerName, loggerConfig);
        }
    }

    private static void updateRequestLoggers(Configuration config, String serviceLogger) {
    }

    public static String getServiceName(String componentName) {
        String servName = m_compServiceMap.get(componentName.toUpperCase());
        if (null == servName) {
            return EMPTY_STRING;
        }
        return servName;
    }

    static void updateServiceLoggers() {
        Configuration config = IPFLoggerCtx.getConfiguration();
        for (Map.Entry<String, String> serviceLevel : m_serviceLevelMap.entrySet()) {
            Level level = LogIPFConfigure.convertIPFBeLevelToLog4jLevel(serviceLevel.getValue());
            LogIPFConfigure.updateLoggers(config, serviceLevel.getKey(), level);
            LogIPFConfigure.updateRequestLoggers(config, serviceLevel.getKey());
        }
        LogIPFConfigure.updateSharedComponentLoggers(config);
        IPFLoggerCtx.updateLoggers();
    }

    private static void updateSharedComponentLoggers(Configuration config) {
        for (Map.Entry<String, String> compService : m_compServiceMap.entrySet()) {
            if (!compService.getValue().contains(";")) continue;
            LogIPFConfigure.updateLoggers(config, compService.getKey(), LogIPFConfigure.noisiestServiceLevel(compService.getValue().split(";")));
        }
    }

    static Level noisiestServiceLevel(String[] services) {
        Level result = Level.OFF;
        for (String service : services) {
            String strLevel = m_serviceLevelMap.get(service);
            Level level = LogIPFConfigure.convertIPFBeLevelToLog4jLevel(strLevel);
            if (!level.isLessSpecificThan(result)) continue;
            result = level;
        }
        return result;
    }

    private static void mergeDocs(Element startupJavaRoot, Element compRoot) {
        if (compRoot == null) {
            LogIPFLog.debug("LogIPFConfigure:mergeDocs -- the compRoot is null, return.");
            return;
        }
        List javaProc = compRoot.elements("process");
        if (javaProc != null) {
            for (int i = 0; i < javaProc.size(); ++i) {
                String procId;
                Element javaNode = (Element)javaProc.get(i);
                if (javaNode == null || javaNode.attribute("id") == null || (procId = javaNode.attribute("id").getStringValue()) == null || procId.compareToIgnoreCase("java") != 0) continue;
                List services = javaNode.elements("service");
                if (services == null) break;
                for (int j = 0; j < services.size(); ++j) {
                    Element servNode = (Element)services.get(j);
                    if (servNode == null) continue;
                    servNode.detach();
                    startupJavaRoot.add(servNode);
                }
                break;
            }
        }
    }

    private static void mergeStartup(String pathConfig, Element startupJavaRoot) throws Exception {
        if (startupJavaRoot == null) {
            LogIPFLog.debug("LogIPFConfigure:mergeStartup - the base startup java process node is null. Skip the merge.");
            return;
        }
        File configDir = new File(pathConfig);
        if (!configDir.exists()) {
            LogIPFLog.debug("LogIPFConfigure:mergeStartup - The configuration path 'configuration/logging' doesn't exist. Skip the merging part.");
            return;
        }
        ArrayList<File> startupFiles = LogIPFUtils.getXmlFiles(configDir);
        for (int i = 0; i < startupFiles.size(); ++i) {
            File sStartuptFile = startupFiles.get(i);
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(sStartuptFile.getCanonicalPath());
                Element compRootElement = doc.getRootElement();
                LogIPFConfigure.mergeDocs(startupJavaRoot, compRootElement);
                continue;
            }
            catch (Exception e) {
                LogIPFLog.warn("LogIPFConfigure:mergeStartup - The extension ipfstartup doc (" + sStartuptFile.getCanonicalPath() + " ) failed to load, continue to next file.", e);
            }
        }
    }

    private static void doStartup(String filename, String pathConfig) throws Exception {
        try {
            Element javaProcRoot;
            SAXReader reader = new SAXReader();
            Document doc = reader.read(filename);
            Element rootElement = doc.getRootElement();
            if (rootElement != null) {
                List javaProc = rootElement.elements("process");
                javaProcRoot = null;
                if (javaProc != null) {
                    for (int i = 0; i < javaProc.size(); ++i) {
                        String procId;
                        Element javaNode = (Element)javaProc.get(i);
                        if (javaNode == null || javaNode.attribute("id") == null || (procId = javaNode.attribute("id").getStringValue()) == null || procId.compareToIgnoreCase("java") != 0) continue;
                        javaProcRoot = javaNode;
                        break;
                    }
                }
            } else {
                LogIPFLog.error("LogIPFConfigure:doStartup - The file " + filename + " is not a valid xml file.");
                throw new CCLConfigurationException(9);
            }
            LogIPFConfigure.mergeStartup(pathConfig, javaProcRoot);
            LogIPFConfigure.parseIPFStartup(javaProcRoot);
        }
        catch (IOException e) {
            LogIPFLog.error("LogIPFConfiguration::doStartup() - Could not open [" + filename + "].", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::doStartup() - exception: ", e);
            throw e;
        }
    }

    private static void parseIPFStartup(Element javaProcRootElement) throws Exception {
        if (javaProcRootElement != null) {
            LogIPFLog.debug("LogIPFConfigure:parseIPFStartup - parse the java process node into m_compServiceMap. ");
            List services = javaProcRootElement.elements("service");
            int length = services.size();
            for (int loop = 0; loop < length; ++loop) {
                Element serviceNode = (Element)services.get(loop);
                if (serviceNode == null) continue;
                String serviceName = serviceNode.attribute("id").getStringValue();
                m_serviceLevelMap.put(serviceName, "Minimal");
                List compList = serviceNode.elements("component");
                int noOfComp = compList.size();
                for (int loop1 = 0; loop1 < noOfComp; ++loop1) {
                    Element compNode = (Element)compList.get(loop1);
                    if (compNode == null) continue;
                    String compName = compNode.attribute("id").getStringValue();
                    if (m_compServiceMap.containsKey(compName)) {
                        String oldValue = m_compServiceMap.get(compName);
                        m_compServiceMap.remove(compName);
                        m_compServiceMap.put(compName, oldValue + ";" + serviceName);
                        continue;
                    }
                    m_compServiceMap.put(compName, serviceName);
                }
            }
        } else {
            LogIPFLog.debug("LogIPFConfigure:parseIPFStartup - the java proc node is null, put the default values into m_compServiceMap. ");
            LogIPFConfigure.setDefaultServiceLevels();
        }
    }

    public static final void setDefaultServiceLevels() {
        m_compServiceMap.put("ASV", "as");
        m_compServiceMap.put("JSM", "as;ds;js;ms;ems");
        m_compServiceMap.put("DLS", "ds");
        m_compServiceMap.put("JS", "js");
        m_compServiceMap.put("MS", "ms");
        m_compServiceMap.put("EMS", "ems");
        m_compServiceMap.put("XTS", "ps");
        m_compServiceMap.put("VIEWER", "ps");
        m_compServiceMap.put("VALIDATOR", "ps");
        m_compServiceMap.put("BUX", "ps");
        m_compServiceMap.put("LOGSV", "ls");
        m_compServiceMap.put("CM", "cms");
        m_compServiceMap.put("JCAM", "cms");
        m_compServiceMap.put("CAM", "cms");
        m_compServiceMap.put("JCAMCRYPTO", "cms");
        m_compServiceMap.put("AAA", "cms");
        m_compServiceMap.put("RSPECUPGRADE", "cms");
        m_compServiceMap.put("DISP", "dispatcher");
        m_compServiceMap.put("dispatcher", "dispatcher");
        m_compServiceMap.put("CAF", "dispatcher");
        m_compServiceMap.put("MTE", "mms");
        m_compServiceMap.put("CMM", "mms");
        m_compServiceMap.put("MMPDFS", "mms");
        m_compServiceMap.put("DIS", "dis");
        m_compServiceMap.put("CCS", "rds");
        m_compServiceMap.put("IDS", "ids");
        m_compServiceMap.put("CSN", "ids;ius;iss");
        m_compServiceMap.put("IUS", "ius");
        m_compServiceMap.put("ISS", "iss");
        m_compServiceMap.put("MOB", "mbs");
        m_compServiceMap.put("DMS", "dms");
        m_compServiceMap.put("MIS", "mis");
        m_compServiceMap.put("MIGDEPLOY", "mis");
        m_compServiceMap.put("MIGRSVP", "mis");
        m_compServiceMap.put("MDSRV", "mds");
        m_compServiceMap.put("PDS", "pds");
        m_compServiceMap.put("PPS", "pps");
        m_compServiceMap.put("HTS", "hts");
        m_compServiceMap.put("ANS", "ans");
        m_serviceLevelMap.put("as", "Minimal");
        m_serviceLevelMap.put("cms", "Minimal");
        m_serviceLevelMap.put("dispatcher", "Minimal");
        m_serviceLevelMap.put("ds", "Minimal");
        m_serviceLevelMap.put("ems", "Minimal");
        m_serviceLevelMap.put("js", "Minimal");
        m_serviceLevelMap.put("ms", "Minimal");
        m_serviceLevelMap.put("mms", "Minimal");
        m_serviceLevelMap.put("dis", "Minimal");
        m_serviceLevelMap.put("ps", "Minimal");
        m_serviceLevelMap.put("rds", "Minimal");
        m_serviceLevelMap.put("ids", "Minimal");
        m_serviceLevelMap.put("ius", "Minimal");
        m_serviceLevelMap.put("iss", "Minimal");
        m_serviceLevelMap.put("mbs", "Minimal");
        m_serviceLevelMap.put("dms", "Minimal");
        m_serviceLevelMap.put("mis", "Minimal");
        m_serviceLevelMap.put("mds", "Minimal");
        m_serviceLevelMap.put("pds", "Minimal");
        m_serviceLevelMap.put("pps", "Minimal");
        m_serviceLevelMap.put("hts", "Minimal");
        m_serviceLevelMap.put("ans", "Minimal");
        m_serviceLevelMap.put("qs", "Minimal");
    }

    static void setServiceLevel(String service, String lvel) {
        List<String> allowed = Arrays.asList("minimal", "basic", "request", "trace", "full");
        if (!allowed.contains(lvel)) {
            throw new IllegalArgumentException("invalid level string");
        }
        if (!m_serviceLevelMap.containsKey(service)) {
            throw new IllegalArgumentException("unknown service");
        }
        m_serviceLevelMap.put(service, lvel);
    }

    static {
        m_nativeQuery = false;
        firstRuntimeInit = true;
        m_firstRuntimeInit = true;
        IPFPropRead = new Properties();
        DispatcherID = 0;
        m_dbInitializationStatus = EMPTY_STRING;
        m_dbURL = EMPTY_STRING;
        m_dbErrMessage = EMPTY_STRING;
        m_serverFileAppenderExists = false;
        m_serverDBAppenderExists = false;
        m_serverDBAppenderDefined = false;
        m_serverRemoteAppenderExists = false;
        m_serverNTAppenderExists = false;
        m_serverSyslogAppenderExists = false;
        m_numberOfServerAppenders = 0;
        m_compServiceMap = new ConcurrentHashMap<String, String>();
        m_serviceLevelMap = new ConcurrentHashMap<String, String>();
        enableIPFDebug = Boolean.getBoolean("com.ibm.cognos.ipf.enableDebug");
        IPFLoggerCtx = (LoggerContext)LogManager.getContext((boolean)false);
        NOREFS = new AppenderRef[0];
        try {
            ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
            myConf.init();
            String dispURLStr = null;
            String feedbackPortStr = null;
            try {
                dispURLStr = myConf.getValue("internalDispatcher", false);
                URL dispURL = new URL(dispURLStr);
                m_dispatcherPort = dispURL.getPort();
                if (m_dispatcherPort == -1) {
                    m_dispatcherPort = 0;
                }
                if (null != (feedbackPortStr = myConf.getValue("feedbackPort", false)) && feedbackPortStr.length() != 0) {
                    m_logFeedbackPort = Integer.parseInt(feedbackPortStr);
                }
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfigure initialization  - Failed to read Dispatcher URL ", e);
            }
            catch (MalformedURLException e) {
                m_dispatcherPort = 9300;
            }
            LogIPFConfigure.doStartup(myConf.resolveEffectivePath("../configuration/ipfstartup.xml"), myConf.resolveEffectivePath("../configuration/logging"));
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfigure initialization - ICCLConfiguration.init() call failed", e);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFConfigure initialization - Unknown error during initialization", e);
        }
        try {
            ResourceBundle resBund = ResourceBundle.getBundle("com.cognos.indications.IPFInternal", new Locale("ov", "CA"));
            Enumeration<String> parmNames = resBund.getKeys();
            while (parmNames.hasMoreElements()) {
                String parmName = parmNames.nextElement();
                String parmValue = resBund.getString(parmName);
                if (parmName == null || parmName.length() < 1) continue;
                IPFPropRead.remove(parmName);
                if (parmValue == null) {
                    IPFPropRead.setProperty(parmName, EMPTY_STRING);
                    continue;
                }
                IPFPropRead.setProperty(parmName, parmValue);
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFConfigure initialization - Unable to load resource bundle com.cognos.indications.IPFInternal(IPFInternal.properties). ", e);
        }
        LogIPFLog.debug("LogIPFConfigure initialization - before load lib LogIPFConfigure.dll(so)");
        try {
            System.loadLibrary("LogIPFConfigure");
            DispatcherID = LogIPFConfigure.getDispatcherPID();
        }
        catch (SecurityException e) {
            LogIPFLog.warn("LogIPFConfigure initialization - SecurityException when loading library - Java PID left 0", e);
        }
        catch (UnsatisfiedLinkError e) {
            LogIPFLog.error("LogIPFConfigure initialization - UnsatisfiedLinkError (" + e.getMessage() + ") Java PID left 9999", e);
            DispatcherID = 9999;
        }
        LogIPFLog.debug("LogIPFConfigure initialization - afer load lib LogIPFConfigure.dll(so)");
    }
}

