/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.indications.LogIPFConfigure;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogIPFLog {
    private static Logger m_ipfLogger = null;

    private static synchronized void initialize() {
        if (null == m_ipfLogger) {
            LogIPFLog.checkAndConfigIPFInternalLogger();
            m_ipfLogger = LogManager.getLogger((String)"CognosIPF.LogLogJava");
        }
    }

    public static void error(String msg) {
        if (LogIPFLog.isEnabled(Level.ERROR)) {
            m_ipfLogger.log(Level.ERROR, msg);
        }
    }

    public static void error(String msg, Throwable e) {
        if (LogIPFLog.isEnabled(Level.ERROR)) {
            m_ipfLogger.log(Level.ERROR, msg, e);
        }
    }

    public static void info(String msg) {
        if (LogIPFLog.isEnabled(Level.INFO)) {
            m_ipfLogger.log(Level.INFO, msg);
        }
    }

    public static void warn(String msg) {
        if (LogIPFLog.isEnabled(Level.WARN)) {
            m_ipfLogger.log(Level.WARN, msg);
        }
    }

    public static void warn(String msg, Throwable e) {
        if (LogIPFLog.isEnabled(Level.WARN)) {
            m_ipfLogger.log(Level.WARN, msg, e);
        }
    }

    public static void debug(String msg) {
        if (LogIPFLog.isEnabled(Level.DEBUG)) {
            m_ipfLogger.log(Level.DEBUG, msg);
        }
    }

    public static void debug(String msg, Throwable e) {
        if (LogIPFLog.isEnabled(Level.DEBUG)) {
            m_ipfLogger.log(Level.DEBUG, msg, e);
        }
    }

    public static boolean isEnabled(Level level) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        return null != m_ipfLogger && m_ipfLogger.isEnabled(level);
    }

    private static void checkAndConfigIPFInternalLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("CognosIPF.LogLogJava");
        if (!StringUtils.equals((String)loggerConfig.getName(), (String)"CognosIPF.LogLogJava")) {
            String logfullpath;
            PatternLayout layout = PatternLayout.newBuilder().withPattern("%d %-5r %-5p [%processId] [%t] - %m%n").build();
            try {
                logfullpath = CCLConfigurationFactory.getInstance().resolveEffectivePath("../logs/ipfInternal_java_default.log");
            }
            catch (Exception e) {
                logfullpath = "../logs/ipfInternal_java_default.log";
            }
            RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("ipfInternalLoggingFile4Java")).setLayout((Layout)layout)).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)"10 MB")).withFileName(logfullpath).withFilePattern(logfullpath + "_%d{yyyy-MM-dd}-%i.log.gz").build();
            appender.start();
            config.addAppender((Appender)appender);
            AppenderRef ref = AppenderRef.createAppenderRef((String)"ipfInternalLoggingFile4Java", null, null);
            AppenderRef[] refs = new AppenderRef[]{ref};
            Level ipfloglevel = LogIPFConfigure.enableIPFDebug ? Level.DEBUG : Level.ERROR;
            LoggerConfig loggerConfigNew = LoggerConfig.createLogger((boolean)true, (Level)ipfloglevel, (String)"CognosIPF.LogLogJava", null, (AppenderRef[])refs, null, (Configuration)config, null);
            loggerConfigNew.addAppender((Appender)appender, null, null);
            loggerConfigNew.setAdditive(false);
            config.addLogger("CognosIPF.LogLogJava", loggerConfigNew);
            ctx.updateLoggers();
        }
    }
}

