/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogIndication;
import com.cognos.indications.LogIndication;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogIndicationRenderer {
    private static final SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private LogIndicationRenderer() {
    }

    public static void render(StringBuilder msg, ILogIndication ind) {
        msg.append(ind.getIPAddrStr());
        msg.append(":").append(ind.getPort());
        msg.append('\t').append(ind.getProcID());
        msg.append('\t').append(m_formatter.format(new Date(ind.getTime())));
        short tz = ind.getTimeZoneOffset();
        if (tz >= 0) {
            msg.append('\t').append("+");
        } else {
            msg.append('\t');
        }
        int _hour = (tz - tz % 60) / 60;
        int _min = tz % 60;
        msg.append(_hour);
        if (_min != 0) {
            if (_min < 0) {
                _min = -1 * _min;
            }
            msg.append(":").append(_min);
        }
        msg.append('\t').append(ind.getRenderedSessionID());
        msg.append('\t').append(ind.getRequestID());
        msg.append('\t').append(ind.getSubRequestID());
        msg.append('\t').append(ind.getStepID());
        msg.append('\t').append(ind.getThreadID());
        msg.append('\t').append(ind.getComponentID());
        msg.append('\t').append(ind.getBuildNumber());
        msg.append('\t').append(LogIndication.toInteger(ind.getLevel()));
        msg.append('\t').append(ind.getLoggerName());
    }
}

